#import <Foundation/Foundation.h>
#import "LhaTestCase.h"
#import "LhaArchive.h"
#import "FileInfo.h"
#import "Preferences.h"

@implementation LhaTestCase : ArchiveTestCase

- (void)setUp;
{
	NSDictionary *defaults = [NSDictionary dictionaryWithObjectsAndKeys:
		@"/opt/bin/rar", PREF_KEY_RAR, nil];
	[Preferences usePreferences:defaults];
}

- (Archive *)sampleArchive;
{
	NSString *path;
	
    path = [NSBundle pathForResource:@"sample" ofType:@"lha" inDirectory:@"TestResources"];
    [self assertNotNil:path];
    path = [path stringByStandardizingPath];
    return [LhaArchive newWithPath:path];
}

- (void)testSortByRatio
{
	Archive *archive;
	FileInfo *info;
	
	archive = [self sampleArchive];
	[archive sortByRatio];
	info = [archive elementAtIndex:0];
	
	[self assert:[info ratio] equals:@"22.2%"];
	[self assert:[info filename] equals:@"junk.rc"];
	
	// sort descending
	[archive sortByRatio];
	info = [archive elementAtIndex:0];
	[self assert:[info ratio] equals:@"57.5%"];
	[self assert:[info filename] equals:@"vacation.rc"];
}

@end
