.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
topblock - a 3D world of falling blocks that build up and up.
.SH SYNOPSIS
.B topblock
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-wireframe]
[\-fps]
[\-size \fInumber\fP]
[\-spawn \fInumber\fP]
[\-camX \fInumber\fP]
[\-camY \fInumber\fP]
[\-camZ \fInumber\fP]
[\-rotate]
[\-no-carpet]
[\-no-nipples]
[\-blob]
[\-rotateSpeed \fInumber\fP]
[\-follow]
[\-maxFalling \fInumber\fP]
[\-resolution \fInumber\fP]
[\-maxColors \fInumber\fP]
[\-dropSpeed \fInumber\fP]
[\-override]
.SH DESCRIPTION
Creates a world of falling blocks that build up and up.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 10000 (0.01 seconds.).
.TP 8
.B \-wireframe | \-no-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.TP 8
.B \-size \fInumber\fP
Size of the base/carpet.
.TP 8
.B \-spawn \fInumber\fP
Likeyhood of a new block being created per frame : 1 high, 1000 very low.
.TP 8
.B \-camX \fInumber\fP
Initial camera X location in the world.
.TP 8
.B \-camY \fInumber\fP
Initial camera Y location in the world.
.TP 8
.B \-camZ \fInumber\fP
Initial camera Z location in the world.
.TP 8
.B \-rotate | -no-rotate
Add/Remove rotation to/from the animation.
.TP 8
.B \-no-carpet
Remove the base/carpet.
.TP 8
.B \-no-nipples
Remove nipples on the blocks (also applies to udders) (has no effect in blob mode).
.TP 8
.B \-blob
Run in blob mode, blocks become over sized spheres.
.TP 8
.B \-rotateSpeed \fInumber\fP
Varries speed of world rotation.
.TP 8
.B \-follow
Camera follows blocks as they fall instead of camera being semi static (stays with top block).
.TP 8
.B \-maxFalling \fInumber\fP
Maximum number of objects created before recycling occurs.
.TP 8
.B \-resolution \fInumber\fP
Resolution of tubes, disks and spheres.
.TP 8
.B \-maxColors \fInumber\fP
Number of different colors available to falling objects.
.TP 8
.B \-dropSpeed \fInumber\fP
Varries speed of falling objects.
.TP 8
.B \-override
Overrides camera settings and provides a tunnel view.

.SH KEYS
.PP
.TP 8
.B a
Increases viewing X coordinate.
.TP 8
.B z
Decreases viewing X coordinate.
.TP 8
.B s
Increases viewing Y coordinate.
.TP 8
.B x
Decreases viewing Y coordinate.
.TP 8
.B d
Increases viewing Z coordinate.
.TP 8
.B c
Decreases viewing Z coordinate.
.TP 8
.B f
Increases camera location X coordinate.
.TP 8
.B v
Decreases camera location X coordinate.
.TP 8
.B g
Increases camera location Y coordinate.
.TP 8
.B b
Decreases camera location Y coordinate.
.TP 8
.B h
Increases camera location Z coordinate.
.TP 8
.B n
Decreases camera location Z coordinate.
.TP 8
.B r
Increases world rotation.
.TP 8
.B q
quit.
.SH EXAMPLES
To see which block follow-mode is tracking, set the number of block colors to 1.
.TP 8
.B topblock -follow -maxColors 1
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2006 by rednuht.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
rednuht <topblock.xscreensaver@jumpstation.co.uk> 
<http://www.jumpstation.co.uk/xscreensaver/topblock/>
