/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;

public class Grid
extends Drawable {
    private Color gcol = new Color(220, 220, 220);
    private double xsp;
    private double ysp;
    private final int PIX_MAX = 80;
    private final int PIX_MIN = 20;

    public Grid() {
        this(1.0, 1.0);
    }

    public Grid(double d, double d2) {
        this.xsp = d;
        this.ysp = d2;
    }

    public Color getColor() {
        return this.gcol;
    }

    public void setColor(Color color) {
        if (color != null && !color.equals(this.gcol)) {
            this.gcol = color;
            this.needsRedraw();
        }
    }

    public double getXSP() {
        return this.xsp;
    }

    public double getYSP() {
        return this.ysp;
    }

    public void setXSP(double d) {
        this.xsp = d;
        this.needsRedraw();
    }

    public void setYSP(double d) {
        this.ysp = d;
        this.needsRedraw();
    }

    public void draw(Graphics graphics, boolean bl) {
        double d;
        int n;
        double d2;
        if (this.coords == null) {
            return;
        }
        double d3 = this.coords.getPixelWidth();
        double d4 = this.coords.getPixelHeight();
        if (Double.isNaN(d3) || Double.isNaN(d4) || Double.isInfinite(d4) || Double.isInfinite(d3) || d3 == 0.0 || d4 == 0.0) {
            return;
        }
        graphics.setColor(this.gcol);
        if (this.xsp > 0.0) {
            for (d2 = this.xsp; d2 > d3 * 80.0; d2 /= 10.0) {
            }
            if (d2 < d3 * 20.0) {
                d2 *= 5.0;
            }
            if (d2 > d3 * 80.0) {
                d2 /= 2.0;
            }
            n = (int)Math.ceil(this.coords.getXmin() / d2);
            d = (double)n * d2;
            while (this.coords.xToPixel(d) < this.coords.getWidth() + this.coords.getLeft()) {
                graphics.drawLine(this.coords.xToPixel(d), this.coords.getTop(), this.coords.xToPixel(d), this.coords.getTop() + this.coords.getHeight());
                d += d2;
            }
        }
        if (this.ysp > 0.0) {
            for (d2 = this.ysp; d2 > d4 * 80.0; d2 /= 10.0) {
            }
            if (d2 < d4 * 20.0) {
                d2 *= 5.0;
            }
            if (d2 > d4 * 80.0) {
                d2 /= 2.0;
            }
            n = (int)Math.ceil(this.coords.getYmin() / d2);
            d = (double)n * d2;
            while (this.coords.yToPixel(d) > this.coords.getTop()) {
                graphics.drawLine(this.coords.getLeft(), this.coords.yToPixel(d), this.coords.getLeft() + this.coords.getWidth(), this.coords.yToPixel(d));
                d += d2;
            }
        }
    }
}

