/*
 * NodeTUIComboBox.h
 *
 * Copyright (C) 1999 Stephen F. White, 2006 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 * 
 * Implements the Cover/Covise TUIComboBox node
 */

#ifndef _NODE_TUI_COMBO_BOX_H
#define _NODE_TUI_COMBO_BOX_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif

#include "SFMFTypes.h"

#include "TUIElement.h"

class ProtoTUIComboBox : public ProtoTUIElement {
public:
                    ProtoTUIComboBox(Scene *scene);
    virtual Node   *create(Scene *scene);

    virtual int     getType() const { return COVER_TUI_COMBO_BOX; }

    FieldIndex items;
    FieldIndex withNone;
    FieldIndex defaultChoice;
};

class NodeTUIComboBox : public TUIElement {
public:
                    NodeTUIComboBox(Scene *scene, Proto *proto);

    virtual Node   *copy() const { return new NodeTUIComboBox(*this); }

    fieldMacros(MFString, items,         ProtoTUIComboBox)
    fieldMacros(SFBool,   withNone,      ProtoTUIComboBox)
    fieldMacros(SFInt32,  defaultChoice, ProtoTUIComboBox)
};

#endif // _NODE_TUI_COMBO_BOX_H
