/*
 * DefDialog.cpp
 *
 * Copyright (C) 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "stdafx.h"

#include "resource.h"
#include "MyString.h"
#include "Path.h"
#include "Node.h"
#include "DefDialog.h"
#include "DuneApp.h"

DefDialog::DefDialog(SWND parent, Scene* scene)
  : Dialog(parent, IDD_DEF)
{
    _scene = scene;
    _node = _scene->getSelection()->getNode();
    _valid = false;
    LoadData();
}

DefDialog::~DefDialog()
{
}

bool
DefDialog::Validate()
{
    return _valid;
}

void
DefDialog::LoadData()
{
    if (_node->hasName())
        swSetText(swGetDialogItem(_dlg, IDC_DEF_NAME), _node->getName(false));
    else
        swSetText(swGetDialogItem(_dlg, IDC_DEF_NAME), 
                  _scene->getUniqueNodeName(_node));
}

void
DefDialog::SaveData()
{
    char name[1024] = "";
    swGetText(swGetDialogItem(_dlg, IDC_DEF_NAME), name, 1024);
    int positionInvalid = TheApp->searchIllegalChar(name);
    if (positionInvalid != -1) {
        _valid = false;
        char wrongChar[2];
        wrongChar[0] = name[positionInvalid];
        wrongChar[1] = 0;
        if (wrongChar[0] == ' ')
            TheApp->MessageBox(IDS_WRONG_SPACE_IN_DEF_ERROR, wrongChar);
        else
            TheApp->MessageBox(IDS_WRONG_DEF_ERROR, wrongChar);
    } else if ((_node->hasName()) && (strcmp(name, _node->getName()) == 0)) {
        _valid = true;
        _scene->def(_node);
    } else if (_scene->hasAlreadyName(name)) {
        _valid = false;
        TheApp->MessageBoxId(IDS_DEF_ALREADY_ERROR);
    } else {
        _valid = true;
        _scene->def(_node);
        _scene->def(name, _node);
    }
}

