/*
 *   VUOS: view OS project
 *   Copyright (C) 2017  Renzo Davoli <renzo@cs.unibo.it>, Antonio Cardace <anto.cardace@gmail.com>
 *   VirtualSquare team.
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <unistd.h>
#include <r_table.h>

/* r_table.h is automatically generated during the build process.
 * r_ stands for real system calls.
 * All the system call requestsgenerated by the hypervisor can be further
 * virtualized ***unless** they are real r_ system calls.
 * e.g. open(path ... ), may be processed by a module
 * r_open(path ...) always refers to the file "path" in the hosting operating system */

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wincompatible-pointer-types"
#if __STDC_VERSION__ >= 202000L
long (*native_syscall)(...) = syscall;
#else
long (*native_syscall)() = syscall;
#endif
#pragma GCC diagnostic pop
