/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.odejava.PlaceableGeom;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNBodyCollidableNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseCollidableNode
extends AbstractNode
implements VRMLNBodyCollidableNodeType {
    protected static final int FIELD_BBOX_SIZE = 1;
    protected static final int FIELD_BBOX_CENTER = 2;
    protected static final int FIELD_ENABLED = 3;
    protected static final int FIELD_ROTATION = 4;
    protected static final int FIELD_TRANSLATION = 5;
    protected static final int LAST_COLLIDABLE_INDEX = 5;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize;
    protected boolean vfEnabled = true;
    protected float[] vfTranslation = new float[3];
    protected float[] vfRotation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    protected PlaceableGeom odeGeom;
    protected Matrix4f tmatrix;
    private AxisAngle4f angleTmp;
    private Vector3f positionTmp;

    public BaseCollidableNode(String string) {
        super(string);
        this.vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.tmatrix = new Matrix4f();
        this.tmatrix.setIdentity();
        this.angleTmp = new AxisAngle4f();
        this.positionTmp = new Vector3f();
    }

    protected void copy(VRMLNBodyCollidableNodeType vRMLNBodyCollidableNodeType) {
        float[] fArray = vRMLNBodyCollidableNodeType.getTranslation();
        this.vfTranslation[0] = fArray[0];
        this.vfTranslation[1] = fArray[1];
        this.vfTranslation[2] = fArray[2];
        float[] fArray2 = vRMLNBodyCollidableNodeType.getRotation();
        this.vfRotation[0] = fArray2[0];
        this.vfRotation[1] = fArray2[1];
        this.vfRotation[2] = fArray2[2];
        this.vfRotation[3] = fArray2[3];
        float[] fArray3 = vRMLNBodyCollidableNodeType.getBboxCenter();
        this.vfBboxCenter[0] = fArray3[0];
        this.vfBboxCenter[1] = fArray3[1];
        this.vfBboxCenter[2] = fArray3[2];
        fArray3 = vRMLNBodyCollidableNodeType.getBboxSize();
        this.vfBboxSize[0] = fArray3[0];
        this.vfBboxSize[1] = fArray3[1];
        this.vfBboxSize[2] = fArray3[2];
    }

    public PlaceableGeom getODEGeometry() {
        return this.odeGeom;
    }

    public void updateFromODE() {
        if (!this.vfEnabled) {
            return;
        }
        this.odeGeom.getPosition(this.positionTmp);
        this.odeGeom.getAxisAngle(this.angleTmp);
        this.tmatrix.set(this.angleTmp);
        this.tmatrix.setTranslation(this.positionTmp);
        this.vfTranslation[0] = this.positionTmp.x;
        this.vfTranslation[1] = this.positionTmp.y;
        this.vfTranslation[2] = this.positionTmp.z;
        this.vfRotation[0] = this.angleTmp.x;
        this.vfRotation[1] = this.angleTmp.y;
        this.vfRotation[2] = this.angleTmp.z;
        this.vfRotation[3] = this.angleTmp.angle;
        this.hasChanged[5] = true;
        this.hasChanged[4] = true;
    }

    public void setEnabled(boolean bl) {
        if (bl != this.vfEnabled) {
            this.vfEnabled = bl;
            if (!this.inSetup) {
                if (this.odeGeom != null) {
                    this.odeGeom.setEnabled(this.vfEnabled);
                }
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
            }
        }
    }

    public boolean isEnabled() {
        return this.vfEnabled;
    }

    public void setRotation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Rotation value null");
        }
        this.vfRotation[0] = fArray[0];
        this.vfRotation[1] = fArray[1];
        this.vfRotation[2] = fArray[2];
        this.vfRotation[3] = fArray[3];
        if (!this.inSetup) {
            if (this.odeGeom != null) {
                this.odeGeom.setAxisAndAngle(this.vfRotation[0], this.vfRotation[1], this.vfRotation[2], this.vfRotation[3]);
            }
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public float[] getRotation() {
        return this.vfRotation;
    }

    public void setTranslation(float[] fArray) throws InvalidFieldValueException {
        if (fArray == null) {
            throw new InvalidFieldValueException("Translation value null");
        }
        this.vfTranslation[0] = fArray[0];
        this.vfTranslation[1] = fArray[1];
        this.vfTranslation[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeGeom != null) {
                this.odeGeom.setPosition(this.vfTranslation[0], this.vfTranslation[1], this.vfTranslation[2]);
            }
            this.stateManager.addEndOfThisFrameListener(this);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public float[] getTranslation() {
        return this.vfTranslation;
    }

    public float[] getBboxCenter() {
        return this.vfBboxCenter;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public void allEventsComplete() {
        this.updateMatrix();
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.updateMatrix();
        if (this.odeGeom != null) {
            this.odeGeom.setPosition(this.vfTranslation[0], this.vfTranslation[1], this.vfTranslation[2]);
            this.odeGeom.setAxisAndAngle(this.vfRotation[0], this.vfRotation[1], this.vfRotation[2], this.vfRotation[3]);
            this.odeGeom.setEnabled(this.vfEnabled);
        }
    }

    public int getPrimaryType() {
        return 84;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxSize;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBboxCenter;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 3: {
                vRMLFieldData.booleanValue = this.vfEnabled;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfRotation;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfTranslation;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfRotation, 4);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfTranslation, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Collidable.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Collidable.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setEnabled(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 2: {
                this.setBboxCenter(fArray);
                break;
            }
            case 1: {
                this.setBboxSize(fArray);
                break;
            }
            case 5: {
                this.setTranslation(fArray);
                break;
            }
            case 4: {
                this.setRotation(fArray);
            }
        }
    }

    protected void updateMatrix() {
        this.angleTmp.set(this.vfRotation);
        this.tmatrix.set(this.angleTmp);
        this.tmatrix.m03 = this.vfTranslation[0];
        this.tmatrix.m13 = this.vfTranslation[1];
        this.tmatrix.m23 = this.vfTranslation[2];
    }

    private void setBboxCenter(float[] fArray) {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  bboxCenter");
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    private void setBboxSize(float[] fArray) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  bboxSize");
        }
        FieldValidator.checkBBoxSize(this.getVRMLNodeName(), fArray);
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }
}

