// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SSUBW2_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SSUBW2_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_ssubw2_4S[] = {
  0xfffffe03, 0xffffff02, 0x007f7d01, 0x00000000,
  0xfffffe02, 0xffffff01, 0x007ffd00, 0xffffffff,
  0xfffffe01, 0x00007f00, 0x007ffcff, 0xfffffffe,
  0x00007e00, 0x00007eff, 0x007ffcfe, 0xfffffff0,
  0x00007dff, 0x00007efe, 0x007ffcf0, 0xffffff83,
  0x00007dfe, 0x00007ef0, 0x007ffc83, 0xffffff82,
  0x00007df0, 0x00007e83, 0x007ffc82, 0xffffff81,
  0x00007d83, 0x00007e82, 0x007ffc81, 0xffffcccd,
  0x00007d82, 0x00007e81, 0x007fc9cd, 0xffffaaab,
  0x00007d81, 0x00004bcd, 0x007fa7ab, 0xffff8003,
  0x00004acd, 0x000029ab, 0x007f7d03, 0xffff8002,
  0x000028ab, 0xffffff03, 0x007f7d02, 0xffff8001,
  0xfffffe03, 0xffffff02, 0x007f7d01, 0x00008000,
  0xfffffe02, 0xffffff01, 0x00807d00, 0x00007fff,
  0xfffffe01, 0x0000ff00, 0x00807cff, 0x00005556,
  0x0000fe00, 0x0000feff, 0x00805256, 0x00003334,
  0x0000fdff, 0x0000d456, 0x00803034, 0x00000080,
  0x0000d356, 0x0000b234, 0x007ffd80, 0x0000007f,
  0x0000b134, 0x00007f80, 0x007ffd7f, 0x0000007e,
  0x00007e80, 0x00007f7f, 0x007ffd7e, 0x0000007d,
  0x00007e7f, 0x00007f7e, 0x007ffd7d, 0x00000010,
  0x00007e7e, 0x00007f7d, 0x007ffd10, 0x00000003,
  0x00007e7d, 0x00007f10, 0x007ffd03, 0x00000002,
  0x00007e10, 0x00007f03, 0x007ffd02, 0x00000001,
  0x00007f03, 0x007ffd02, 0x00000001, 0x00000001,
  0x00007f02, 0x007ffd01, 0x00000000, 0x00000000,
  0x00007f01, 0x007ffd00, 0xffffffff, 0xffffffff,
  0x00007f00, 0x007ffcff, 0xfffffffe, 0xfffffff1,
  0x00007eff, 0x007ffcfe, 0xfffffff0, 0xffffff84,
  0x00007efe, 0x007ffcf0, 0xffffff83, 0xffffff83,
  0x00007ef0, 0x007ffc83, 0xffffff82, 0xffffff82,
  0x00007e83, 0x007ffc82, 0xffffff81, 0xffffccce,
  0x00007e82, 0x007ffc81, 0xffffcccd, 0xffffaaac,
  0x00007e81, 0x007fc9cd, 0xffffaaab, 0xffff8004,
  0x00004bcd, 0x007fa7ab, 0xffff8003, 0xffff8003,
  0x000029ab, 0x007f7d03, 0xffff8002, 0xffff8002,
  0xffffff03, 0x007f7d02, 0xffff8001, 0x00008001,
  0xffffff02, 0x007f7d01, 0x00008000, 0x00008000,
  0xffffff01, 0x00807d00, 0x00007fff, 0x00005557,
  0x0000ff00, 0x00807cff, 0x00005556, 0x00003335,
  0x0000feff, 0x00805256, 0x00003334, 0x00000081,
  0x0000d456, 0x00803034, 0x00000080, 0x00000080,
  0x0000b234, 0x007ffd80, 0x0000007f, 0x0000007f,
  0x00007f80, 0x007ffd7f, 0x0000007e, 0x0000007e,
  0x00007f7f, 0x007ffd7e, 0x0000007d, 0x00000011,
  0x00007f7e, 0x007ffd7d, 0x00000010, 0x00000004,
  0x00007f7d, 0x007ffd10, 0x00000003, 0x00000003,
  0x00007f10, 0x007ffd03, 0x00000002, 0x00000002,
  0x007ffd03, 0x00000002, 0x00000002, 0x00000002,
  0x007ffd02, 0x00000001, 0x00000001, 0x00000001,
  0x007ffd01, 0x00000000, 0x00000000, 0x00000000,
  0x007ffd00, 0xffffffff, 0xffffffff, 0xfffffff2,
  0x007ffcff, 0xfffffffe, 0xfffffff1, 0xffffff85,
  0x007ffcfe, 0xfffffff0, 0xffffff84, 0xffffff84,
  0x007ffcf0, 0xffffff83, 0xffffff83, 0xffffff83,
  0x007ffc83, 0xffffff82, 0xffffff82, 0xffffcccf,
  0x007ffc82, 0xffffff81, 0xffffccce, 0xffffaaad,
  0x007ffc81, 0xffffcccd, 0xffffaaac, 0xffff8005,
  0x007fc9cd, 0xffffaaab, 0xffff8004, 0xffff8004,
  0x007fa7ab, 0xffff8003, 0xffff8003, 0xffff8003,
  0x007f7d03, 0xffff8002, 0xffff8002, 0x00008002,
  0x007f7d02, 0xffff8001, 0x00008001, 0x00008001,
  0x007f7d01, 0x00008000, 0x00008000, 0x00005558,
  0x00807d00, 0x00007fff, 0x00005557, 0x00003336,
  0x00807cff, 0x00005556, 0x00003335, 0x00000082,
  0x00805256, 0x00003334, 0x00000081, 0x00000081,
  0x00803034, 0x00000080, 0x00000080, 0x00000080,
  0x007ffd80, 0x0000007f, 0x0000007f, 0x0000007f,
  0x007ffd7f, 0x0000007e, 0x0000007e, 0x00000012,
  0x007ffd7e, 0x0000007d, 0x00000011, 0x00000005,
  0x007ffd7d, 0x00000010, 0x00000004, 0x00000004,
  0x007ffd10, 0x00000003, 0x00000003, 0x00000003,
  0x00000003, 0x00000003, 0x00000003, 0x00000020,
  0x00000002, 0x00000002, 0x00000002, 0x0000001f,
  0x00000001, 0x00000001, 0x00000001, 0x0000001e,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00008020,
  0xffff8002, 0xffff8002, 0x00008002, 0x0000801f,
  0xffff8001, 0x00008001, 0x00008001, 0x00005576,
  0x00008000, 0x00008000, 0x00005558, 0x00003354,
  0x00007fff, 0x00005557, 0x00003336, 0x000000a0,
  0x00005556, 0x00003335, 0x00000082, 0x0000009f,
  0x00003334, 0x00000081, 0x00000081, 0x0000009e,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000030,
  0x0000007e, 0x0000007e, 0x00000012, 0x00000023,
  0x0000007d, 0x00000011, 0x00000005, 0x00000022,
  0x00000010, 0x00000004, 0x00000004, 0x00000021,
  0x00000004, 0x00000004, 0x00000021, 0x0000007d,
  0x00000003, 0x00000003, 0x00000020, 0x0000007c,
  0x00000002, 0x00000002, 0x0000001f, 0x0000007b,
  0x00000001, 0x00000001, 0x0000001e, 0x0000006d,
  0x00000000, 0x00000000, 0x00000010, 0x00000000,
  0xffffffff, 0xfffffff2, 0xffffffa3, 0xffffffff,
  0xfffffff1, 0xffffff85, 0xffffffa2, 0xfffffffe,
  0xffffff84, 0xffffff84, 0xffffffa1, 0xffffcd4a,
  0xffffff83, 0xffffff83, 0xffffcced, 0xffffab28,
  0xffffff82, 0xffffcccf, 0xffffaacb, 0xffff8080,
  0xffffccce, 0xffffaaad, 0xffff8023, 0xffff807f,
  0xffffaaac, 0xffff8005, 0xffff8022, 0xffff807e,
  0xffff8004, 0xffff8004, 0xffff8021, 0x0000807d,
  0xffff8003, 0xffff8003, 0x00008020, 0x0000807c,
  0xffff8002, 0x00008002, 0x0000801f, 0x000055d3,
  0x00008001, 0x00008001, 0x00005576, 0x000033b1,
  0x00008000, 0x00005558, 0x00003354, 0x000000fd,
  0x00005557, 0x00003336, 0x000000a0, 0x000000fc,
  0x00003335, 0x00000082, 0x0000009f, 0x000000fb,
  0x00000081, 0x00000081, 0x0000009e, 0x000000fa,
  0x00000080, 0x00000080, 0x0000009d, 0x0000008d,
  0x0000007f, 0x0000007f, 0x00000030, 0x00000080,
  0x0000007e, 0x00000012, 0x00000023, 0x0000007f,
  0x00000011, 0x00000005, 0x00000022, 0x0000007e,
  0x00000005, 0x00000022, 0x0000007e, 0x0000007e,
  0x00000004, 0x00000021, 0x0000007d, 0x0000007d,
  0x00000003, 0x00000020, 0x0000007c, 0x0000007c,
  0x00000002, 0x0000001f, 0x0000007b, 0x0000006e,
  0x00000001, 0x0000001e, 0x0000006d, 0x00000001,
  0x00000000, 0x00000010, 0x00000000, 0x00000000,
  0xfffffff2, 0xffffffa3, 0xffffffff, 0xffffffff,
  0xffffff85, 0xffffffa2, 0xfffffffe, 0xffffcd4b,
  0xffffff84, 0xffffffa1, 0xffffcd4a, 0xffffab29,
  0xffffff83, 0xffffcced, 0xffffab28, 0xffff8081,
  0xffffcccf, 0xffffaacb, 0xffff8080, 0xffff8080,
  0xffffaaad, 0xffff8023, 0xffff807f, 0xffff807f,
  0xffff8005, 0xffff8022, 0xffff807e, 0x0000807e,
  0xffff8004, 0xffff8021, 0x0000807d, 0x0000807d,
  0xffff8003, 0x00008020, 0x0000807c, 0x000055d4,
  0x00008002, 0x0000801f, 0x000055d3, 0x000033b2,
  0x00008001, 0x00005576, 0x000033b1, 0x000000fe,
  0x00005558, 0x00003354, 0x000000fd, 0x000000fd,
  0x00003336, 0x000000a0, 0x000000fc, 0x000000fc,
  0x00000082, 0x0000009f, 0x000000fb, 0x000000fb,
  0x00000081, 0x0000009e, 0x000000fa, 0x0000008e,
  0x00000080, 0x0000009d, 0x0000008d, 0x00000081,
  0x0000007f, 0x00000030, 0x00000080, 0x00000080,
  0x00000012, 0x00000023, 0x0000007f, 0x0000007f,
  0x00000023, 0x0000007f, 0x0000007f, 0x0000007f,
  0x00000022, 0x0000007e, 0x0000007e, 0x0000007e,
  0x00000021, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000020, 0x0000007c, 0x0000007c, 0x0000006f,
  0x0000001f, 0x0000007b, 0x0000006e, 0x00000002,
  0x0000001e, 0x0000006d, 0x00000001, 0x00000001,
  0x00000010, 0x00000000, 0x00000000, 0x00000000,
  0xffffffa3, 0xffffffff, 0xffffffff, 0xffffcd4c,
  0xffffffa2, 0xfffffffe, 0xffffcd4b, 0xffffab2a,
  0xffffffa1, 0xffffcd4a, 0xffffab29, 0xffff8082,
  0xffffcced, 0xffffab28, 0xffff8081, 0xffff8081,
  0xffffaacb, 0xffff8080, 0xffff8080, 0xffff8080,
  0xffff8023, 0xffff807f, 0xffff807f, 0x0000807f,
  0xffff8022, 0xffff807e, 0x0000807e, 0x0000807e,
  0xffff8021, 0x0000807d, 0x0000807d, 0x000055d5,
  0x00008020, 0x0000807c, 0x000055d4, 0x000033b3,
  0x0000801f, 0x000055d3, 0x000033b2, 0x000000ff,
  0x00005576, 0x000033b1, 0x000000fe, 0x000000fe,
  0x00003354, 0x000000fd, 0x000000fd, 0x000000fd,
  0x000000a0, 0x000000fc, 0x000000fc, 0x000000fc,
  0x0000009f, 0x000000fb, 0x000000fb, 0x0000008f,
  0x0000009e, 0x000000fa, 0x0000008e, 0x00000082,
  0x0000009d, 0x0000008d, 0x00000081, 0x00000081,
  0x00000030, 0x00000080, 0x00000080, 0x00000080,
  0x00000080, 0x00000080, 0x00000080, 0x00007ffd,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00007ffc,
  0x0000007e, 0x0000007e, 0x0000007e, 0x00007ffb,
  0x0000007d, 0x0000007d, 0x0000007d, 0x00007fed,
  0x0000007c, 0x0000007c, 0x0000006f, 0x00007f80,
  0x0000007b, 0x0000006e, 0x00000002, 0x00007f7f,
  0x0000006d, 0x00000001, 0x00000001, 0x00007f7e,
  0x00000000, 0x00000000, 0x00000000, 0x00004cca,
  0xffffffff, 0xffffffff, 0xffffcd4c, 0x00002aa8,
  0xfffffffe, 0xffffcd4b, 0xffffab2a, 0x00000000,
  0xffffcd4a, 0xffffab29, 0xffff8082, 0xffffffff,
  0xffffab28, 0xffff8081, 0xffff8081, 0xfffffffe,
  0xffff8080, 0xffff8080, 0xffff8080, 0x0000fffd,
  0xffff807f, 0xffff807f, 0x0000807f, 0x0000fffc,
  0xffff807e, 0x0000807e, 0x0000807e, 0x0000d553,
  0x0000807d, 0x0000807d, 0x000055d5, 0x0000b331,
  0x0000807c, 0x000055d4, 0x000033b3, 0x0000807d,
  0x000055d3, 0x000033b2, 0x000000ff, 0x0000807c,
  0x000033b1, 0x000000fe, 0x000000fe, 0x0000807b,
  0x000000fd, 0x000000fd, 0x000000fd, 0x0000807a,
  0x000000fc, 0x000000fc, 0x000000fc, 0x0000800d,
  0x000000fb, 0x000000fb, 0x0000008f, 0x00008000,
  0x000000fa, 0x0000008e, 0x00000082, 0x00007fff,
  0x0000008d, 0x00000081, 0x00000081, 0x00007ffe,
  0x00000081, 0x00000081, 0x00007ffe, 0x00007ffe,
  0x00000080, 0x00000080, 0x00007ffd, 0x00007ffd,
  0x0000007f, 0x0000007f, 0x00007ffc, 0x00007ffc,
  0x0000007e, 0x0000007e, 0x00007ffb, 0x00007fee,
  0x0000007d, 0x0000007d, 0x00007fed, 0x00007f81,
  0x0000007c, 0x0000006f, 0x00007f80, 0x00007f80,
  0x0000006e, 0x00000002, 0x00007f7f, 0x00007f7f,
  0x00000001, 0x00000001, 0x00007f7e, 0x00004ccb,
  0x00000000, 0x00000000, 0x00004cca, 0x00002aa9,
  0xffffffff, 0xffffcd4c, 0x00002aa8, 0x00000001,
  0xffffcd4b, 0xffffab2a, 0x00000000, 0x00000000,
  0xffffab29, 0xffff8082, 0xffffffff, 0xffffffff,
  0xffff8081, 0xffff8081, 0xfffffffe, 0x0000fffe,
  0xffff8080, 0xffff8080, 0x0000fffd, 0x0000fffd,
  0xffff807f, 0x0000807f, 0x0000fffc, 0x0000d554,
  0x0000807e, 0x0000807e, 0x0000d553, 0x0000b332,
  0x0000807d, 0x000055d5, 0x0000b331, 0x0000807e,
  0x000055d4, 0x000033b3, 0x0000807d, 0x0000807d,
  0x000033b2, 0x000000ff, 0x0000807c, 0x0000807c,
  0x000000fe, 0x000000fe, 0x0000807b, 0x0000807b,
  0x000000fd, 0x000000fd, 0x0000807a, 0x0000800e,
  0x000000fc, 0x000000fc, 0x0000800d, 0x00008001,
  0x000000fb, 0x0000008f, 0x00008000, 0x00008000,
  0x0000008e, 0x00000082, 0x00007fff, 0x00007fff,
  0x00000082, 0x00007fff, 0x00007fff, 0x00007fff,
  0x00000081, 0x00007ffe, 0x00007ffe, 0x00007ffe,
  0x00000080, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x0000007f, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x0000007e, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x0000007d, 0x00007fed, 0x00007f81, 0x00007f81,
  0x0000006f, 0x00007f80, 0x00007f80, 0x00007f80,
  0x00000002, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x00000001, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x00000000, 0x00004cca, 0x00002aa9, 0x00000002,
  0xffffcd4c, 0x00002aa8, 0x00000001, 0x00000001,
  0xffffab2a, 0x00000000, 0x00000000, 0x00000000,
  0xffff8082, 0xffffffff, 0xffffffff, 0x0000ffff,
  0xffff8081, 0xfffffffe, 0x0000fffe, 0x0000fffe,
  0xffff8080, 0x0000fffd, 0x0000fffd, 0x0000d555,
  0x0000807f, 0x0000fffc, 0x0000d554, 0x0000b333,
  0x0000807e, 0x0000d553, 0x0000b332, 0x0000807f,
  0x000055d5, 0x0000b331, 0x0000807e, 0x0000807e,
  0x000033b3, 0x0000807d, 0x0000807d, 0x0000807d,
  0x000000ff, 0x0000807c, 0x0000807c, 0x0000807c,
  0x000000fe, 0x0000807b, 0x0000807b, 0x0000800f,
  0x000000fd, 0x0000807a, 0x0000800e, 0x00008002,
  0x000000fc, 0x0000800d, 0x00008001, 0x00008001,
  0x0000008f, 0x00008000, 0x00008000, 0x00008000,
  0x00008000, 0x00008000, 0x00008000, 0x33333333,
  0x00007fff, 0x00007fff, 0x00007fff, 0x33333332,
  0x00007ffe, 0x00007ffe, 0x00007ffe, 0x33333331,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x33333323,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0x333332b6,
  0x00007ffb, 0x00007fee, 0x00007f82, 0x333332b5,
  0x00007fed, 0x00007f81, 0x00007f81, 0x333332b4,
  0x00007f80, 0x00007f80, 0x00007f80, 0x33330000,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x3332ddde,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x3332b336,
  0x00004cca, 0x00002aa9, 0x00000002, 0x3332b335,
  0x00002aa8, 0x00000001, 0x00000001, 0x3332b334,
  0x00000000, 0x00000000, 0x00000000, 0x3333b333,
  0xffffffff, 0xffffffff, 0x0000ffff, 0x3333b332,
  0xfffffffe, 0x0000fffe, 0x0000fffe, 0x33338889,
  0x0000fffd, 0x0000fffd, 0x0000d555, 0x33336667,
  0x0000fffc, 0x0000d554, 0x0000b333, 0x333333b3,
  0x0000d553, 0x0000b332, 0x0000807f, 0x333333b2,
  0x0000b331, 0x0000807e, 0x0000807e, 0x333333b1,
  0x0000807d, 0x0000807d, 0x0000807d, 0x333333b0,
  0x0000807c, 0x0000807c, 0x0000807c, 0x33333343,
  0x0000807b, 0x0000807b, 0x0000800f, 0x33333336,
  0x0000807a, 0x0000800e, 0x00008002, 0x33333335,
  0x0000800d, 0x00008001, 0x00008001, 0x33333334,
  0x00008001, 0x00008001, 0x33333334, 0x55555555,
  0x00008000, 0x00008000, 0x33333333, 0x55555554,
  0x00007fff, 0x00007fff, 0x33333332, 0x55555553,
  0x00007ffe, 0x00007ffe, 0x33333331, 0x55555545,
  0x00007ffd, 0x00007ffd, 0x33333323, 0x555554d8,
  0x00007ffc, 0x00007fef, 0x333332b6, 0x555554d7,
  0x00007fee, 0x00007f82, 0x333332b5, 0x555554d6,
  0x00007f81, 0x00007f81, 0x333332b4, 0x55552222,
  0x00007f80, 0x00007f80, 0x33330000, 0x55550000,
  0x00007f7f, 0x00004ccc, 0x3332ddde, 0x5554d558,
  0x00004ccb, 0x00002aaa, 0x3332b336, 0x5554d557,
  0x00002aa9, 0x00000002, 0x3332b335, 0x5554d556,
  0x00000001, 0x00000001, 0x3332b334, 0x5555d555,
  0x00000000, 0x00000000, 0x3333b333, 0x5555d554,
  0xffffffff, 0x0000ffff, 0x3333b332, 0x5555aaab,
  0x0000fffe, 0x0000fffe, 0x33338889, 0x55558889,
  0x0000fffd, 0x0000d555, 0x33336667, 0x555555d5,
  0x0000d554, 0x0000b333, 0x333333b3, 0x555555d4,
  0x0000b332, 0x0000807f, 0x333333b2, 0x555555d3,
  0x0000807e, 0x0000807e, 0x333333b1, 0x555555d2,
  0x0000807d, 0x0000807d, 0x333333b0, 0x55555565,
  0x0000807c, 0x0000807c, 0x33333343, 0x55555558,
  0x0000807b, 0x0000800f, 0x33333336, 0x55555557,
  0x0000800e, 0x00008002, 0x33333335, 0x55555556,
  0x00008002, 0x33333335, 0x55555556, 0x7ffffffd,
  0x00008001, 0x33333334, 0x55555555, 0x7ffffffc,
  0x00008000, 0x33333333, 0x55555554, 0x7ffffffb,
  0x00007fff, 0x33333332, 0x55555553, 0x7fffffed,
  0x00007ffe, 0x33333331, 0x55555545, 0x7fffff80,
  0x00007ffd, 0x33333323, 0x555554d8, 0x7fffff7f,
  0x00007fef, 0x333332b6, 0x555554d7, 0x7fffff7e,
  0x00007f82, 0x333332b5, 0x555554d6, 0x7fffccca,
  0x00007f81, 0x333332b4, 0x55552222, 0x7fffaaa8,
  0x00007f80, 0x33330000, 0x55550000, 0x7fff8000,
  0x00004ccc, 0x3332ddde, 0x5554d558, 0x7fff7fff,
  0x00002aaa, 0x3332b336, 0x5554d557, 0x7fff7ffe,
  0x00000002, 0x3332b335, 0x5554d556, 0x80007ffd,
  0x00000001, 0x3332b334, 0x5555d555, 0x80007ffc,
  0x00000000, 0x3333b333, 0x5555d554, 0x80005553,
  0x0000ffff, 0x3333b332, 0x5555aaab, 0x80003331,
  0x0000fffe, 0x33338889, 0x55558889, 0x8000007d,
  0x0000d555, 0x33336667, 0x555555d5, 0x8000007c,
  0x0000b333, 0x333333b3, 0x555555d4, 0x8000007b,
  0x0000807f, 0x333333b2, 0x555555d3, 0x8000007a,
  0x0000807e, 0x333333b1, 0x555555d2, 0x8000000d,
  0x0000807d, 0x333333b0, 0x55555565, 0x80000000,
  0x0000807c, 0x33333343, 0x55555558, 0x7fffffff,
  0x0000800f, 0x33333336, 0x55555557, 0x7ffffffe,
  0x33333336, 0x55555557, 0x7ffffffe, 0x7ffffffe,
  0x33333335, 0x55555556, 0x7ffffffd, 0x7ffffffd,
  0x33333334, 0x55555555, 0x7ffffffc, 0x7ffffffc,
  0x33333333, 0x55555554, 0x7ffffffb, 0x7fffffee,
  0x33333332, 0x55555553, 0x7fffffed, 0x7fffff81,
  0x33333331, 0x55555545, 0x7fffff80, 0x7fffff80,
  0x33333323, 0x555554d8, 0x7fffff7f, 0x7fffff7f,
  0x333332b6, 0x555554d7, 0x7fffff7e, 0x7fffcccb,
  0x333332b5, 0x555554d6, 0x7fffccca, 0x7fffaaa9,
  0x333332b4, 0x55552222, 0x7fffaaa8, 0x7fff8001,
  0x33330000, 0x55550000, 0x7fff8000, 0x7fff8000,
  0x3332ddde, 0x5554d558, 0x7fff7fff, 0x7fff7fff,
  0x3332b336, 0x5554d557, 0x7fff7ffe, 0x80007ffe,
  0x3332b335, 0x5554d556, 0x80007ffd, 0x80007ffd,
  0x3332b334, 0x5555d555, 0x80007ffc, 0x80005554,
  0x3333b333, 0x5555d554, 0x80005553, 0x80003332,
  0x3333b332, 0x5555aaab, 0x80003331, 0x8000007e,
  0x33338889, 0x55558889, 0x8000007d, 0x8000007d,
  0x33336667, 0x555555d5, 0x8000007c, 0x8000007c,
  0x333333b3, 0x555555d4, 0x8000007b, 0x8000007b,
  0x333333b2, 0x555555d3, 0x8000007a, 0x8000000e,
  0x333333b1, 0x555555d2, 0x8000000d, 0x80000001,
  0x333333b0, 0x55555565, 0x80000000, 0x80000000,
  0x33333343, 0x55555558, 0x7fffffff, 0x7fffffff,
  0x55555558, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x55555557, 0x7ffffffe, 0x7ffffffe, 0x7ffffffe,
  0x55555556, 0x7ffffffd, 0x7ffffffd, 0x7ffffffd,
  0x55555555, 0x7ffffffc, 0x7ffffffc, 0x7fffffef,
  0x55555554, 0x7ffffffb, 0x7fffffee, 0x7fffff82,
  0x55555553, 0x7fffffed, 0x7fffff81, 0x7fffff81,
  0x55555545, 0x7fffff80, 0x7fffff80, 0x7fffff80,
  0x555554d8, 0x7fffff7f, 0x7fffff7f, 0x7fffcccc,
  0x555554d7, 0x7fffff7e, 0x7fffcccb, 0x7fffaaaa,
  0x555554d6, 0x7fffccca, 0x7fffaaa9, 0x7fff8002,
  0x55552222, 0x7fffaaa8, 0x7fff8001, 0x7fff8001,
  0x55550000, 0x7fff8000, 0x7fff8000, 0x7fff8000,
  0x5554d558, 0x7fff7fff, 0x7fff7fff, 0x80007fff,
  0x5554d557, 0x7fff7ffe, 0x80007ffe, 0x80007ffe,
  0x5554d556, 0x80007ffd, 0x80007ffd, 0x80005555,
  0x5555d555, 0x80007ffc, 0x80005554, 0x80003333,
  0x5555d554, 0x80005553, 0x80003332, 0x8000007f,
  0x5555aaab, 0x80003331, 0x8000007e, 0x8000007e,
  0x55558889, 0x8000007d, 0x8000007d, 0x8000007d,
  0x555555d5, 0x8000007c, 0x8000007c, 0x8000007c,
  0x555555d4, 0x8000007b, 0x8000007b, 0x8000000f,
  0x555555d3, 0x8000007a, 0x8000000e, 0x80000002,
  0x555555d2, 0x8000000d, 0x80000001, 0x80000001,
  0x55555565, 0x80000000, 0x80000000, 0x80000000,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7ffffffe, 0x7ffffffe, 0x7ffffffe, 0x7ffffffe,
  0x7ffffffd, 0x7ffffffd, 0x7ffffffd, 0x7ffffff0,
  0x7ffffffc, 0x7ffffffc, 0x7fffffef, 0x7fffff83,
  0x7ffffffb, 0x7fffffee, 0x7fffff82, 0x7fffff82,
  0x7fffffed, 0x7fffff81, 0x7fffff81, 0x7fffff81,
  0x7fffff80, 0x7fffff80, 0x7fffff80, 0x7fffcccd,
  0x7fffff7f, 0x7fffff7f, 0x7fffcccc, 0x7fffaaab,
  0x7fffff7e, 0x7fffcccb, 0x7fffaaaa, 0x7fff8003,
  0x7fffccca, 0x7fffaaa9, 0x7fff8002, 0x7fff8002,
  0x7fffaaa8, 0x7fff8001, 0x7fff8001, 0x7fff8001,
  0x7fff8000, 0x7fff8000, 0x7fff8000, 0x80008000,
  0x7fff7fff, 0x7fff7fff, 0x80007fff, 0x80007fff,
  0x7fff7ffe, 0x80007ffe, 0x80007ffe, 0x80005556,
  0x80007ffd, 0x80007ffd, 0x80005555, 0x80003334,
  0x80007ffc, 0x80005554, 0x80003333, 0x80000080,
  0x80005553, 0x80003332, 0x8000007f, 0x8000007f,
  0x80003331, 0x8000007e, 0x8000007e, 0x8000007e,
  0x8000007d, 0x8000007d, 0x8000007d, 0x8000007d,
  0x8000007c, 0x8000007c, 0x8000007c, 0x80000010,
  0x8000007b, 0x8000007b, 0x8000000f, 0x80000003,
  0x8000007a, 0x8000000e, 0x80000002, 0x80000002,
  0x8000000d, 0x80000001, 0x80000001, 0x80000001,
  0x80000001, 0x80000001, 0x80000001, 0x80000001,
  0x80000000, 0x80000000, 0x80000000, 0x80000000,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7ffffffe, 0x7ffffffe, 0x7ffffffe, 0x7ffffff1,
  0x7ffffffd, 0x7ffffffd, 0x7ffffff0, 0x7fffff84,
  0x7ffffffc, 0x7fffffef, 0x7fffff83, 0x7fffff83,
  0x7fffffee, 0x7fffff82, 0x7fffff82, 0x7fffff82,
  0x7fffff81, 0x7fffff81, 0x7fffff81, 0x7fffccce,
  0x7fffff80, 0x7fffff80, 0x7fffcccd, 0x7fffaaac,
  0x7fffff7f, 0x7fffcccc, 0x7fffaaab, 0x7fff8004,
  0x7fffcccb, 0x7fffaaaa, 0x7fff8003, 0x7fff8003,
  0x7fffaaa9, 0x7fff8002, 0x7fff8002, 0x7fff8002,
  0x7fff8001, 0x7fff8001, 0x7fff8001, 0x80008001,
  0x7fff8000, 0x7fff8000, 0x80008000, 0x80008000,
  0x7fff7fff, 0x80007fff, 0x80007fff, 0x80005557,
  0x80007ffe, 0x80007ffe, 0x80005556, 0x80003335,
  0x80007ffd, 0x80005555, 0x80003334, 0x80000081,
  0x80005554, 0x80003333, 0x80000080, 0x80000080,
  0x80003332, 0x8000007f, 0x8000007f, 0x8000007f,
  0x8000007e, 0x8000007e, 0x8000007e, 0x8000007e,
  0x8000007d, 0x8000007d, 0x8000007d, 0x80000011,
  0x8000007c, 0x8000007c, 0x80000010, 0x80000004,
  0x8000007b, 0x8000000f, 0x80000003, 0x80000003,
  0x8000000e, 0x80000002, 0x80000002, 0x80000002,
  0x80000002, 0x80000002, 0x80000002, 0xaaaaaaaa,
  0x80000001, 0x80000001, 0x80000001, 0xaaaaaaa9,
  0x80000000, 0x80000000, 0x80000000, 0xaaaaaaa8,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0xaaaaaa9a,
  0x7ffffffe, 0x7ffffffe, 0x7ffffff1, 0xaaaaaa2d,
  0x7ffffffd, 0x7ffffff0, 0x7fffff84, 0xaaaaaa2c,
  0x7fffffef, 0x7fffff83, 0x7fffff83, 0xaaaaaa2b,
  0x7fffff82, 0x7fffff82, 0x7fffff82, 0xaaaa7777,
  0x7fffff81, 0x7fffff81, 0x7fffccce, 0xaaaa5555,
  0x7fffff80, 0x7fffcccd, 0x7fffaaac, 0xaaaa2aad,
  0x7fffcccc, 0x7fffaaab, 0x7fff8004, 0xaaaa2aac,
  0x7fffaaaa, 0x7fff8003, 0x7fff8003, 0xaaaa2aab,
  0x7fff8002, 0x7fff8002, 0x7fff8002, 0xaaab2aaa,
  0x7fff8001, 0x7fff8001, 0x80008001, 0xaaab2aa9,
  0x7fff8000, 0x80008000, 0x80008000, 0xaaab0000,
  0x80007fff, 0x80007fff, 0x80005557, 0xaaaaddde,
  0x80007ffe, 0x80005556, 0x80003335, 0xaaaaab2a,
  0x80005555, 0x80003334, 0x80000081, 0xaaaaab29,
  0x80003333, 0x80000080, 0x80000080, 0xaaaaab28,
  0x8000007f, 0x8000007f, 0x8000007f, 0xaaaaab27,
  0x8000007e, 0x8000007e, 0x8000007e, 0xaaaaaaba,
  0x8000007d, 0x8000007d, 0x80000011, 0xaaaaaaad,
  0x8000007c, 0x80000010, 0x80000004, 0xaaaaaaac,
  0x8000000f, 0x80000003, 0x80000003, 0xaaaaaaab,
  0x80000003, 0x80000003, 0xaaaaaaab, 0xcccccccc,
  0x80000002, 0x80000002, 0xaaaaaaaa, 0xcccccccb,
  0x80000001, 0x80000001, 0xaaaaaaa9, 0xccccccca,
  0x80000000, 0x80000000, 0xaaaaaaa8, 0xccccccbc,
  0x7fffffff, 0x7fffffff, 0xaaaaaa9a, 0xcccccc4f,
  0x7ffffffe, 0x7ffffff1, 0xaaaaaa2d, 0xcccccc4e,
  0x7ffffff0, 0x7fffff84, 0xaaaaaa2c, 0xcccccc4d,
  0x7fffff83, 0x7fffff83, 0xaaaaaa2b, 0xcccc9999,
  0x7fffff82, 0x7fffff82, 0xaaaa7777, 0xcccc7777,
  0x7fffff81, 0x7fffccce, 0xaaaa5555, 0xcccc4ccf,
  0x7fffcccd, 0x7fffaaac, 0xaaaa2aad, 0xcccc4cce,
  0x7fffaaab, 0x7fff8004, 0xaaaa2aac, 0xcccc4ccd,
  0x7fff8003, 0x7fff8003, 0xaaaa2aab, 0xcccd4ccc,
  0x7fff8002, 0x7fff8002, 0xaaab2aaa, 0xcccd4ccb,
  0x7fff8001, 0x80008001, 0xaaab2aa9, 0xcccd2222,
  0x80008000, 0x80008000, 0xaaab0000, 0xcccd0000,
  0x80007fff, 0x80005557, 0xaaaaddde, 0xcccccd4c,
  0x80005556, 0x80003335, 0xaaaaab2a, 0xcccccd4b,
  0x80003334, 0x80000081, 0xaaaaab29, 0xcccccd4a,
  0x80000080, 0x80000080, 0xaaaaab28, 0xcccccd49,
  0x8000007f, 0x8000007f, 0xaaaaab27, 0xccccccdc,
  0x8000007e, 0x8000007e, 0xaaaaaaba, 0xcccccccf,
  0x8000007d, 0x80000011, 0xaaaaaaad, 0xccccccce,
  0x80000010, 0x80000004, 0xaaaaaaac, 0xcccccccd,
  0x80000004, 0xaaaaaaac, 0xcccccccd, 0xffff8000,
  0x80000003, 0xaaaaaaab, 0xcccccccc, 0xffff7fff,
  0x80000002, 0xaaaaaaaa, 0xcccccccb, 0xffff7ffe,
  0x80000001, 0xaaaaaaa9, 0xccccccca, 0xffff7ff0,
  0x80000000, 0xaaaaaaa8, 0xccccccbc, 0xffff7f83,
  0x7fffffff, 0xaaaaaa9a, 0xcccccc4f, 0xffff7f82,
  0x7ffffff1, 0xaaaaaa2d, 0xcccccc4e, 0xffff7f81,
  0x7fffff84, 0xaaaaaa2c, 0xcccccc4d, 0xffff4ccd,
  0x7fffff83, 0xaaaaaa2b, 0xcccc9999, 0xffff2aab,
  0x7fffff82, 0xaaaa7777, 0xcccc7777, 0xffff0003,
  0x7fffccce, 0xaaaa5555, 0xcccc4ccf, 0xffff0002,
  0x7fffaaac, 0xaaaa2aad, 0xcccc4cce, 0xffff0001,
  0x7fff8004, 0xaaaa2aac, 0xcccc4ccd, 0x00000000,
  0x7fff8003, 0xaaaa2aab, 0xcccd4ccc, 0xffffffff,
  0x7fff8002, 0xaaab2aaa, 0xcccd4ccb, 0xffffd556,
  0x80008001, 0xaaab2aa9, 0xcccd2222, 0xffffb334,
  0x80008000, 0xaaab0000, 0xcccd0000, 0xffff8080,
  0x80005557, 0xaaaaddde, 0xcccccd4c, 0xffff807f,
  0x80003335, 0xaaaaab2a, 0xcccccd4b, 0xffff807e,
  0x80000081, 0xaaaaab29, 0xcccccd4a, 0xffff807d,
  0x80000080, 0xaaaaab28, 0xcccccd49, 0xffff8010,
  0x8000007f, 0xaaaaab27, 0xccccccdc, 0xffff8003,
  0x8000007e, 0xaaaaaaba, 0xcccccccf, 0xffff8002,
  0x80000011, 0xaaaaaaad, 0xccccccce, 0xffff8001,
  0xaaaaaaad, 0xccccccce, 0xffff8001, 0xffff8001,
  0xaaaaaaac, 0xcccccccd, 0xffff8000, 0xffff8000,
  0xaaaaaaab, 0xcccccccc, 0xffff7fff, 0xffff7fff,
  0xaaaaaaaa, 0xcccccccb, 0xffff7ffe, 0xffff7ff1,
  0xaaaaaaa9, 0xccccccca, 0xffff7ff0, 0xffff7f84,
  0xaaaaaaa8, 0xccccccbc, 0xffff7f83, 0xffff7f83,
  0xaaaaaa9a, 0xcccccc4f, 0xffff7f82, 0xffff7f82,
  0xaaaaaa2d, 0xcccccc4e, 0xffff7f81, 0xffff4cce,
  0xaaaaaa2c, 0xcccccc4d, 0xffff4ccd, 0xffff2aac,
  0xaaaaaa2b, 0xcccc9999, 0xffff2aab, 0xffff0004,
  0xaaaa7777, 0xcccc7777, 0xffff0003, 0xffff0003,
  0xaaaa5555, 0xcccc4ccf, 0xffff0002, 0xffff0002,
  0xaaaa2aad, 0xcccc4cce, 0xffff0001, 0x00000001,
  0xaaaa2aac, 0xcccc4ccd, 0x00000000, 0x00000000,
  0xaaaa2aab, 0xcccd4ccc, 0xffffffff, 0xffffd557,
  0xaaab2aaa, 0xcccd4ccb, 0xffffd556, 0xffffb335,
  0xaaab2aa9, 0xcccd2222, 0xffffb334, 0xffff8081,
  0xaaab0000, 0xcccd0000, 0xffff8080, 0xffff8080,
  0xaaaaddde, 0xcccccd4c, 0xffff807f, 0xffff807f,
  0xaaaaab2a, 0xcccccd4b, 0xffff807e, 0xffff807e,
  0xaaaaab29, 0xcccccd4a, 0xffff807d, 0xffff8011,
  0xaaaaab28, 0xcccccd49, 0xffff8010, 0xffff8004,
  0xaaaaab27, 0xccccccdc, 0xffff8003, 0xffff8003,
  0xaaaaaaba, 0xcccccccf, 0xffff8002, 0xffff8002,
  0xcccccccf, 0xffff8002, 0xffff8002, 0xffff8002,
  0xccccccce, 0xffff8001, 0xffff8001, 0xffff8001,
  0xcccccccd, 0xffff8000, 0xffff8000, 0xffff8000,
  0xcccccccc, 0xffff7fff, 0xffff7fff, 0xffff7ff2,
  0xcccccccb, 0xffff7ffe, 0xffff7ff1, 0xffff7f85,
  0xccccccca, 0xffff7ff0, 0xffff7f84, 0xffff7f84,
  0xccccccbc, 0xffff7f83, 0xffff7f83, 0xffff7f83,
  0xcccccc4f, 0xffff7f82, 0xffff7f82, 0xffff4ccf,
  0xcccccc4e, 0xffff7f81, 0xffff4cce, 0xffff2aad,
  0xcccccc4d, 0xffff4ccd, 0xffff2aac, 0xffff0005,
  0xcccc9999, 0xffff2aab, 0xffff0004, 0xffff0004,
  0xcccc7777, 0xffff0003, 0xffff0003, 0xffff0003,
  0xcccc4ccf, 0xffff0002, 0xffff0002, 0x00000002,
  0xcccc4cce, 0xffff0001, 0x00000001, 0x00000001,
  0xcccc4ccd, 0x00000000, 0x00000000, 0xffffd558,
  0xcccd4ccc, 0xffffffff, 0xffffd557, 0xffffb336,
  0xcccd4ccb, 0xffffd556, 0xffffb335, 0xffff8082,
  0xcccd2222, 0xffffb334, 0xffff8081, 0xffff8081,
  0xcccd0000, 0xffff8080, 0xffff8080, 0xffff8080,
  0xcccccd4c, 0xffff807f, 0xffff807f, 0xffff807f,
  0xcccccd4b, 0xffff807e, 0xffff807e, 0xffff8012,
  0xcccccd4a, 0xffff807d, 0xffff8011, 0xffff8005,
  0xcccccd49, 0xffff8010, 0xffff8004, 0xffff8004,
  0xccccccdc, 0xffff8003, 0xffff8003, 0xffff8003,
  0xffff8003, 0xffff8003, 0xffff8003, 0xffff8003,
  0xffff8002, 0xffff8002, 0xffff8002, 0xffff8002,
  0xffff8001, 0xffff8001, 0xffff8001, 0xffff8001,
  0xffff8000, 0xffff8000, 0xffff8000, 0xffff7ff3,
  0xffff7fff, 0xffff7fff, 0xffff7ff2, 0xffff7f86,
  0xffff7ffe, 0xffff7ff1, 0xffff7f85, 0xffff7f85,
  0xffff7ff0, 0xffff7f84, 0xffff7f84, 0xffff7f84,
  0xffff7f83, 0xffff7f83, 0xffff7f83, 0xffff4cd0,
  0xffff7f82, 0xffff7f82, 0xffff4ccf, 0xffff2aae,
  0xffff7f81, 0xffff4cce, 0xffff2aad, 0xffff0006,
  0xffff4ccd, 0xffff2aac, 0xffff0005, 0xffff0005,
  0xffff2aab, 0xffff0004, 0xffff0004, 0xffff0004,
  0xffff0003, 0xffff0003, 0xffff0003, 0x00000003,
  0xffff0002, 0xffff0002, 0x00000002, 0x00000002,
  0xffff0001, 0x00000001, 0x00000001, 0xffffd559,
  0x00000000, 0x00000000, 0xffffd558, 0xffffb337,
  0xffffffff, 0xffffd557, 0xffffb336, 0xffff8083,
  0xffffd556, 0xffffb335, 0xffff8082, 0xffff8082,
  0xffffb334, 0xffff8081, 0xffff8081, 0xffff8081,
  0xffff8080, 0xffff8080, 0xffff8080, 0xffff8080,
  0xffff807f, 0xffff807f, 0xffff807f, 0xffff8013,
  0xffff807e, 0xffff807e, 0xffff8012, 0xffff8006,
  0xffff807d, 0xffff8011, 0xffff8005, 0xffff8005,
  0xffff8010, 0xffff8004, 0xffff8004, 0xffff8004,
  0xffff8004, 0xffff8004, 0xffff8004, 0xffffff80,
  0xffff8003, 0xffff8003, 0xffff8003, 0xffffff7f,
  0xffff8002, 0xffff8002, 0xffff8002, 0xffffff7e,
  0xffff8001, 0xffff8001, 0xffff8001, 0xffffff70,
  0xffff8000, 0xffff8000, 0xffff7ff3, 0xffffff03,
  0xffff7fff, 0xffff7ff2, 0xffff7f86, 0xffffff02,
  0xffff7ff1, 0xffff7f85, 0xffff7f85, 0xffffff01,
  0xffff7f84, 0xffff7f84, 0xffff7f84, 0xffffcc4d,
  0xffff7f83, 0xffff7f83, 0xffff4cd0, 0xffffaa2b,
  0xffff7f82, 0xffff4ccf, 0xffff2aae, 0xffff7f83,
  0xffff4cce, 0xffff2aad, 0xffff0006, 0xffff7f82,
  0xffff2aac, 0xffff0005, 0xffff0005, 0xffff7f81,
  0xffff0004, 0xffff0004, 0xffff0004, 0x00007f80,
  0xffff0003, 0xffff0003, 0x00000003, 0x00007f7f,
  0xffff0002, 0x00000002, 0x00000002, 0x000054d6,
  0x00000001, 0x00000001, 0xffffd559, 0x000032b4,
  0x00000000, 0xffffd558, 0xffffb337, 0x00000000,
  0xffffd557, 0xffffb336, 0xffff8083, 0xffffffff,
  0xffffb335, 0xffff8082, 0xffff8082, 0xfffffffe,
  0xffff8081, 0xffff8081, 0xffff8081, 0xfffffffd,
  0xffff8080, 0xffff8080, 0xffff8080, 0xffffff90,
  0xffff807f, 0xffff807f, 0xffff8013, 0xffffff83,
  0xffff807e, 0xffff8012, 0xffff8006, 0xffffff82,
  0xffff8011, 0xffff8005, 0xffff8005, 0xffffff81,
  0xffff8005, 0xffff8005, 0xffffff81, 0xffffff81,
  0xffff8004, 0xffff8004, 0xffffff80, 0xffffff80,
  0xffff8003, 0xffff8003, 0xffffff7f, 0xffffff7f,
  0xffff8002, 0xffff8002, 0xffffff7e, 0xffffff71,
  0xffff8001, 0xffff8001, 0xffffff70, 0xffffff04,
  0xffff8000, 0xffff7ff3, 0xffffff03, 0xffffff03,
  0xffff7ff2, 0xffff7f86, 0xffffff02, 0xffffff02,
  0xffff7f85, 0xffff7f85, 0xffffff01, 0xffffcc4e,
  0xffff7f84, 0xffff7f84, 0xffffcc4d, 0xffffaa2c,
  0xffff7f83, 0xffff4cd0, 0xffffaa2b, 0xffff7f84,
  0xffff4ccf, 0xffff2aae, 0xffff7f83, 0xffff7f83,
  0xffff2aad, 0xffff0006, 0xffff7f82, 0xffff7f82,
  0xffff0005, 0xffff0005, 0xffff7f81, 0x00007f81,
  0xffff0004, 0xffff0004, 0x00007f80, 0x00007f80,
  0xffff0003, 0x00000003, 0x00007f7f, 0x000054d7,
  0x00000002, 0x00000002, 0x000054d6, 0x000032b5,
  0x00000001, 0xffffd559, 0x000032b4, 0x00000001,
  0xffffd558, 0xffffb337, 0x00000000, 0x00000000,
  0xffffb336, 0xffff8083, 0xffffffff, 0xffffffff,
  0xffff8082, 0xffff8082, 0xfffffffe, 0xfffffffe,
  0xffff8081, 0xffff8081, 0xfffffffd, 0xffffff91,
  0xffff8080, 0xffff8080, 0xffffff90, 0xffffff84,
  0xffff807f, 0xffff8013, 0xffffff83, 0xffffff83,
  0xffff8012, 0xffff8006, 0xffffff82, 0xffffff82,
  0xffff8006, 0xffffff82, 0xffffff82, 0xffffff82,
  0xffff8005, 0xffffff81, 0xffffff81, 0xffffff81,
  0xffff8004, 0xffffff80, 0xffffff80, 0xffffff80,
  0xffff8003, 0xffffff7f, 0xffffff7f, 0xffffff72,
  0xffff8002, 0xffffff7e, 0xffffff71, 0xffffff05,
  0xffff8001, 0xffffff70, 0xffffff04, 0xffffff04,
  0xffff7ff3, 0xffffff03, 0xffffff03, 0xffffff03,
  0xffff7f86, 0xffffff02, 0xffffff02, 0xffffcc4f,
  0xffff7f85, 0xffffff01, 0xffffcc4e, 0xffffaa2d,
  0xffff7f84, 0xffffcc4d, 0xffffaa2c, 0xffff7f85,
  0xffff4cd0, 0xffffaa2b, 0xffff7f84, 0xffff7f84,
  0xffff2aae, 0xffff7f83, 0xffff7f83, 0xffff7f83,
  0xffff0006, 0xffff7f82, 0xffff7f82, 0x00007f82,
  0xffff0005, 0xffff7f81, 0x00007f81, 0x00007f81,
  0xffff0004, 0x00007f80, 0x00007f80, 0x000054d8,
  0x00000003, 0x00007f7f, 0x000054d7, 0x000032b6,
  0x00000002, 0x000054d6, 0x000032b5, 0x00000002,
  0xffffd559, 0x000032b4, 0x00000001, 0x00000001,
  0xffffb337, 0x00000000, 0x00000000, 0x00000000,
  0xffff8083, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffff8082, 0xfffffffe, 0xfffffffe, 0xffffff92,
  0xffff8081, 0xfffffffd, 0xffffff91, 0xffffff85,
  0xffff8080, 0xffffff90, 0xffffff84, 0xffffff84,
  0xffff8013, 0xffffff83, 0xffffff83, 0xffffff83,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffff83,
  0xffffff82, 0xffffff82, 0xffffff82, 0xffffff82,
  0xffffff81, 0xffffff81, 0xffffff81, 0xffffff81,
  0xffffff80, 0xffffff80, 0xffffff80, 0xffffff73,
  0xffffff7f, 0xffffff7f, 0xffffff72, 0xffffff06,
  0xffffff7e, 0xffffff71, 0xffffff05, 0xffffff05,
  0xffffff70, 0xffffff04, 0xffffff04, 0xffffff04,
  0xffffff03, 0xffffff03, 0xffffff03, 0xffffcc50,
  0xffffff02, 0xffffff02, 0xffffcc4f, 0xffffaa2e,
  0xffffff01, 0xffffcc4e, 0xffffaa2d, 0xffff7f86,
  0xffffcc4d, 0xffffaa2c, 0xffff7f85, 0xffff7f85,
  0xffffaa2b, 0xffff7f84, 0xffff7f84, 0xffff7f84,
  0xffff7f83, 0xffff7f83, 0xffff7f83, 0x00007f83,
  0xffff7f82, 0xffff7f82, 0x00007f82, 0x00007f82,
  0xffff7f81, 0x00007f81, 0x00007f81, 0x000054d9,
  0x00007f80, 0x00007f80, 0x000054d8, 0x000032b7,
  0x00007f7f, 0x000054d7, 0x000032b6, 0x00000003,
  0x000054d6, 0x000032b5, 0x00000002, 0x00000002,
  0x000032b4, 0x00000001, 0x00000001, 0x00000001,
  0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffff93,
  0xfffffffe, 0xfffffffe, 0xffffff92, 0xffffff86,
  0xfffffffd, 0xffffff91, 0xffffff85, 0xffffff85,
  0xffffff90, 0xffffff84, 0xffffff84, 0xffffff84,
  0xffffff84, 0xffffff84, 0xffffff84, 0xffffffe0,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffffdf,
  0xffffff82, 0xffffff82, 0xffffff82, 0xffffffde,
  0xffffff81, 0xffffff81, 0xffffff81, 0xffffffd0,
  0xffffff80, 0xffffff80, 0xffffff73, 0xffffff63,
  0xffffff7f, 0xffffff72, 0xffffff06, 0xffffff62,
  0xffffff71, 0xffffff05, 0xffffff05, 0xffffff61,
  0xffffff04, 0xffffff04, 0xffffff04, 0xffffccad,
  0xffffff03, 0xffffff03, 0xffffcc50, 0xffffaa8b,
  0xffffff02, 0xffffcc4f, 0xffffaa2e, 0xffff7fe3,
  0xffffcc4e, 0xffffaa2d, 0xffff7f86, 0xffff7fe2,
  0xffffaa2c, 0xffff7f85, 0xffff7f85, 0xffff7fe1,
  0xffff7f84, 0xffff7f84, 0xffff7f84, 0x00007fe0,
  0xffff7f83, 0xffff7f83, 0x00007f83, 0x00007fdf,
  0xffff7f82, 0x00007f82, 0x00007f82, 0x00005536,
  0x00007f81, 0x00007f81, 0x000054d9, 0x00003314,
  0x00007f80, 0x000054d8, 0x000032b7, 0x00000060,
  0x000054d7, 0x000032b6, 0x00000003, 0x0000005f,
  0x000032b5, 0x00000002, 0x00000002, 0x0000005e,
  0x00000001, 0x00000001, 0x00000001, 0x0000005d,
  0x00000000, 0x00000000, 0x00000000, 0xfffffff0,
  0xffffffff, 0xffffffff, 0xffffff93, 0xffffffe3,
  0xfffffffe, 0xffffff92, 0xffffff86, 0xffffffe2,
  0xffffff91, 0xffffff85, 0xffffff85, 0xffffffe1,
  0xffffff85, 0xffffff85, 0xffffffe1, 0xfffffffd,
  0xffffff84, 0xffffff84, 0xffffffe0, 0xfffffffc,
  0xffffff83, 0xffffff83, 0xffffffdf, 0xfffffffb,
  0xffffff82, 0xffffff82, 0xffffffde, 0xffffffed,
  0xffffff81, 0xffffff81, 0xffffffd0, 0xffffff80,
  0xffffff80, 0xffffff73, 0xffffff63, 0xffffff7f,
  0xffffff72, 0xffffff06, 0xffffff62, 0xffffff7e,
  0xffffff05, 0xffffff05, 0xffffff61, 0xffffccca,
  0xffffff04, 0xffffff04, 0xffffccad, 0xffffaaa8,
  0xffffff03, 0xffffcc50, 0xffffaa8b, 0xffff8000,
  0xffffcc4f, 0xffffaa2e, 0xffff7fe3, 0xffff7fff,
  0xffffaa2d, 0xffff7f86, 0xffff7fe2, 0xffff7ffe,
  0xffff7f85, 0xffff7f85, 0xffff7fe1, 0x00007ffd,
  0xffff7f84, 0xffff7f84, 0x00007fe0, 0x00007ffc,
  0xffff7f83, 0x00007f83, 0x00007fdf, 0x00005553,
  0x00007f82, 0x00007f82, 0x00005536, 0x00003331,
  0x00007f81, 0x000054d9, 0x00003314, 0x0000007d,
  0x000054d8, 0x000032b7, 0x00000060, 0x0000007c,
  0x000032b6, 0x00000003, 0x0000005f, 0x0000007b,
  0x00000002, 0x00000002, 0x0000005e, 0x0000007a,
  0x00000001, 0x00000001, 0x0000005d, 0x0000000d,
  0x00000000, 0x00000000, 0xfffffff0, 0x00000000,
  0xffffffff, 0xffffff93, 0xffffffe3, 0xffffffff,
  0xffffff92, 0xffffff86, 0xffffffe2, 0xfffffffe,
  0xffffff86, 0xffffffe2, 0xfffffffe, 0xfffffffe,
  0xffffff85, 0xffffffe1, 0xfffffffd, 0xfffffffd,
  0xffffff84, 0xffffffe0, 0xfffffffc, 0xfffffffc,
  0xffffff83, 0xffffffdf, 0xfffffffb, 0xffffffee,
  0xffffff82, 0xffffffde, 0xffffffed, 0xffffff81,
  0xffffff81, 0xffffffd0, 0xffffff80, 0xffffff80,
  0xffffff73, 0xffffff63, 0xffffff7f, 0xffffff7f,
  0xffffff06, 0xffffff62, 0xffffff7e, 0xffffcccb,
  0xffffff05, 0xffffff61, 0xffffccca, 0xffffaaa9,
  0xffffff04, 0xffffccad, 0xffffaaa8, 0xffff8001,
  0xffffcc50, 0xffffaa8b, 0xffff8000, 0xffff8000,
  0xffffaa2e, 0xffff7fe3, 0xffff7fff, 0xffff7fff,
  0xffff7f86, 0xffff7fe2, 0xffff7ffe, 0x00007ffe,
  0xffff7f85, 0xffff7fe1, 0x00007ffd, 0x00007ffd,
  0xffff7f84, 0x00007fe0, 0x00007ffc, 0x00005554,
  0x00007f83, 0x00007fdf, 0x00005553, 0x00003332,
  0x00007f82, 0x00005536, 0x00003331, 0x0000007e,
  0x000054d9, 0x00003314, 0x0000007d, 0x0000007d,
  0x000032b7, 0x00000060, 0x0000007c, 0x0000007c,
  0x00000003, 0x0000005f, 0x0000007b, 0x0000007b,
  0x00000002, 0x0000005e, 0x0000007a, 0x0000000e,
  0x00000001, 0x0000005d, 0x0000000d, 0x00000001,
  0x00000000, 0xfffffff0, 0x00000000, 0x00000000,
  0xffffff93, 0xffffffe3, 0xffffffff, 0xffffffff,
  0xffffffe3, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffe2, 0xfffffffe, 0xfffffffe, 0xfffffffe,
  0xffffffe1, 0xfffffffd, 0xfffffffd, 0xfffffffd,
  0xffffffe0, 0xfffffffc, 0xfffffffc, 0xffffffef,
  0xffffffdf, 0xfffffffb, 0xffffffee, 0xffffff82,
  0xffffffde, 0xffffffed, 0xffffff81, 0xffffff81,
  0xffffffd0, 0xffffff80, 0xffffff80, 0xffffff80,
  0xffffff63, 0xffffff7f, 0xffffff7f, 0xffffcccc,
  0xffffff62, 0xffffff7e, 0xffffcccb, 0xffffaaaa,
  0xffffff61, 0xffffccca, 0xffffaaa9, 0xffff8002,
  0xffffccad, 0xffffaaa8, 0xffff8001, 0xffff8001,
  0xffffaa8b, 0xffff8000, 0xffff8000, 0xffff8000,
  0xffff7fe3, 0xffff7fff, 0xffff7fff, 0x00007fff,
  0xffff7fe2, 0xffff7ffe, 0x00007ffe, 0x00007ffe,
  0xffff7fe1, 0x00007ffd, 0x00007ffd, 0x00005555,
  0x00007fe0, 0x00007ffc, 0x00005554, 0x00003333,
  0x00007fdf, 0x00005553, 0x00003332, 0x0000007f,
  0x00005536, 0x00003331, 0x0000007e, 0x0000007e,
  0x00003314, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000060, 0x0000007c, 0x0000007c, 0x0000007c,
  0x0000005f, 0x0000007b, 0x0000007b, 0x0000000f,
  0x0000005e, 0x0000007a, 0x0000000e, 0x00000002,
  0x0000005d, 0x0000000d, 0x00000001, 0x00000001,
  0xfffffff0, 0x00000000, 0x00000000, 0x00000000,
};
const unsigned kExpectedCount_NEON_ssubw2_4S = 744;

#endif  // VIXL_SIM_SSUBW2_4S_TRACE_AARCH64_H_
