# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from GlobalDefines import *
from DefMoviePoint import *
from DocHelpDlg import *

#---------------------------------------------------------------------------------------------------------------------------------------------------------------
# DefZoomPoint dialog box
# A faire :
#    Finir de gérer correctement le cas du passage en idle et le rechargement du fichier
#---------------------------------------------------------------------------------------------------------------------------------------------------------------
class DefMoviePointDlg(QDialog,Ui_DefMoviePointDlg) :

    def __init__(self,timelineImage,VideoporamaInstance,parent=None):
      super(DefMoviePointDlg, self).__init__(parent)
      self.setupUi(self)
      self.setModal(True)
      self.IsMplayerIdleState1 = False                                    # Flag to know if mplayer is in idle state
      self.IsMplayerIdleState2 = False                                    # Flag to know if mplayer is in idle state
      self.IsMplayerIdleState3 = False                                    # Flag to know if mplayer is in idle state
      self.IsMplayerIdleState4 = False                                    # Flag to know if mplayer is in idle state
      self.IsMplayerIdleState5 = False                                    # Flag to know if mplayer is in idle state

      self.VideoporamaInstance = VideoporamaInstance
      self.timelineImage       = timelineImage                            # myLabel object
      self.SliderMoving        = False                                    # True if current Slider moving
      self.dureeTimer          = 50                                       # Pas du timer pour l'affichage du slidee (en ms)
      self.echelle             = 10                                       # Time is in 0.1 sec
      self.CurPos              = 0                                        # Current position of MPlayer
      self.SliderPos           = 0                                        # New position use during slider mode
      self.OldSliderPos        = 0                                        # Older position use during slider mode
      self.oldPlayMode         = False                                    # If true play mode will be set at slider process end
      self.StartVideo          = self.timelineImage.StartVideo            # Start position
      self.EndVideo            = self.timelineImage.EndVideo              # End position
      self.DurationVideo       = self.timelineImage.DurationVideo         # Duration of the zone
      self.InitialDurationVideo= self.timelineImage.InitialDurationVideo  # Duration of the movie
      self.Geometry            = self.timelineImage.MovieGeometry         # Geometry of the movie
      self.MaxTime             = 0
      self.CurrentMode         = 0                                        # 0=Idle,1=Play,2=Pause

      #----- Prepare MPlayer process
      self.timer          = QTimer(self)
      self.mplayerProcess = QProcess(self)
      self.mplayerProcess.setProcessChannelMode(QProcess.MergedChannels)
      #----- Prepare QLablel for MPlayer process
      self.cibleVideo.setAttribute(Qt.WA_OpaquePaintEvent,True)
      self.cibleVideo.setAttribute(Qt.WA_NoSystemBackground,True)
      self.cibleVideo.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
      #----- Setup window for movie (depend on movie geometry)
      if self.Geometry=="16:9" :  self.xmax=560
      else :                      self.xmax=420
      self.ymax=315
      self.cibleVideo.setFixedSize(self.xmax,self.ymax)
      #----- Init editors
      self.StartPosEd.setTime(self.StartVideo)
      self.EndPosEd.setTime(self.EndVideo)
      c1=self.DurationVideo.toString("HH:mm:ss.z")
      if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
      self.ActualDuration.setText(c1)
      self.StartPosEd.setMinimumTime(QTime(0,0,0))
      self.StartPosEd.setMaximumTime(self.EndVideo)
      self.EndPosEd.setMinimumTime(self.StartVideo)
      self.EndPosEd.setMaximumTime(self.InitialDurationVideo)
      self.MovieFileNameEd.setText(self.timelineImage.urlim)
      #----- Set handler
      self.connect(self.Ok,SIGNAL("pressed()"),self.VideoporamaInstance.TAB_Movie_DefMoviePointOk)
      self.connect(self.Cancel,SIGNAL("pressed()"),self.onCancel)
      self.connect(self.HelpBt,SIGNAL("pressed()"),self.onHelp)
      self.connect(self.mplayerProcess, SIGNAL('readyReadStandardOutput()'),self.MPlayerMessage)
      self.connect(self.mplayerProcess, SIGNAL('finished(int,QProcess::ExitStatus)'),self.MPlayerFinished)
      self.connect(self.MPlayerPlayPauseBT, SIGNAL('clicked()'),self.MPlayerPlayPauseBTPressed)
      self.connect(self.timer, SIGNAL('timeout()'), self.MPlayerTimerEvent)
      self.connect(self.DefStartPosBT,SIGNAL("clicked()"),self.OnDefStartPosBT)
      self.connect(self.DefEndPosBT,SIGNAL("clicked()"),self.OnDefEndPosBT)
      self.connect(self.StartPosEd,SIGNAL("timeChanged(QTime)"),self.OnDefStartPosEd)
      self.connect(self.EndPosEd,SIGNAL("timeChanged(QTime)"),self.OnDefEndPosEd)
      self.connect(self.SeekLeftBt,SIGNAL("clicked()"),self.OnSeekLeftBt)
      self.connect(self.SeekRightBt,SIGNAL("clicked()"),self.OnSeekRightBt)
      #----- Slider control
      self.connect(self.slider, SIGNAL('sliderPressed()'), self.MPlayerSliderPressed)
      self.connect(self.slider, SIGNAL('sliderReleased()'), self.MPlayerSliderReleased)
      self.connect(self.slider, SIGNAL('sliderMoved(int)'), self.MPlayerSliderMoved)
      #----- Start mplayer
      # winid format and output video mode depend on operating system
      if isWindows() : 
        if self.VideoporamaInstance.AEROCOMPATIBILITY==True: OutputString=str(self.cibleVideo.winId().__hex__())+u" -vo directx:noaccel" #gl:glfinish"
        else :                                               OutputString=str(self.cibleVideo.winId().__hex__())+u" -vo gl:glfinish" #directx:noaccel"
        exe = u"mplayer.exe"
        # Prepare url to play
        url = self.timelineImage.urlim.replace("\\","\\\\")
      else : 
        OutputString=QString.number(self.cibleVideo.winId())
        exe = u"mplayer"
        url = self.timelineImage.urlim
      Commande=u"\""+self.VideoporamaInstance.MP+exe+u"\" -zoom -vf scale="+str(self.xmax)+u":"+str(self.ymax)+u" -osdlevel 0 -aspect "+self.Geometry+u" -slave -idle -wid "+OutputString
      # Start mplayer
      self.mplayerProcess.start(QString(Commande))
      if not self.mplayerProcess.waitForStarted(3000):
        QMessageBox.critical(self, self.VideoporamaInstance.qtapp.translate("MPlayerDlg","Warning"), self.VideoporamaInstance.qtapp.translate("MPlayerDlg","Error when starting mplayer"))
        return False
      self.SendToMPlayer(u"loadfile \""+url+u"\" 0") #\npausing_keep_force seek "+pos+" 2")


    #--------------------------------------------------------------------
    #Function call each time help button is pressed
    #--------------------------------------------------------------------
    def onHelp(self):
      self.docw=DocHelp(self.VideoporamaInstance,self.VideoporamaInstance.qtapp.translate("Documentation","en-moviebox.html"),self)
      self.docw.show() 

    #--------------------------------------------------------------------
    #Function call each time close button is pressed
    #--------------------------------------------------------------------
    def onCancel(self):
      self.PrintDebug("onCancel")
      if self.mplayerProcess.state()!=QProcess.NotRunning:
        self.SendToMPlayer("quit") # Send a quit message to mplayer
        self.mplayerProcess.waitForFinished()
      self.close()

    #--------------------------------------------------------------------
    #Function call when dialog box close
    #--------------------------------------------------------------------
    def closeEvent(self, CloseEvent):
      self.PrintDebug("closeEvent")
      if self.mplayerProcess.state()!=QProcess.NotRunning:
        self.SendToMPlayer("quit") # Send a quit message to mplayer
        self.mplayerProcess.waitForFinished()

    #--------------------------------------------------------------------
    #Function call if mplayer crash
    #--------------------------------------------------------------------
    def MPlayerFinished(self, statutDeSortie, codeSortie):
      self.PrintDebug("MPlayerFinished")
      self.close()

    #--------------------------------------------------------------------
    #Function call each time start position is change
    #--------------------------------------------------------------------
    def OnDefStartPosEd(self,NewTime):
      self.StartVideo=NewTime
      self.DurationVideo=QTime(0,0,0).addMSecs(self.StartVideo.msecsTo(self.EndVideo))
      self.StartPosEd.setTime(self.StartVideo)
      self.EndPosEd.setMinimumTime(self.StartVideo)
      c1=self.DurationVideo.toString("HH:mm:ss.z")
      if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
      self.ActualDuration.setText(c1)
      DrawMovieRuller(self.CustomWidget,self.StartVideo,self.EndVideo,self.InitialDurationVideo)

    #--------------------------------------------------------------------
    #Function call each time start position is change
    #--------------------------------------------------------------------
    def OnDefEndPosEd(self,NewTime):
      self.EndVideo=NewTime
      self.DurationVideo=QTime(0,0,0).addMSecs(self.StartVideo.msecsTo(self.EndVideo))
      self.EndPosEd.setTime(self.EndVideo)
      self.StartPosEd.setMaximumTime(self.EndVideo)
      c1=self.DurationVideo.toString("HH:mm:ss.z")
      if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
      self.ActualDuration.setText(c1)
      DrawMovieRuller(self.CustomWidget,self.StartVideo,self.EndVideo,self.InitialDurationVideo)

    #--------------------------------------------------------------------
    #Function call each time use current position at start position button is pressed
    #--------------------------------------------------------------------
    def OnDefStartPosBT(self):
      NewTime=QTime(0,0,0).addMSecs(self.CurPos*100)
      if NewTime.msecsTo(self.EndVideo)<=100:
        QMessageBox.critical(self,self.VideoporamaInstance.qtapp.translate("DefMoviePoint","Warning"), self.VideoporamaInstance.qtapp.translate("DefMoviePoint","The start position can't be after the end position"))
      else:
        self.StartVideo=QTime(0,0,0).fromString(self.tempsChrono.text(),"HH:mm:ss.z")
        self.StartPosEd.setTime(self.StartVideo)
        self.EndPosEd.setMinimumTime(self.StartVideo)

        self.DurationVideo=QTime(0,0,0).addMSecs(self.StartVideo.msecsTo(self.EndVideo))
        c1=self.DurationVideo.toString("HH:mm:ss.z")
        if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
        self.ActualDuration.setText(c1)
        DrawMovieRuller(self.CustomWidget,self.StartVideo,self.EndVideo,self.InitialDurationVideo)

    #--------------------------------------------------------------------
    #Function call each time use current position at end position button is pressed
    #--------------------------------------------------------------------
    def OnDefEndPosBT(self):
      NewTime=QTime(0,0,0).addMSecs(self.CurPos*100)
      if self.StartVideo.msecsTo(NewTime)<=100:
        QMessageBox.critical(self,self.VideoporamaInstance.qtapp.translate("DefMoviePoint","Warning"), self.VideoporamaInstance.qtapp.translate("DefMoviePoint","The end position can't be before the start position"))
      else:
        self.EndVideo=QTime(0,0,0).fromString(self.tempsChrono.text(),"HH:mm:ss.z")
        self.EndPosEd.setTime(self.EndVideo)
        self.StartPosEd.setMaximumTime(self.EndVideo)

        self.DurationVideo=QTime(0,0,0).addMSecs(self.StartVideo.msecsTo(self.EndVideo))
        c1=self.DurationVideo.toString("HH:mm:ss.z")
        if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
        self.ActualDuration.setText(c1)
        DrawMovieRuller(self.CustomWidget,self.StartVideo,self.EndVideo,self.InitialDurationVideo)

    #--------------------------------------------------------------------
    #Function call each time Go to start position button is pressed
    #--------------------------------------------------------------------
    def OnSeekLeftBt(self):
      self.CurPos=QTime(0,0,0).msecsTo(self.StartVideo)
      c1=QTime(0,0,0).addMSecs(self.CurPos*self.echelle).toString("HH:mm:ss.z")
      if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
      self.tempsChrono.setText(c1)
      if self.CurrentMode==1: # lecture
        #Seek mplayer continuing play
        self.SendToMPlayer("seek "+str(int(self.CurPos/self.echelle))+" 2") # SEEK x 2=is a seek to an absolute position of <value> seconds
      elif self.CurrentMode==2:  # Pause
        #Seek mplayer keeping the pause
        self.SendToMPlayer("pausing_keep seek "+str(int(self.CurPos/self.echelle))+" 2") # SEEK x 2=is a seek to an absolute position of <value> seconds
        self.slider.setValue(self.CurPos)

    #--------------------------------------------------------------------
    #Function call each time Go to end position button is pressed
    #--------------------------------------------------------------------
    def OnSeekRightBt(self):
      self.CurPos=QTime(0,0,0).msecsTo(self.EndVideo)
      c1=QTime(0,0,0).addMSecs(self.CurPos*self.echelle).toString("HH:mm:ss.z")
      if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
      self.tempsChrono.setText(c1)
      #Seek mplayer keeping the pause
      if self.CurrentMode==1: # lecture
        #Seek mplayer continuing play
        self.SendToMPlayer("seek "+str(int(self.CurPos/self.echelle))+" 2") # SEEK x 2=is a seek to an absolute position of <value> seconds
      elif self.CurrentMode==2:  # Pause
        #Seek mplayer keeping the pause
        self.SendToMPlayer("pausing_keep seek "+str(int(self.CurPos/self.echelle))+" 2") # SEEK x 2=is a seek to an absolute position of <value> seconds
        self.slider.setValue(self.CurPos)

    #--------------------------------------------------------------------
    # Display current time position and seek mplayer
    #--------------------------------------------------------------------
    def DisplayImg(self,pos):
      self.PrintDebug("DisplayImg")
      self.CurPos=pos
      pos=float(pos)/float(self.echelle)
      pos="%0.1f"%pos
      c1=QTime(0,0,0).addMSecs(self.CurPos*100).toString("HH:mm:ss.z")
      if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
      self.tempsChrono.setText(c1)
      if self.CurrentMode==0: # idle
        if self.CurPos<self.MaxTime:
          self.SendToMPlayer("pausing_keep loadfile \""+self.PrepFilename+"\" 0") # loadfile 0=not append but replace current list
          self.CurrentMode=2
      #Seek mplayer keeping the pause
      self.SendToMPlayer("pausing_keep seek "+pos+" 2") # SEEK x 2=is a seek to an absolute position of <value> seconds

    #--------------------------------------------------------------------
    #Function call each time a Slider process start
    #--------------------------------------------------------------------
    def MPlayerSliderPressed(self):
      self.PrintDebug("MPlayerSliderPressed")
      self.OldSliderPos=-1              # Force update of older position
      self.SliderMoving=True            # Changer timer mode to slider mode

      # If MPlayer is playing : set it to pause
      if self.CurrentMode==1: # play
        self.oldPlayMode=True           # Play mode will be keep when slider process end
        self.SendToMPlayer("pause")
      elif self.CurrentMode==2: # pause
        self.oldPlayMode=False     # Pause mode will be keep when slider process end
        self.timer.start(self.dureeTimer)
      else: # idle-> Cycle StartPauseSeek
        if self.CurPos<self.MaxTime:
          self.SendToMPlayer("pausing_keep loadfile \""+self.PrepFilename+"\" 0") # loadfile 0=not append but replace current list
          self.oldPlayMode=False     # Pause mode will be keep when slider process end
        self.timer.start(self.dureeTimer)

    #--------------------------------------------------------------------
    #Slider process
    #--------------------------------------------------------------------
    def MPlayerSliderMoved(self, pos):
      self.PrintDebug("MPlayerSliderMoved")
      self.CurPos=pos
      
    #--------------------------------------------------------------------
    #Function call each time a Slider process stop
    #--------------------------------------------------------------------
    def MPlayerSliderReleased(self):
      self.PrintDebug("MPlayerSliderReleased")
      pos=float(self.CurPos)/float(self.echelle)
      pos="%0.1f"%pos
      if self.oldPlayMode==True:
        #If mplayer playing when slider process start
        self.SendToMPlayer("seek " +pos+" 2") # SEEK x 2=is a seek to an absolute position of <value> seconds
        self.MplayerPlayMode, self.MplayerPauseMode = True, False
        self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_play.png"))
      else :
        #If mplayer was pause when slider process start
        self.SendToMPlayer("pausing_keep seek "+pos+" 2") # SEEK x 2=is a seek to an absolute position of <value> seconds
        self.timer.stop()
      self.SliderMoving=False   # Changer timer mode to normal

    #--------------------------------------------------------------------
    #Function call each time play/pause buttun is pressed
    #--------------------------------------------------------------------
    def MPlayerPlayPauseBTPressed(self):
      self.PrintDebug("MPlayerPlayPauseBTPressed")
      
      if self.CurrentMode==0: # idle        #If mplayer is not running : start mplayer
        self.MPlayerStartPlay()

      elif self.CurrentMode==1: # play      #If mplayer is running : go to pause
        self.SendToMPlayer("pause\npausing_keep_force get_property pause")

      elif self.CurrentMode==2 and self.CurPos<self.MaxTime:    #If mplayer is pausing : go to play
        self.SendToMPlayer("play\nget_property pause")

    #--------------------------------------------------------------------
    #Function call each time a Timer Event is send
    #--------------------------------------------------------------------
    def MPlayerTimerEvent(self):
      """Request the actual display time to MPlayer"""
      #self.PrintDebug("MPlayerTimerEvent")
      self.mplayerProcess.write("get_time_pos\n")
  
      if self.SliderMoving==True : # if timer mode is slider mode
        if self.OldSliderPos!=self.CurPos:
          # Ask mplayer to display image at new position keeping pause
          self.DisplayImg(self.CurPos)
          self.OldSliderPos=self.CurPos         # Save current position
      elif self.CurrentMode!=0:
        # Ask mplayer for current position => Message will be receive by MPlayerMessage
        self.SendToMPlayer("pausing_keep get_time_pos")
        if self.IsMplayerIdleState1==False:
          self.IsMplayerIdleState1 = True       # Set first flag to know if mplayer is in idle state
        else:
          if self.IsMplayerIdleState2==False:
            self.IsMplayerIdleState2=True       # Set secondflag to know if mplayer is in idle state
          else :
            if self.IsMplayerIdleState3==False:
              self.IsMplayerIdleState3=True       # Set secondflag to know if mplayer is in idle state
            else :
              if self.IsMplayerIdleState4==False:
                self.IsMplayerIdleState4=True       # Set secondflag to know if mplayer is in idle state
              else :
                if self.IsMplayerIdleState5==False:
                  self.IsMplayerIdleState5=True       # Set secondflag to know if mplayer is in idle state
                else :
                  # Previous last 5 message not receive answer => mplayer is in idle state
                  #print "Idle state"
                  # Go to stop mode
                  self.CurrentMode=0
                  self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_pause.png"))
                  self.timer.stop()

    #--------------------------------------------------------------------
    #Function call each time mplayer send us a message
    #--------------------------------------------------------------------
    def MPlayerMessage(self):
      self.PrintDebug("MPlayerMessage")
      # Reset flag to know if mplayer is in idle state
      self.IsMplayerIdleState1 = False
      self.IsMplayerIdleState2 = False
      self.IsMplayerIdleState3 = False                                    # Flag to know if mplayer is in idle state
      self.IsMplayerIdleState4 = False                                    # Flag to know if mplayer is in idle state
      self.IsMplayerIdleState5 = False                                    # Flag to know if mplayer is in idle state

      # Read message from mplayer
      while self.mplayerProcess.canReadLine(): # While data can be read
        # Read a line
        tampon=QByteArray(self.mplayerProcess.readLine())
        print QString(tampon)
        if tampon=="\n" or tampon.startsWith("VO:")==True or tampon.startsWith("A:")==True or tampon.startsWith("X11 error:")==True or tampon.startsWith("VDec:")==True:
          None
        else:
          tampon.replace(QByteArray("\n"), QByteArray(""))
          # Answer to Playing message (send by mplayer when it open the file)
          if tampon.startsWith("Playing"):
            None
            #print "Playing="+tampon

          # Answer to Starting playback message (send by mplayer when it start playing)
          elif tampon.startsWith("Starting playback") :
            if self.SliderMoving!=True :
              #print "first start play="+tampon
              self.SendToMPlayer("pausing_keep get_time_length")    # Ask mplayer for movie length
            else:
              #print "Resume start play for slider process"
              self.CurrentMode=2
              self.timer.start(self.dureeTimer)                 # Start timer event

          elif tampon.startsWith("ANS_pause"):
            tampon.remove(0,10) # vire ANS_pause=
            if tampon=="no" and self.CurPos<self.MaxTime:
              self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_play.png"))
              #print "self.CurrentMode=Play"
              self.CurrentMode=1
              self.timer.start(self.dureeTimer)                 # Start timer event
            else:
              self.MPlayerPlayPauseBT.setIcon(QIcon("icons"+QDir().separator().toAscii()+"player_pause.png"))
              if self.SliderMoving==True: self.timer.start(self.dureeTimer)
              else :                      self.timer.stop()
              #print "self.CurrentMode=Pause"
              self.CurrentMode=2

          # Answer to get_time_length : ANS_LENGTH=xx.yy message
          elif tampon.startsWith("ANS_LENGTH"):
            tampon.remove(0, 11) # vire ANS_LENGTH=
            tampon.replace(QByteArray("'"), QByteArray(""))
            tampon.replace(QByteArray(" "), QByteArray(""))
            tampon.replace(QByteArray("\r"), QByteArray(""))
            # Adjust tempsMax to 100 msec
            tempsMax = QString(tampon)
            if tempsMax.contains("."): tempsMax = tempsMax.mid(0,tempsMax.indexOf(".")+2)
            tempsMax = tempsMax.toFloat()[0]
            self.MaxTime=int(tempsMax*self.echelle)
            self.InitialDurationVideo=QTime(0,0,0).addMSecs(self.MaxTime*100)
            c1=self.InitialDurationVideo.toString("HH:mm:ss.z")
            if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
            self.InitialDurationLabel.setText(c1)
            self.slider.setMaximum(self.MaxTime)
            DrawMovieRuller(self.CustomWidget,self.StartVideo,self.EndVideo,self.InitialDurationVideo) # Draw zone
            pos=float(self.CurPos)/float(self.echelle)
            pos="%0.1f"%pos
            c1=QTime(0,0,0).addMSecs(self.CurPos).toString("HH:mm:ss.z")
            if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
            self.SendToMPlayer("pausing_keep seek "+pos+" 2\npausing_keep get_property pause")

          # Answer to get_time_length : get_time_pos : ANS_TIME_POSITION=xx.y message
          elif tampon.startsWith("ANS_TIME_POSITION"):
            tampon.remove(0, 18) # vire ANS_TIME_POSITION=
            tampon.replace(QByteArray("'"), QByteArray(""))
            tampon.replace(QByteArray(" "), QByteArray(""))
            tampon.replace(QByteArray("\r"), QByteArray(""))
            # Adjust tempsCourant to 100 msec
            tempsCourant = QString(tampon)
            if tempsCourant.contains("."): tempsCourant = tempsCourant.mid(0,tempsCourant.indexOf(".")+2)
            tempsCourant = tempsCourant.toFloat()[0]
            self.slider.setValue(tempsCourant*self.echelle)
            self.CurPos=int(tempsCourant*self.echelle)
            # Display time 
            c1=QTime(0,0,0).addMSecs(tempsCourant*1000).toString("HH:mm:ss.z")
            if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
            self.tempsChrono.setText(c1)


    #--------------------------------------------------------------------
    #Debug functions
    #--------------------------------------------------------------------
    def MPlayerStartPlay(self) :
      self.PrintDebug("MPlayerStartPlay")
      if self.CurPos<self.MaxTime:
        pos=float(self.CurPos)/float(self.echelle)
        pos="%0.1f"%pos
        c1=QTime(0,0,0).addMSecs(self.CurPos).toString("HH:mm:ss.z")
        if c1.contains("."): c1=c1.mid(0,c1.indexOf(".")+2)
        # loadfile 0=not append but replace current list
        self.SendToMPlayer("pausing_keep_force loadfile \""+self.PrepFilename+"\" 0") #\npausing_keep_force seek "+pos+" 2")

    #--------------------------------------------------------------------
    #Function call to stop mplayer
    #--------------------------------------------------------------------
    def SendToMPlayer(self,Message):
      #print Message
      Message=Message+"\n"
      self.mplayerProcess.write(Message)
      
    def PrintDebug(self,Proc):
      None
      #print Proc+":"+str(self.CurPos)+"/"+str(self.MaxTime)+" - "+str(self.CurrentMode)+"["+str(self.SliderMoving)+"]"
