
/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb.h>
#include <vdkb2/vdkb_types.h>
//#include <vdkb2/vdkb_labelbutton.h>
#include <vdkb2/vdkb_textlabel.h> 
#include <vdkb2/vdkb_frame.h>
#include <vdkb2/vdkb_pixmap.h>
#include <vdkb2/vdkb_image.h>
#include <vdkb2/vdkb_scrolled.h>
#include <vdkb2/vdkb_menubar.h>
#include <vdkb2/vdkb_menuitem.h>
#include <vdkb2/vdkb_textwidget.h>
#include <vdkb2/vdkb_paned.h>
#include <vdkb2/vdkb_entry.h>
#include <vdkb2/vdkb_notebook.h>
// #include <vdkb2/vdkb_pixbutton.h>
#include <vdkb2/vdkb_toolbar.h>
#include <vdkb2/vdkb_customlist.h>
#include <vdkb2/vdkb_customtree.h>
#include <vdkb2/vdkb_separator.h>
#include <vdkb2/vdkb_table.h>
#include <vdkb2/vdkb_rbgroup.h>
#include <vdkb2/vdkb_handlebox.h>
#include <vdkb2/vdkb_guicanvas.h>
#include <vdkb2/vdkb_combo.h>
#include <vdkb2/vdkb_checkbutton.h>
#include <vdkb2/vdkb_radiobutton.h>
#include <vdkb2/vdkb_spinbutton.h>
#include <vdkb2/vdkb_pbar.h>
#include <vdkb2/vdkb_custombutton.h>
#include <vdkb2/vdkb_sbar.h>
// #include <vdkb2/vdkb_treeview.h>
// #include <vdkb2/vdkb_grid.h>
//#include <vdkb2/vdkb_packer.h>
#include <vdkb2/vdkb_slider.h>
#include <vdkb2/vdkb_pholder.h>
#include <vdkb2/vdkb_fixed.h>
#if HAVE_GNOME
#include <vdkb2/vdkb_gnomeappbar.h>
#include <vdkb2/vdkb_dedit.h>
#include <vdkb2/vdkb_gnomeentry.h>
#endif
#if USE_XDB
#include <vdkb2/vdkb_xentry.h>
#include <vdkb2/vdkb_xcheckbutton.h>
#include <vdkb2/vdkb_xmemo.h>
#include <vdkb2/vdkb_xcustomlist.h>
#endif
#include <ctype.h>
static char buff[256];
extern VDKBuilder* TheApp;
extern char* source_prompts[];
/*
Generic runtime new widget creation.
Scans vdkclasstypes table and call
static constructors mapped with class name.
Newly constructed widget will be added directly
to his parent (target). Target must be a container
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
3 - no active widget
 */
// class id's - static constructors table
struct
{
  int action_target;
  int (*make_widget)(VDKBGuiForm* owner, GdkEvent* ev);
  char* widgetName;
} vdkclasstypes[] =
// button id conventions:
// XXXX_TOOL_YYYY_ZZZZ
// where XXXX is palette name
//       YYYY_ZZZZ widget class name
// id's defined in vdkb_types.h
{
  // containers
  { CONTAINERS_TOOL_VBOX, VDKBEventBox::MakeWidgetV, "VDKBox"},
  { CONTAINERS_TOOL_HBOX, VDKBEventBox::MakeWidgetH, "VDKBox"},
  { CONTAINERS_TOOL_FRAME, VDKBFrame::MakeWidget, "VDKFrame"},
  { CONTAINERS_TOOL_SCROLLED, VDKBScrolled::MakeWidget, "VDKScrolled"},
  { CONTAINERS_TOOL_MENUBAR, VDKBMenubar::MakeWidget, "VDKMenubar"},
  { CONTAINERS_TOOL_VPANED, VDKBPaned::MakeWidgetV, "VDKPaned"},
  { CONTAINERS_TOOL_HPANED, VDKBPaned::MakeWidgetH, "VDKPaned"},
  { CONTAINERS_TOOL_NBOOK, VDKBGuiNotebook::MakeWidget, "VDKNotebook"},
  { CONTAINERS_TOOL_TOOLBAR,VDKBToolbar::MakeWidget, "VDKToolbar"},
  { CONTAINERS_TOOL_TABLE, VDKBTable::MakeWidget, "VDKTable" },
  { CONTAINERS_TOOL_VRADIOBG, VDKBRadioButtonGroup::MakeWidgetV,
    "VDKRadioButtonGroup" },
  { CONTAINERS_TOOL_HRADIOBG, VDKBRadioButtonGroup::MakeWidgetH,
    "VDKRadioButtonGroup" },
  { CONTAINERS_TOOL_HANDLE, VDKBHandleBox::MakeWidget, "VDKHandleBox" },
  //  { CONTAINERS_TOOL_PACKER, VDKBPacker::MakeWidget, "VDKPacker" }, 
  { CONTAINERS_TOOL_FIXED, VDKBFixed::MakeWidget, "VDKFixed" },
  // buttons
  //  { BUTTON_TOOL_LABEL_BUTTON, VDKBLabelButton::MakeWidget, "VDKLabelButton"},
  //  { BUTTON_TOOL_PIXMAP_BUTTON,VDKBPixmapButton::MakeWidget, "VDKPixmapButton"},
  { BUTTON_TOOL_CHECK_BUTTON, VDKBCheckButton::MakeWidget, "VDKCheckButton"},
  { BUTTON_TOOL_RADIO_BUTTON,VDKBRadioButton::MakeWidget, "VDKRadioButton"},
  { BUTTON_TOOL_SPIN_BUTTON,VDKBSpinButton::MakeWidget, "VDKSpinButton"},
  { BUTTON_TOOL_CUSTOM_BUTTON,VDKBCustomButton::MakeWidget, "VDKCustomButton"},
  // texts
  { TEXT_TOOL_LABEL, VDKBTextLabel::MakeWidget, "VDKLabel"},
  { TEXT_TOOL_TEXT, VDKBTextWidget::MakeWidget, "VDKTextView"},
  { TEXT_TOOL_ENTRY, VDKBEntry::MakeWidget, "VDKEntry"},
  // misc
  { MISC_TOOL_CANVAS,VDKBGuiCanvas::MakeWidget, "VDKCanvas"},
  { MISC_TOOL_PIXMAP, VDKBPixmap::MakeWidget, "VDKPixmap"},
  { MISC_TOOL_IMAGE, VDKBImage::MakeWidget, "VDKImage"},
  // { MISC_TOOL_MENU_ITEM, VDKBMenuItem::MakeWidget, "VDKMenuItem"},
  { MISC_TOOL_CUSTOMLIST,VDKBCustomList::MakeWidget, "VDKCustomList"},
  { MISC_TOOL_COMBOBOX,VDKBCombo::MakeWidget, "VDKCombo"},
  { MISC_TOOL_CUSTOMTREE,VDKBGuiCustomTree::MakeWidget, "VDKCustomTree"},
  { MISC_TOOL_HSEPARATOR,VDKBSeparator::MakeWidgetH, "VDKSeparator"},
  { MISC_TOOL_VSEPARATOR,VDKBSeparator::MakeWidgetV, "VDKSeparator"},
  { MISC_TOOL_PROGRESS,VDKBProgressBar::MakeWidget, "VDKProgressBar"},
  { MISC_TOOL_STATUSBAR,VDKBStatusbar::MakeWidget, "VDKStatusbar"},
  //   { MISC_TOOL_GRID,VDKBGrid::MakeWidget, "VDKGrid"},
  { MISC_TOOL_SLIDER,VDKBSlider::MakeWidget, "VDKSlider"},
  { MISC_TOOL_PLACEHOLDER,VDKBPlaceHolder::MakeWidget, "VDKPlaceHolder"},
  //   { MISC_TOOL_TREEVIEW,VDKBTreeView::MakeWidget, "VDKTreeView"},
  // gnome widgets
#if HAVE_GNOME
  { GNOME_TOOL_STATUSBAR,VDKBGnomeAppBar::MakeWidget, "VDKGnomeAppBar"},
  { GNOME_TOOL_DATEEDIT,VDKBGnomeDateEdit::MakeWidget, "VDKGnomeDateEdit"},
  { GNOME_TOOL_ENTRY,VDKBGnomeEntry::MakeWidget, "VDKGnomeEntry"},
#endif
  // xdb support
#if USE_XDB
  { XDB_TOOL_ENTRY,VDKBXEntry::MakeWidget, "VDKXEntry"},
  { XDB_TOOL_CHECK_BUTTON,VDKBXCheckButton::MakeWidget, "VDKXCheckButton"},
  { XDB_TOOL_MEMO,VDKBXMemo::MakeWidget, "VDKXMemo"},
  { XDB_TOOL_CUSTOMLIST,VDKBXCustomList::MakeWidget, "VDKXCustomList"},
#endif
  // table end
  {-1,NULL,NULL}
};
/*
 */
int
MakeWidget(VDKBGuiForm* owner, int action_target, GdkEvent* ev)
{
int t;
int result = 1; // unsupported widget
for(t=0; vdkclasstypes[t].action_target != -1; t++)
  if(vdkclasstypes[t].action_target == action_target)
    {
      result =  vdkclasstypes[t].make_widget(owner,ev);
      break;
    }
// statically unsopported widget
// try to seek it into plugins list
if(result == 1)
  {
    VDKBAbstractComponentInterface* interface =
      TheApp->PluginList().Interface(action_target);
    if(interface)
      result =  interface->MakeWidget(owner,ev);
  }
return result;
}
/*
given an widget class name
returns widget id
*/
int
WidgetClassId(char* class_name)
{
int t;
int result = -1; // unsupported widget
for(t=0; vdkclasstypes[t].action_target != -1; t++)
  if(!strcmp(vdkclasstypes[t].widgetName,class_name))
    {
      result =  vdkclasstypes[t].action_target;
      break;
    }
return result;
}
/*
given an widget id
returns widget class name
*/
char*
WidgetClassName(int action_target)
{
int t;
char* result = NULL; // unsupported widget
for(t=0; vdkclasstypes[t].action_target != -1; t++)
  if(vdkclasstypes[t].action_target == action_target)
    {
      result =  vdkclasstypes[t].widgetName;
      break;
    }
return result;
}
//////////////////////////////////////////////////////
/*
obsolete, not more used.
 */
void
VDKBProjectManager::ChildResized(VDKBGuiForm* child,
				 VDKPoint& newsize)
{
  // safe and safer
if(!ActiveChild.child || ActiveChild.child != child)
  return;

 char match[32],replace[32],textname[256];

 sprintf(match,"%s.Usize:",(char*) ActiveChild.name);
 sprintf(replace,"%s.Usize:%4d,%4d;",
	 (char*) ActiveChild.name,
	 newsize.X(),newsize.Y());
 sprintf(textname,"%s.%s",(char*) ActiveChild.name,FORM_EXT);
 // replaces <match> with<replace> in <textname>
 ReplaceAllMatches(match,
		   replace,
		   textname,
		   /*
		     forward offset, replace more chars than match,
		     useful for changing args.
		     If match = replace set offset to 0
		   */
		   strlen(replace)-strlen(match),
		   false); // not all
child->Changed = true;
}

/*
 */
void
VDKBProjectManager::ReplaceAllMatches(char* match,
				      char* replace,
				      char* textname,
				      int offset,
				      bool all)
{
  VDKBMainForm* mainform = (VDKBMainForm*) Owner();
  VDKBEditor* editor = mainform->MakeEditor();
  if(! editor)
    return;
  else if(! editor->Visible)
    editor->Visible = true;
  else if(editor->Iconized )
    editor->Iconized = false;
  VDKBText* text = NULL;
  int t = -1;
  mainform->MakeEditor();
  // look for editor page
  TextListIterator li(editor->textlist);
  for(;li;li++)
    {
      if(! strcmp(li.current()->ShortName(),textname))
	{
	  text = li.current();
	  break;
	}
    }
   if(! text)
     {
       ActivateEditor(textname,false,false);
       // find text page
       t  = editor->nbook->ActivePage;
       if(t<0)
	 return;
       else
	 text = editor->textlist[t];
     }
   // just for safe
   if(! text)
     return;
   // replace all occurrences
   int pos = 0;
   while(pos >= 0 && pos < (int) text->Length)
     {
       pos = text->Search(match, pos, true, false); // no bell
       if(pos >= 0)
	 {
	   text->Pointer = pos;
	   text->ForwardDelete(strlen(match)+offset);
	   text->Pointer = pos;
	   text->TextInsert(replace);
	   pos += strlen(replace);
	 }
       if(! all)
	 break;
     }
   text->Save(textname);
   text->Changed = false;
}
/*
defines or jump to response method
 */
void
VDKBProjectManager::DefineResponseMethod( char* textname, char* method)
{
   VDKBMainForm* mainform = (VDKBMainForm*) Owner();
   VDKBEditor* editor = mainform->MakeEditor();
   if(! editor)
     return;
   else if(! editor->Visible)
     editor->Visible = true;
   else if(editor->Iconized )
     editor->Iconized = false;

   VDKBText* text = NULL;
   int t = 0;
   // look for editor page
   TextListIterator li(editor->textlist);
   for(;li;li++,t++)
    {
      if(! strcmp(li.current()->ShortName(),textname))
	{
	  text = li.current();
	  break;
	}
    }

   if(text)
     editor->nbook->ActivePage = t;
   else
     {
       // open a new notebook page and set it as active page
       ActivateEditor(textname,true,true);
       // find text page address
       t  = editor->nbook->ActivePage;
       if( t < 0)
	 return;
       else
	 text = editor->textlist[t];
     }
   // just for safe
   if(! text) return;
   int pos = text->Search(method, 0, true, false); // no bell
   if(pos < 0)
     {
       char formname[64];
       strcpy(formname,ActiveChild.name);
       formname[0] = toupper(formname[0]);
       text->Pointer = text->Length;
       pos = text->Search(SOURCE_END_MARK, 0, false, false);
       if(pos >= 0)
	 text->Pointer = pos+strlen(SOURCE_END_MARK);
       else
	 {
	   pos = text->Length;
	   text->Pointer = pos;
	 }
       sprintf(buff, "\n//%s\nbool \n%sForm::%s(VDKObject* sender) \n{\n return true;\n }\n ",
	       source_prompts[8],
	       formname,
	       method);
       text->TextInsert(buff);
       pos = text->Search(method, pos, true, false);
     }
}


/*
defines or jump to response method
 */
/*
 */

FormEventHandlers evTableItems [] =
{
  {{ "OnFormActivate","no" }, "OnFormActivate(VDKForm* sender, bool in_out)"},
  {{ "OnChildClosing","no" }, "OnChildClosing(VDKForm* child)" },
  {{ "OnConfigure","no"    }, "OnConfigure(VDKForm* sender)"},
  {{ "OnExpose","no"       }, "OnExpose(VDKForm* sender, GdkRectangle area)"},
  {{ "OnIconize","no"      }, "OnIconize(VDKForm* sender)"},
  {{ "OnMove","no"         }, "OnMove(VDKForm* sender)"},
  {{ "OnRealize","no"      }, "OnRealize(VDKForm* sender)"},
  {{ "OnResize","no"       }, "OnResize(VDKForm* sender, VDKPoint& new_size)"},
  {{ "OnRestore","no"      }, "OnRestore(VDKForm* sender)"},
  {{ "OnShow","no"         }, "OnShow(VDKForm* sender)"},
  {{ "CanClose","no"       }, "CanClose(void)" }, 
  {{ NULL, NULL }}
};

const char* CANCLOSE = "CanClose";

/*
 */
void
VDKBProjectManager::DefineFormEventHandler( char* textname, char* handler)
{
  char* method = NULL;
  VDKBMainForm* mainform = (VDKBMainForm*) Owner();
  VDKBEditor* editor = mainform->MakeEditor();
   if(! editor)
     return;
   else if(! editor->Visible)
     editor->Visible = true;
   else if(editor->Iconized )
     editor->Iconized = false;
   VDKBText* text = NULL;
   int t = 0;
   // look for editor page
   TextListIterator li(editor->textlist);
   for(;li;li++,t++)
    {
      if(! strcmp(li.current()->ShortName(),textname))
	{
	  text = li.current();
	  break;
	}
    }

   if(text)
     editor->nbook->ActivePage = t;
   else
     {
       // open a new notebook page and set it as active page
       ActivateEditor(textname,true,true);
       // find text page address
       t  = editor->nbook->ActivePage;
       if( t < 0)
	 return;
       else
	 text = editor->textlist[t];
     }
   // just for safe
   if(! text) return;
   // match handler/method
   int z = 0;
   for(z=0; evTableItems [z].items[0];z++)
     if(!strcmp(handler,evTableItems [z].items[0]))
       method = evTableItems [z].method;
   if(method)
     {
       int pos = text->Search(method, 0, true, false); // no bell
       if(pos < 0)
	 {
	   char formname[64];
	   strcpy(formname,ActiveChild.name);
	   formname[0] = toupper(formname[0]);
	   pos = text->Search(SOURCE_END_MARK, 0, false, false);
	   if(pos >= 0)
	     text->Pointer = pos+strlen(SOURCE_END_MARK);
	   else
	     text->Pointer = text->Length;
	   // scans some exception here
	   if(!strcmp(handler,CANCLOSE))
	     sprintf(buff, 
		     "\n//%s\nbool\n%sForm::%s\n{\nreturn true;\n}\n",
		     source_prompts[9],
		     formname,method);
	     else
	       sprintf(buff, 
		       "\n//%s\nvoid\n%sForm::%s\n{\nreturn;\n}\n",
		       source_prompts[9],
		       formname,method);
	   // writes method code
	   text->TextInsert(buff);
	   text->Search(method, 0, true, false);
	 }
     }
}
/*
 */
void
VDKBProjectManager::ActivateChild(VDKBGuiForm* sender,
				bool active)
{
  bool redundant = ActiveChild.child && 
    (ActiveChild.child == sender);
  if(redundant && active)
      return;
  else if(active)
    {
      ActiveChild.child = sender;
      ActiveChild.name = sender->Name();
      //
      VDKTreeNode node = tree->SelectedNode;
      if(node)
	tree->UnselectedNode = node;
      
      ActiveChild.child = sender;
      ActiveChild.name = sender->Name();
      
      
      VDKTreeNodeList* list = tree->Find((char*) sender->FileName());
      if(list->size() > 0)
	tree->SelectedNode = (*list)[0];
      delete list;
      
      // no node selected so get away
      node = tree->SelectedNode;
      if(node)
	{
	  gpointer p =
	    gtk_ctree_node_get_row_data(GTK_CTREE(tree->CustomWidget()),node);
	  	    (*toolbar)[OPEN_FILE_BUTTON]->Enabled = p == (gpointer) form_unit ?
	      true : false; 
	    
	}
      if(objInspector)
	{
	  objInspector->SetActive(NULL);
	  objInspector->LoadTree(sender);
	}
      //
      // enables form/text toggle button on main toolbar
      VDKBMainForm* mainform = (VDKBMainForm*) Owner();
      if(project)
	{
	  sprintf(buff,"%s/%s.cc",(char*) project->Path,
		  (char*) ActiveChild.name);
	  mainform->EnableToggleFormUnit(active,buff);
	}
    }
}

/*
 */
void
VDKBProjectManager::OnChildClosing(VDKForm* child)
{
GuiFormListIterator li(formlist);
for(;li;li++)
  if(li.current() == child)
    break;
// found and the only one on list
if(li && (formlist.size() == 1))
  {
    VDKBMainForm* mainform = (VDKBMainForm*) Owner();
    mainform->Automa(automa_edit_form_off);
  }
}
/*
 */
bool
VDKBProjectManager::IsFormChanged(char* name)
{
VDKString fname = name;
fname += ".";
fname += FORM_EXT;
GuiFormListIterator li(formlist);
for(;li;li++)
  {
    if(fname == li.current()->FileName())
      {
	if(li.current()->Changed)
	      return true;
      }
  }
return false;
}
/*
writes gui files if they do not exist or
<form name>.frm is changed
 */
void
VDKBProjectManager::WriteGuiFiles(bool ask)
{
  VDKTreeNodeList* list = tree->Select(".frm");
  if(list->size())
    {
      VDKTreeNodeListIterator li(*list);
      for(;li;li++)
	{
	  char* cc_ext  = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
	  char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
	  char *tmp, *local,*copy;
	  tmp = new char[256];
	  local = new char[512];
	  copy = new char[256];
	  strcpy(tmp,tree->Key(li.current()));
	  char* p = get_extension(tmp);
	  if(p)
	    *p = '\0';
	  sprintf(local,"%s_gui.%s",tmp,cc_ext);
	  strcpy(copy,local);
	  bool isChanged = IsFormChanged(tmp);
	  if(access(local,F_OK) || isChanged)//  || (!ask))
	    {
	      // update <form name>.frm
	      if(isChanged)
		{
		  GuiFormListIterator lf(formlist);
		  for(;lf;lf++)
		    {
		      VDKString fname = tmp;
		      fname += ".";
		      fname += FORM_EXT;
		      if(fname == lf.current()->FileName())
			{
			  if( (!ask || AskSaveForm(fname)) )
			    {
			      lf.current()->WriteFormFile();
			      lf.current()->Changed = false;
			      break;
			    }
			  else
			    lf.current()->Changed = isChanged = false;
			}
		    }
		}
	      // writes or update <form name>_gui .cc
	      if(strcmp(local,copy))
		 {
		   char *msg = new char[512];
		   sprintf(msg,"*** WARNING ***,\n\
attempt to overwrite <%s>\nwith <%s>\noperation aborted",local,copy);
		   Application()->VDKMessageBox(APPNAME,
				msg,
				VDK_ICONINFORMATION|VDK_OK,
				_(user_messages[user_ok]));
		   delete[] msg;
		 }
	      else  if(isChanged)
		{
		  FILE* fp = fopen(local,"w+");
		  if(!fp) break; // FIX ME : warn user
		  Project()->WriteGUISetupParsingFrm(fp, 
						     tree->Key(li.current()));
		  // writes or update <form name>_gui .h	
		  sprintf(local,"%s_gui.%s",tmp,h_ext);
		  fp = fopen(local,"w+");
		  if(!fp) break; // FIX ME : warn user
		  Project()->WriteGuiHeaderParsingFrm(fp, 
						      tree->Key(li.current()));
		}
	    }
	  delete[] tmp;
	  delete[] local;
	  delete[] copy;
	}
    }
  delete list;
}

extern int  AskUserToSaveFile(char* name);
/*
 */
bool
VDKBProjectManager::AskSaveForm(char* name)
{
  return AskUserToSaveFile(name) == VDK_IDYES;
}
