//
// Copyright 2023 Ettus Research, a National Instruments Brand
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: rfnoc_image_core (for e320)
//
// Description:
//
//   The RFNoC Image Core contains the Verilog description of the RFNoC design
//   to be loaded onto the FPGA.
//
//   This file was automatically generated by the RFNoC image builder tool.
//   Re-running that tool will overwrite this file!
//
// Source: e320_rfnoc_image_core.yml
//

`default_nettype none


module rfnoc_image_core #(
  parameter [31:0] CHDR_W     = 64,
  parameter [31:0] PORT_W     = 64,
  parameter [31:0] ETH_W      = 64,
  parameter [31:0] DMA_W      = 64,
  parameter        MTU        = 10,
  parameter [15:0] PROTOVER   = {8'd1, 8'd0},
  parameter        RADIO_NIPC = 1
) (
  // Clocks
  input  wire         chdr_aclk,
  input  wire         ctrl_aclk,
  input  wire         core_arst,
  input  wire         radio_clk,
  input  wire         dram_clk,
  // Basic
  input  wire [  15:0] device_id,

  // IO ports /////////////////////////

  // ctrlport
  output wire [   0:0] m_ctrlport_req_wr,
  output wire [   0:0] m_ctrlport_req_rd,
  output wire [  19:0] m_ctrlport_req_addr,
  output wire [  31:0] m_ctrlport_req_data,
  output wire [   3:0] m_ctrlport_req_byte_en,
  output wire [   0:0] m_ctrlport_req_has_time,
  output wire [  63:0] m_ctrlport_req_time,
  input  wire [   0:0] m_ctrlport_resp_ack,
  input  wire [   1:0] m_ctrlport_resp_status,
  input  wire [  31:0] m_ctrlport_resp_data,
  // time
  input  wire [  63:0] radio_time,
  // radio
  input  wire [ 255:0] radio_rx_data,
  input  wire [   7:0] radio_rx_stb,
  output wire [   7:0] radio_rx_running,
  output wire [ 255:0] radio_tx_data,
  input  wire [   7:0] radio_tx_stb,
  output wire [   7:0] radio_tx_running,
  // dram
  input  wire [   0:0] axi_rst,
  output wire [   3:0] m_axi_awid,
  output wire [ 191:0] m_axi_awaddr,
  output wire [  31:0] m_axi_awlen,
  output wire [  11:0] m_axi_awsize,
  output wire [   7:0] m_axi_awburst,
  output wire [   3:0] m_axi_awlock,
  output wire [  15:0] m_axi_awcache,
  output wire [  11:0] m_axi_awprot,
  output wire [  15:0] m_axi_awqos,
  output wire [  15:0] m_axi_awregion,
  output wire [   3:0] m_axi_awuser,
  output wire [   3:0] m_axi_awvalid,
  input  wire [   3:0] m_axi_awready,
  output wire [2047:0] m_axi_wdata,
  output wire [ 255:0] m_axi_wstrb,
  output wire [   3:0] m_axi_wlast,
  output wire [   3:0] m_axi_wuser,
  output wire [   3:0] m_axi_wvalid,
  input  wire [   3:0] m_axi_wready,
  input  wire [   3:0] m_axi_bid,
  input  wire [   7:0] m_axi_bresp,
  input  wire [   3:0] m_axi_buser,
  input  wire [   3:0] m_axi_bvalid,
  output wire [   3:0] m_axi_bready,
  output wire [   3:0] m_axi_arid,
  output wire [ 191:0] m_axi_araddr,
  output wire [  31:0] m_axi_arlen,
  output wire [  11:0] m_axi_arsize,
  output wire [   7:0] m_axi_arburst,
  output wire [   3:0] m_axi_arlock,
  output wire [  15:0] m_axi_arcache,
  output wire [  11:0] m_axi_arprot,
  output wire [  15:0] m_axi_arqos,
  output wire [  15:0] m_axi_arregion,
  output wire [   3:0] m_axi_aruser,
  output wire [   3:0] m_axi_arvalid,
  input  wire [   3:0] m_axi_arready,
  input  wire [   3:0] m_axi_rid,
  input  wire [2047:0] m_axi_rdata,
  input  wire [   7:0] m_axi_rresp,
  input  wire [   3:0] m_axi_rlast,
  input  wire [   3:0] m_axi_ruser,
  input  wire [   3:0] m_axi_rvalid,
  output wire [   3:0] m_axi_rready,

  // Transport Adapters ///////////////

  // Transport 0 (eth)
  input  wire [PORT_W-1:0] s_eth_tdata,
  input  wire              s_eth_tlast,
  input  wire              s_eth_tvalid,
  output wire              s_eth_tready,
  output wire [PORT_W-1:0] m_eth_tdata,
  output wire              m_eth_tlast,
  output wire              m_eth_tvalid,
  input  wire              m_eth_tready,
  // Transport 1 (dma)
  input  wire [PORT_W-1:0] s_dma_tdata,
  input  wire              s_dma_tlast,
  input  wire              s_dma_tvalid,
  output wire              s_dma_tready,
  output wire [PORT_W-1:0] m_dma_tdata,
  output wire              m_dma_tlast,
  output wire              m_dma_tvalid,
  input  wire              m_dma_tready
);

  localparam EDGE_TBL_FILE = `"`RFNOC_EDGE_TBL_FILE`";
  localparam BLOCK_CHDR_W  = 64;
  localparam BYTE_MTU      = MTU + $clog2(CHDR_W/8);
  localparam BLOCK_MTU     = BYTE_MTU - $clog2(BLOCK_CHDR_W/8);
  localparam EP0_W   = 64;
  localparam EP0_MTU = BYTE_MTU - $clog2(EP0_W/8);
  localparam EP1_W   = 64;
  localparam EP1_MTU = BYTE_MTU - $clog2(EP1_W/8);
  localparam EP2_W   = 64;
  localparam EP2_MTU = BYTE_MTU - $clog2(EP2_W/8);
  localparam EP3_W   = 64;
  localparam EP3_MTU = BYTE_MTU - $clog2(EP3_W/8);

  wire rfnoc_chdr_clk, rfnoc_chdr_rst;
  wire rfnoc_ctrl_clk, rfnoc_ctrl_rst;


  //---------------------------------------------------------------------------
  // CHDR Crossbar
  //---------------------------------------------------------------------------

  wire [PORT_W-1:0] xb_to_ep0_tdata ;
  wire              xb_to_ep0_tlast ;
  wire              xb_to_ep0_tvalid;
  wire              xb_to_ep0_tready;
  wire [PORT_W-1:0] ep0_to_xb_tdata ;
  wire              ep0_to_xb_tlast ;
  wire              ep0_to_xb_tvalid;
  wire              ep0_to_xb_tready;
  wire [PORT_W-1:0] xb_to_ep1_tdata ;
  wire              xb_to_ep1_tlast ;
  wire              xb_to_ep1_tvalid;
  wire              xb_to_ep1_tready;
  wire [PORT_W-1:0] ep1_to_xb_tdata ;
  wire              ep1_to_xb_tlast ;
  wire              ep1_to_xb_tvalid;
  wire              ep1_to_xb_tready;
  wire [PORT_W-1:0] xb_to_ep2_tdata ;
  wire              xb_to_ep2_tlast ;
  wire              xb_to_ep2_tvalid;
  wire              xb_to_ep2_tready;
  wire [PORT_W-1:0] ep2_to_xb_tdata ;
  wire              ep2_to_xb_tlast ;
  wire              ep2_to_xb_tvalid;
  wire              ep2_to_xb_tready;
  wire [PORT_W-1:0] xb_to_ep3_tdata ;
  wire              xb_to_ep3_tlast ;
  wire              xb_to_ep3_tvalid;
  wire              xb_to_ep3_tready;
  wire [PORT_W-1:0] ep3_to_xb_tdata ;
  wire              ep3_to_xb_tlast ;
  wire              ep3_to_xb_tvalid;
  wire              ep3_to_xb_tready;

  chdr_crossbar_nxn #(
    .PORT_W         (PORT_W),
    .NPORTS         (6),
    .CHDR_WIDTHS    ({EP3_W, EP2_W, EP1_W, EP0_W, DMA_W, ETH_W}),
    .DEFAULT_PORT   (0),
    .ROUTES         ({ 6'b111111,
                       6'b111111,
                       6'b111111,
                       6'b111111,
                       6'b111110,
                       6'b111101 }),
    .BYTE_MTU       (BYTE_MTU),
    .ROUTE_TBL_SIZE (6),
    .MUX_ALLOC      ("ROUND-ROBIN"),
    .OPTIMIZE       ("AREA"),
    .NPORTS_MGMT    (2),
    .EXT_RTCFG_PORT (0),
    .PROTOVER       (PROTOVER)
  ) chdr_crossbar_nxn_i (
    .clk            (rfnoc_chdr_clk),
    .reset          (rfnoc_chdr_rst),
    .device_id      (device_id),
    .s_axis_tdata   ({ep3_to_xb_tdata , ep2_to_xb_tdata , ep1_to_xb_tdata , ep0_to_xb_tdata , s_dma_tdata , s_eth_tdata }),
    .s_axis_tlast   ({ep3_to_xb_tlast , ep2_to_xb_tlast , ep1_to_xb_tlast , ep0_to_xb_tlast , s_dma_tlast , s_eth_tlast }),
    .s_axis_tvalid  ({ep3_to_xb_tvalid, ep2_to_xb_tvalid, ep1_to_xb_tvalid, ep0_to_xb_tvalid, s_dma_tvalid, s_eth_tvalid}),
    .s_axis_tready  ({ep3_to_xb_tready, ep2_to_xb_tready, ep1_to_xb_tready, ep0_to_xb_tready, s_dma_tready, s_eth_tready}),
    .m_axis_tdata   ({xb_to_ep3_tdata , xb_to_ep2_tdata , xb_to_ep1_tdata , xb_to_ep0_tdata , m_dma_tdata , m_eth_tdata }),
    .m_axis_tlast   ({xb_to_ep3_tlast , xb_to_ep2_tlast , xb_to_ep1_tlast , xb_to_ep0_tlast , m_dma_tlast , m_eth_tlast }),
    .m_axis_tvalid  ({xb_to_ep3_tvalid, xb_to_ep2_tvalid, xb_to_ep1_tvalid, xb_to_ep0_tvalid, m_dma_tvalid, m_eth_tvalid}),
    .m_axis_tready  ({xb_to_ep3_tready, xb_to_ep2_tready, xb_to_ep1_tready, xb_to_ep0_tready, m_dma_tready, m_eth_tready}),
    .ext_rtcfg_stb  (1'h0),
    .ext_rtcfg_addr (16'h0),
    .ext_rtcfg_data (32'h0),
    .ext_rtcfg_ack  ()
  );


  //---------------------------------------------------------------------------
  // Stream Endpoints
  //---------------------------------------------------------------------------

  // If requested buffer size is 0, use the minimum SRL-based FIFO size.
  // Otherwise, make sure it's at least two MTU-sized packets.
  localparam REQ_BUFF_SIZE_EP0 = 32768;
  localparam INGRESS_BUFF_SIZE_EP0 =
    REQ_BUFF_SIZE_EP0 == 0             ? 5         :
    REQ_BUFF_SIZE_EP0 < 2*(2**EP0_MTU) ? EP0_MTU+1 :
                                         $clog2(REQ_BUFF_SIZE_EP0);

  wire [BLOCK_CHDR_W-1:0] m_ep0_out0_tdata;
  wire                    m_ep0_out0_tlast;
  wire                    m_ep0_out0_tvalid;
  wire                    m_ep0_out0_tready;
  wire [BLOCK_CHDR_W-1:0] s_ep0_in0_tdata;
  wire                    s_ep0_in0_tlast;
  wire                    s_ep0_in0_tvalid;
  wire                    s_ep0_in0_tready;
  wire [            31:0] m_ep0_ctrl_tdata,  s_ep0_ctrl_tdata;
  wire                    m_ep0_ctrl_tlast,  s_ep0_ctrl_tlast;
  wire                    m_ep0_ctrl_tvalid, s_ep0_ctrl_tvalid;
  wire                    m_ep0_ctrl_tready, s_ep0_ctrl_tready;

  chdr_stream_endpoint #(
    .DEVICE_FAMILY      ("7SERIES"),
    .PROTOVER           (PROTOVER),
    .CHDR_W             (EP0_W),
    .BLOCK_CHDR_W       (BLOCK_CHDR_W),
    .AXIS_CTRL_EN       (1),
    .AXIS_DATA_EN       (1),
    .NUM_DATA_I         (1),
    .NUM_DATA_O         (1),
    .INST_NUM           (0),
    .CTRL_XBAR_PORT     (1),
    .INGRESS_BUFF_SIZE  (INGRESS_BUFF_SIZE_EP0),
    .MTU                (EP0_MTU),
    .REPORT_STRM_ERRS   (1)
  ) ep0_i (
    .rfnoc_chdr_clk     (rfnoc_chdr_clk),
    .rfnoc_chdr_rst     (rfnoc_chdr_rst),
    .rfnoc_ctrl_clk     (rfnoc_ctrl_clk),
    .rfnoc_ctrl_rst     (rfnoc_ctrl_rst),
    .device_id          (device_id),
    .s_axis_chdr_tdata  (xb_to_ep0_tdata),
    .s_axis_chdr_tlast  (xb_to_ep0_tlast),
    .s_axis_chdr_tvalid (xb_to_ep0_tvalid),
    .s_axis_chdr_tready (xb_to_ep0_tready),
    .m_axis_chdr_tdata  (ep0_to_xb_tdata),
    .m_axis_chdr_tlast  (ep0_to_xb_tlast),
    .m_axis_chdr_tvalid (ep0_to_xb_tvalid),
    .m_axis_chdr_tready (ep0_to_xb_tready),
    .s_axis_data_tdata  ({s_ep0_in0_tdata}),
    .s_axis_data_tlast  ({s_ep0_in0_tlast}),
    .s_axis_data_tvalid ({s_ep0_in0_tvalid}),
    .s_axis_data_tready ({s_ep0_in0_tready}),
    .m_axis_data_tdata  ({m_ep0_out0_tdata}),
    .m_axis_data_tlast  ({m_ep0_out0_tlast}),
    .m_axis_data_tvalid ({m_ep0_out0_tvalid}),
    .m_axis_data_tready ({m_ep0_out0_tready}),
    .s_axis_ctrl_tdata  (s_ep0_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_ep0_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_ep0_ctrl_tvalid),
    .s_axis_ctrl_tready (s_ep0_ctrl_tready),
    .m_axis_ctrl_tdata  (m_ep0_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_ep0_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_ep0_ctrl_tvalid),
    .m_axis_ctrl_tready (m_ep0_ctrl_tready),
    .strm_seq_err_stb   (),
    .strm_data_err_stb  (),
    .strm_route_err_stb (),
    .signal_data_err    (1'b0)
  );

  // If requested buffer size is 0, use the minimum SRL-based FIFO size.
  // Otherwise, make sure it's at least two MTU-sized packets.
  localparam REQ_BUFF_SIZE_EP1 = 32768;
  localparam INGRESS_BUFF_SIZE_EP1 =
    REQ_BUFF_SIZE_EP1 == 0             ? 5         :
    REQ_BUFF_SIZE_EP1 < 2*(2**EP1_MTU) ? EP1_MTU+1 :
                                         $clog2(REQ_BUFF_SIZE_EP1);

  wire [BLOCK_CHDR_W-1:0] m_ep1_out0_tdata;
  wire                    m_ep1_out0_tlast;
  wire                    m_ep1_out0_tvalid;
  wire                    m_ep1_out0_tready;
  wire [BLOCK_CHDR_W-1:0] s_ep1_in0_tdata;
  wire                    s_ep1_in0_tlast;
  wire                    s_ep1_in0_tvalid;
  wire                    s_ep1_in0_tready;
  wire [            31:0] m_ep1_ctrl_tdata,  s_ep1_ctrl_tdata;
  wire                    m_ep1_ctrl_tlast,  s_ep1_ctrl_tlast;
  wire                    m_ep1_ctrl_tvalid, s_ep1_ctrl_tvalid;
  wire                    m_ep1_ctrl_tready, s_ep1_ctrl_tready;

  chdr_stream_endpoint #(
    .DEVICE_FAMILY      ("7SERIES"),
    .PROTOVER           (PROTOVER),
    .CHDR_W             (EP1_W),
    .BLOCK_CHDR_W       (BLOCK_CHDR_W),
    .AXIS_CTRL_EN       (0),
    .AXIS_DATA_EN       (1),
    .NUM_DATA_I         (1),
    .NUM_DATA_O         (1),
    .INST_NUM           (1),
    .CTRL_XBAR_PORT     (2),
    .INGRESS_BUFF_SIZE  (INGRESS_BUFF_SIZE_EP1),
    .MTU                (EP1_MTU),
    .REPORT_STRM_ERRS   (1)
  ) ep1_i (
    .rfnoc_chdr_clk     (rfnoc_chdr_clk),
    .rfnoc_chdr_rst     (rfnoc_chdr_rst),
    .rfnoc_ctrl_clk     (rfnoc_ctrl_clk),
    .rfnoc_ctrl_rst     (rfnoc_ctrl_rst),
    .device_id          (device_id),
    .s_axis_chdr_tdata  (xb_to_ep1_tdata),
    .s_axis_chdr_tlast  (xb_to_ep1_tlast),
    .s_axis_chdr_tvalid (xb_to_ep1_tvalid),
    .s_axis_chdr_tready (xb_to_ep1_tready),
    .m_axis_chdr_tdata  (ep1_to_xb_tdata),
    .m_axis_chdr_tlast  (ep1_to_xb_tlast),
    .m_axis_chdr_tvalid (ep1_to_xb_tvalid),
    .m_axis_chdr_tready (ep1_to_xb_tready),
    .s_axis_data_tdata  ({s_ep1_in0_tdata}),
    .s_axis_data_tlast  ({s_ep1_in0_tlast}),
    .s_axis_data_tvalid ({s_ep1_in0_tvalid}),
    .s_axis_data_tready ({s_ep1_in0_tready}),
    .m_axis_data_tdata  ({m_ep1_out0_tdata}),
    .m_axis_data_tlast  ({m_ep1_out0_tlast}),
    .m_axis_data_tvalid ({m_ep1_out0_tvalid}),
    .m_axis_data_tready ({m_ep1_out0_tready}),
    .s_axis_ctrl_tdata  (s_ep1_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_ep1_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_ep1_ctrl_tvalid),
    .s_axis_ctrl_tready (s_ep1_ctrl_tready),
    .m_axis_ctrl_tdata  (m_ep1_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_ep1_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_ep1_ctrl_tvalid),
    .m_axis_ctrl_tready (m_ep1_ctrl_tready),
    .strm_seq_err_stb   (),
    .strm_data_err_stb  (),
    .strm_route_err_stb (),
    .signal_data_err    (1'b0)
  );

  // If requested buffer size is 0, use the minimum SRL-based FIFO size.
  // Otherwise, make sure it's at least two MTU-sized packets.
  localparam REQ_BUFF_SIZE_EP2 = 8192;
  localparam INGRESS_BUFF_SIZE_EP2 =
    REQ_BUFF_SIZE_EP2 == 0             ? 5         :
    REQ_BUFF_SIZE_EP2 < 2*(2**EP2_MTU) ? EP2_MTU+1 :
                                         $clog2(REQ_BUFF_SIZE_EP2);

  wire [BLOCK_CHDR_W-1:0] m_ep2_out0_tdata;
  wire                    m_ep2_out0_tlast;
  wire                    m_ep2_out0_tvalid;
  wire                    m_ep2_out0_tready;
  wire [BLOCK_CHDR_W-1:0] s_ep2_in0_tdata;
  wire                    s_ep2_in0_tlast;
  wire                    s_ep2_in0_tvalid;
  wire                    s_ep2_in0_tready;
  wire [            31:0] m_ep2_ctrl_tdata,  s_ep2_ctrl_tdata;
  wire                    m_ep2_ctrl_tlast,  s_ep2_ctrl_tlast;
  wire                    m_ep2_ctrl_tvalid, s_ep2_ctrl_tvalid;
  wire                    m_ep2_ctrl_tready, s_ep2_ctrl_tready;

  chdr_stream_endpoint #(
    .DEVICE_FAMILY      ("7SERIES"),
    .PROTOVER           (PROTOVER),
    .CHDR_W             (EP2_W),
    .BLOCK_CHDR_W       (BLOCK_CHDR_W),
    .AXIS_CTRL_EN       (0),
    .AXIS_DATA_EN       (1),
    .NUM_DATA_I         (1),
    .NUM_DATA_O         (1),
    .INST_NUM           (2),
    .CTRL_XBAR_PORT     (3),
    .INGRESS_BUFF_SIZE  (INGRESS_BUFF_SIZE_EP2),
    .MTU                (EP2_MTU),
    .REPORT_STRM_ERRS   (1)
  ) ep2_i (
    .rfnoc_chdr_clk     (rfnoc_chdr_clk),
    .rfnoc_chdr_rst     (rfnoc_chdr_rst),
    .rfnoc_ctrl_clk     (rfnoc_ctrl_clk),
    .rfnoc_ctrl_rst     (rfnoc_ctrl_rst),
    .device_id          (device_id),
    .s_axis_chdr_tdata  (xb_to_ep2_tdata),
    .s_axis_chdr_tlast  (xb_to_ep2_tlast),
    .s_axis_chdr_tvalid (xb_to_ep2_tvalid),
    .s_axis_chdr_tready (xb_to_ep2_tready),
    .m_axis_chdr_tdata  (ep2_to_xb_tdata),
    .m_axis_chdr_tlast  (ep2_to_xb_tlast),
    .m_axis_chdr_tvalid (ep2_to_xb_tvalid),
    .m_axis_chdr_tready (ep2_to_xb_tready),
    .s_axis_data_tdata  ({s_ep2_in0_tdata}),
    .s_axis_data_tlast  ({s_ep2_in0_tlast}),
    .s_axis_data_tvalid ({s_ep2_in0_tvalid}),
    .s_axis_data_tready ({s_ep2_in0_tready}),
    .m_axis_data_tdata  ({m_ep2_out0_tdata}),
    .m_axis_data_tlast  ({m_ep2_out0_tlast}),
    .m_axis_data_tvalid ({m_ep2_out0_tvalid}),
    .m_axis_data_tready ({m_ep2_out0_tready}),
    .s_axis_ctrl_tdata  (s_ep2_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_ep2_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_ep2_ctrl_tvalid),
    .s_axis_ctrl_tready (s_ep2_ctrl_tready),
    .m_axis_ctrl_tdata  (m_ep2_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_ep2_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_ep2_ctrl_tvalid),
    .m_axis_ctrl_tready (m_ep2_ctrl_tready),
    .strm_seq_err_stb   (),
    .strm_data_err_stb  (),
    .strm_route_err_stb (),
    .signal_data_err    (1'b0)
  );

  // If requested buffer size is 0, use the minimum SRL-based FIFO size.
  // Otherwise, make sure it's at least two MTU-sized packets.
  localparam REQ_BUFF_SIZE_EP3 = 8192;
  localparam INGRESS_BUFF_SIZE_EP3 =
    REQ_BUFF_SIZE_EP3 == 0             ? 5         :
    REQ_BUFF_SIZE_EP3 < 2*(2**EP3_MTU) ? EP3_MTU+1 :
                                         $clog2(REQ_BUFF_SIZE_EP3);

  wire [BLOCK_CHDR_W-1:0] m_ep3_out0_tdata;
  wire                    m_ep3_out0_tlast;
  wire                    m_ep3_out0_tvalid;
  wire                    m_ep3_out0_tready;
  wire [BLOCK_CHDR_W-1:0] s_ep3_in0_tdata;
  wire                    s_ep3_in0_tlast;
  wire                    s_ep3_in0_tvalid;
  wire                    s_ep3_in0_tready;
  wire [            31:0] m_ep3_ctrl_tdata,  s_ep3_ctrl_tdata;
  wire                    m_ep3_ctrl_tlast,  s_ep3_ctrl_tlast;
  wire                    m_ep3_ctrl_tvalid, s_ep3_ctrl_tvalid;
  wire                    m_ep3_ctrl_tready, s_ep3_ctrl_tready;

  chdr_stream_endpoint #(
    .DEVICE_FAMILY      ("7SERIES"),
    .PROTOVER           (PROTOVER),
    .CHDR_W             (EP3_W),
    .BLOCK_CHDR_W       (BLOCK_CHDR_W),
    .AXIS_CTRL_EN       (0),
    .AXIS_DATA_EN       (1),
    .NUM_DATA_I         (1),
    .NUM_DATA_O         (1),
    .INST_NUM           (3),
    .CTRL_XBAR_PORT     (4),
    .INGRESS_BUFF_SIZE  (INGRESS_BUFF_SIZE_EP3),
    .MTU                (EP3_MTU),
    .REPORT_STRM_ERRS   (1)
  ) ep3_i (
    .rfnoc_chdr_clk     (rfnoc_chdr_clk),
    .rfnoc_chdr_rst     (rfnoc_chdr_rst),
    .rfnoc_ctrl_clk     (rfnoc_ctrl_clk),
    .rfnoc_ctrl_rst     (rfnoc_ctrl_rst),
    .device_id          (device_id),
    .s_axis_chdr_tdata  (xb_to_ep3_tdata),
    .s_axis_chdr_tlast  (xb_to_ep3_tlast),
    .s_axis_chdr_tvalid (xb_to_ep3_tvalid),
    .s_axis_chdr_tready (xb_to_ep3_tready),
    .m_axis_chdr_tdata  (ep3_to_xb_tdata),
    .m_axis_chdr_tlast  (ep3_to_xb_tlast),
    .m_axis_chdr_tvalid (ep3_to_xb_tvalid),
    .m_axis_chdr_tready (ep3_to_xb_tready),
    .s_axis_data_tdata  ({s_ep3_in0_tdata}),
    .s_axis_data_tlast  ({s_ep3_in0_tlast}),
    .s_axis_data_tvalid ({s_ep3_in0_tvalid}),
    .s_axis_data_tready ({s_ep3_in0_tready}),
    .m_axis_data_tdata  ({m_ep3_out0_tdata}),
    .m_axis_data_tlast  ({m_ep3_out0_tlast}),
    .m_axis_data_tvalid ({m_ep3_out0_tvalid}),
    .m_axis_data_tready ({m_ep3_out0_tready}),
    .s_axis_ctrl_tdata  (s_ep3_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_ep3_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_ep3_ctrl_tvalid),
    .s_axis_ctrl_tready (s_ep3_ctrl_tready),
    .m_axis_ctrl_tdata  (m_ep3_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_ep3_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_ep3_ctrl_tvalid),
    .m_axis_ctrl_tready (m_ep3_ctrl_tready),
    .strm_seq_err_stb   (),
    .strm_data_err_stb  (),
    .strm_route_err_stb (),
    .signal_data_err    (1'b0)
  );


  //---------------------------------------------------------------------------
  // Control Crossbar
  //---------------------------------------------------------------------------

  wire [31:0] m_core_ctrl_tdata,  s_core_ctrl_tdata;
  wire        m_core_ctrl_tlast,  s_core_ctrl_tlast;
  wire        m_core_ctrl_tvalid, s_core_ctrl_tvalid;
  wire        m_core_ctrl_tready, s_core_ctrl_tready;
  wire [31:0] m_duc0_ctrl_tdata,  s_duc0_ctrl_tdata;
  wire        m_duc0_ctrl_tlast,  s_duc0_ctrl_tlast;
  wire        m_duc0_ctrl_tvalid, s_duc0_ctrl_tvalid;
  wire        m_duc0_ctrl_tready, s_duc0_ctrl_tready;
  wire [31:0] m_ddc0_ctrl_tdata,  s_ddc0_ctrl_tdata;
  wire        m_ddc0_ctrl_tlast,  s_ddc0_ctrl_tlast;
  wire        m_ddc0_ctrl_tvalid, s_ddc0_ctrl_tvalid;
  wire        m_ddc0_ctrl_tready, s_ddc0_ctrl_tready;
  wire [31:0] m_radio0_ctrl_tdata,  s_radio0_ctrl_tdata;
  wire        m_radio0_ctrl_tlast,  s_radio0_ctrl_tlast;
  wire        m_radio0_ctrl_tvalid, s_radio0_ctrl_tvalid;
  wire        m_radio0_ctrl_tready, s_radio0_ctrl_tready;
  wire [31:0] m_fifo0_ctrl_tdata,  s_fifo0_ctrl_tdata;
  wire        m_fifo0_ctrl_tlast,  s_fifo0_ctrl_tlast;
  wire        m_fifo0_ctrl_tvalid, s_fifo0_ctrl_tvalid;
  wire        m_fifo0_ctrl_tready, s_fifo0_ctrl_tready;

  axis_ctrl_crossbar_nxn #(
    .WIDTH            (32),
    .NPORTS           (6),
    .TOPOLOGY         ("TORUS"),
    .INGRESS_BUFF_SIZE(5),
    .ROUTER_BUFF_SIZE (5),
    .ROUTING_ALLOC    ("WORMHOLE"),
    .SWITCH_ALLOC     ("PRIO")
  ) ctrl_xb_i (
    .clk              (rfnoc_ctrl_clk),
    .reset            (rfnoc_ctrl_rst),
    .s_axis_tdata     ({m_fifo0_ctrl_tdata , m_radio0_ctrl_tdata , m_ddc0_ctrl_tdata , m_duc0_ctrl_tdata , m_ep0_ctrl_tdata , m_core_ctrl_tdata }),
    .s_axis_tvalid    ({m_fifo0_ctrl_tvalid, m_radio0_ctrl_tvalid, m_ddc0_ctrl_tvalid, m_duc0_ctrl_tvalid, m_ep0_ctrl_tvalid, m_core_ctrl_tvalid}),
    .s_axis_tlast     ({m_fifo0_ctrl_tlast , m_radio0_ctrl_tlast , m_ddc0_ctrl_tlast , m_duc0_ctrl_tlast , m_ep0_ctrl_tlast , m_core_ctrl_tlast }),
    .s_axis_tready    ({m_fifo0_ctrl_tready, m_radio0_ctrl_tready, m_ddc0_ctrl_tready, m_duc0_ctrl_tready, m_ep0_ctrl_tready, m_core_ctrl_tready}),
    .m_axis_tdata     ({s_fifo0_ctrl_tdata , s_radio0_ctrl_tdata , s_ddc0_ctrl_tdata , s_duc0_ctrl_tdata , s_ep0_ctrl_tdata , s_core_ctrl_tdata }),
    .m_axis_tvalid    ({s_fifo0_ctrl_tvalid, s_radio0_ctrl_tvalid, s_ddc0_ctrl_tvalid, s_duc0_ctrl_tvalid, s_ep0_ctrl_tvalid, s_core_ctrl_tvalid}),
    .m_axis_tlast     ({s_fifo0_ctrl_tlast , s_radio0_ctrl_tlast , s_ddc0_ctrl_tlast , s_duc0_ctrl_tlast , s_ep0_ctrl_tlast , s_core_ctrl_tlast }),
    .m_axis_tready    ({s_fifo0_ctrl_tready, s_radio0_ctrl_tready, s_ddc0_ctrl_tready, s_duc0_ctrl_tready, s_ep0_ctrl_tready, s_core_ctrl_tready}),
    .deadlock_detected()
  );


  //---------------------------------------------------------------------------
  // RFNoC Core Kernel
  //---------------------------------------------------------------------------

  wire [(512*4)-1:0] rfnoc_core_config, rfnoc_core_status;

  rfnoc_core_kernel #(
    .PROTOVER            (PROTOVER),
    .DEVICE_TYPE         (16'hE320),
    .DEVICE_FAMILY       ("7SERIES"),
    .SAFE_START_CLKS     (0),
    .NUM_BLOCKS          (4),
    .NUM_STREAM_ENDPOINTS(4),
    .NUM_ENDPOINTS_CTRL  (1),
    .NUM_TRANSPORTS      (2),
    .NUM_EDGES           (12),
    .CHDR_XBAR_PRESENT   (1),
    .EDGE_TBL_FILE       (EDGE_TBL_FILE)
  ) core_kernel_i (
    .chdr_aclk          (chdr_aclk),
    .chdr_aclk_locked   (1'b1),
    .ctrl_aclk          (ctrl_aclk),
    .ctrl_aclk_locked   (1'b1),
    .core_arst          (core_arst),
    .core_chdr_clk      (rfnoc_chdr_clk),
    .core_chdr_rst      (rfnoc_chdr_rst),
    .core_ctrl_clk      (rfnoc_ctrl_clk),
    .core_ctrl_rst      (rfnoc_ctrl_rst),
    .s_axis_ctrl_tdata  (s_core_ctrl_tdata),
    .s_axis_ctrl_tlast  (s_core_ctrl_tlast),
    .s_axis_ctrl_tvalid (s_core_ctrl_tvalid),
    .s_axis_ctrl_tready (s_core_ctrl_tready),
    .m_axis_ctrl_tdata  (m_core_ctrl_tdata),
    .m_axis_ctrl_tlast  (m_core_ctrl_tlast),
    .m_axis_ctrl_tvalid (m_core_ctrl_tvalid),
    .m_axis_ctrl_tready (m_core_ctrl_tready),
    .device_id          (device_id),
    .rfnoc_core_config  (rfnoc_core_config),
    .rfnoc_core_status  (rfnoc_core_status)
  );


  //---------------------------------------------------------------------------
  // Blocks
  //---------------------------------------------------------------------------

  //-----------------------------------
  // duc0
  //-----------------------------------

  wire                    duc0_ce_clk;
  wire [BLOCK_CHDR_W-1:0] s_duc0_in_1_tdata , s_duc0_in_0_tdata ;
  wire                    s_duc0_in_1_tlast , s_duc0_in_0_tlast ;
  wire                    s_duc0_in_1_tvalid, s_duc0_in_0_tvalid;
  wire                    s_duc0_in_1_tready, s_duc0_in_0_tready;
  wire [BLOCK_CHDR_W-1:0] m_duc0_out_1_tdata , m_duc0_out_0_tdata ;
  wire                    m_duc0_out_1_tlast , m_duc0_out_0_tlast ;
  wire                    m_duc0_out_1_tvalid, m_duc0_out_0_tvalid;
  wire                    m_duc0_out_1_tready, m_duc0_out_0_tready;

  rfnoc_block_duc #(
    .THIS_PORTID         (2),
    .CHDR_W              (BLOCK_CHDR_W),
    .NUM_PORTS           (2),
    .NUM_HB              (3),
    .CIC_MAX_INTERP      (255),
    .MTU                 (BLOCK_MTU)
  ) b_duc0_0 (
    .rfnoc_chdr_clk      (rfnoc_chdr_clk),
    .rfnoc_ctrl_clk      (rfnoc_ctrl_clk),
    .ce_clk              (duc0_ce_clk),
    .rfnoc_core_config   (rfnoc_core_config[512*1-1:512*0]),
    .rfnoc_core_status   (rfnoc_core_status[512*1-1:512*0]),
    .s_rfnoc_chdr_tdata  ({s_duc0_in_1_tdata , s_duc0_in_0_tdata }),
    .s_rfnoc_chdr_tlast  ({s_duc0_in_1_tlast , s_duc0_in_0_tlast }),
    .s_rfnoc_chdr_tvalid ({s_duc0_in_1_tvalid, s_duc0_in_0_tvalid}),
    .s_rfnoc_chdr_tready ({s_duc0_in_1_tready, s_duc0_in_0_tready}),
    .m_rfnoc_chdr_tdata  ({m_duc0_out_1_tdata , m_duc0_out_0_tdata }),
    .m_rfnoc_chdr_tlast  ({m_duc0_out_1_tlast , m_duc0_out_0_tlast }),
    .m_rfnoc_chdr_tvalid ({m_duc0_out_1_tvalid, m_duc0_out_0_tvalid}),
    .m_rfnoc_chdr_tready ({m_duc0_out_1_tready, m_duc0_out_0_tready}),
    .s_rfnoc_ctrl_tdata  (s_duc0_ctrl_tdata),
    .s_rfnoc_ctrl_tlast  (s_duc0_ctrl_tlast),
    .s_rfnoc_ctrl_tvalid (s_duc0_ctrl_tvalid),
    .s_rfnoc_ctrl_tready (s_duc0_ctrl_tready),
    .m_rfnoc_ctrl_tdata  (m_duc0_ctrl_tdata),
    .m_rfnoc_ctrl_tlast  (m_duc0_ctrl_tlast),
    .m_rfnoc_ctrl_tvalid (m_duc0_ctrl_tvalid),
    .m_rfnoc_ctrl_tready (m_duc0_ctrl_tready)
  );

  //-----------------------------------
  // ddc0
  //-----------------------------------

  wire                    ddc0_ce_clk;
  wire [BLOCK_CHDR_W-1:0] s_ddc0_in_1_tdata , s_ddc0_in_0_tdata ;
  wire                    s_ddc0_in_1_tlast , s_ddc0_in_0_tlast ;
  wire                    s_ddc0_in_1_tvalid, s_ddc0_in_0_tvalid;
  wire                    s_ddc0_in_1_tready, s_ddc0_in_0_tready;
  wire [BLOCK_CHDR_W-1:0] m_ddc0_out_1_tdata , m_ddc0_out_0_tdata ;
  wire                    m_ddc0_out_1_tlast , m_ddc0_out_0_tlast ;
  wire                    m_ddc0_out_1_tvalid, m_ddc0_out_0_tvalid;
  wire                    m_ddc0_out_1_tready, m_ddc0_out_0_tready;

  rfnoc_block_ddc #(
    .THIS_PORTID         (3),
    .CHDR_W              (BLOCK_CHDR_W),
    .NUM_PORTS           (2),
    .NUM_HB              (3),
    .CIC_MAX_DECIM       (255),
    .MTU                 (BLOCK_MTU)
  ) b_ddc0_1 (
    .rfnoc_chdr_clk      (rfnoc_chdr_clk),
    .rfnoc_ctrl_clk      (rfnoc_ctrl_clk),
    .ce_clk              (ddc0_ce_clk),
    .rfnoc_core_config   (rfnoc_core_config[512*2-1:512*1]),
    .rfnoc_core_status   (rfnoc_core_status[512*2-1:512*1]),
    .s_rfnoc_chdr_tdata  ({s_ddc0_in_1_tdata , s_ddc0_in_0_tdata }),
    .s_rfnoc_chdr_tlast  ({s_ddc0_in_1_tlast , s_ddc0_in_0_tlast }),
    .s_rfnoc_chdr_tvalid ({s_ddc0_in_1_tvalid, s_ddc0_in_0_tvalid}),
    .s_rfnoc_chdr_tready ({s_ddc0_in_1_tready, s_ddc0_in_0_tready}),
    .m_rfnoc_chdr_tdata  ({m_ddc0_out_1_tdata , m_ddc0_out_0_tdata }),
    .m_rfnoc_chdr_tlast  ({m_ddc0_out_1_tlast , m_ddc0_out_0_tlast }),
    .m_rfnoc_chdr_tvalid ({m_ddc0_out_1_tvalid, m_ddc0_out_0_tvalid}),
    .m_rfnoc_chdr_tready ({m_ddc0_out_1_tready, m_ddc0_out_0_tready}),
    .s_rfnoc_ctrl_tdata  (s_ddc0_ctrl_tdata),
    .s_rfnoc_ctrl_tlast  (s_ddc0_ctrl_tlast),
    .s_rfnoc_ctrl_tvalid (s_ddc0_ctrl_tvalid),
    .s_rfnoc_ctrl_tready (s_ddc0_ctrl_tready),
    .m_rfnoc_ctrl_tdata  (m_ddc0_ctrl_tdata),
    .m_rfnoc_ctrl_tlast  (m_ddc0_ctrl_tlast),
    .m_rfnoc_ctrl_tvalid (m_ddc0_ctrl_tvalid),
    .m_rfnoc_ctrl_tready (m_ddc0_ctrl_tready)
  );

  //-----------------------------------
  // radio0
  //-----------------------------------

  wire                    radio0_radio_clk;
  wire [BLOCK_CHDR_W-1:0] s_radio0_in_1_tdata , s_radio0_in_0_tdata ;
  wire                    s_radio0_in_1_tlast , s_radio0_in_0_tlast ;
  wire                    s_radio0_in_1_tvalid, s_radio0_in_0_tvalid;
  wire                    s_radio0_in_1_tready, s_radio0_in_0_tready;
  wire [BLOCK_CHDR_W-1:0] m_radio0_out_1_tdata , m_radio0_out_0_tdata ;
  wire                    m_radio0_out_1_tlast , m_radio0_out_0_tlast ;
  wire                    m_radio0_out_1_tvalid, m_radio0_out_0_tvalid;
  wire                    m_radio0_out_1_tready, m_radio0_out_0_tready;

  // ctrlport
  wire [   0:0] radio0_m_ctrlport_req_wr;
  wire [   0:0] radio0_m_ctrlport_req_rd;
  wire [  19:0] radio0_m_ctrlport_req_addr;
  wire [  31:0] radio0_m_ctrlport_req_data;
  wire [   3:0] radio0_m_ctrlport_req_byte_en;
  wire [   0:0] radio0_m_ctrlport_req_has_time;
  wire [  63:0] radio0_m_ctrlport_req_time;
  wire [   0:0] radio0_m_ctrlport_resp_ack;
  wire [   1:0] radio0_m_ctrlport_resp_status;
  wire [  31:0] radio0_m_ctrlport_resp_data;
  // time
  wire [  63:0] radio0_radio_time;
  // radio
  wire [ 255:0] radio0_radio_rx_data;
  wire [   7:0] radio0_radio_rx_stb;
  wire [   7:0] radio0_radio_rx_running;
  wire [ 255:0] radio0_radio_tx_data;
  wire [   7:0] radio0_radio_tx_stb;
  wire [   7:0] radio0_radio_tx_running;

  rfnoc_block_radio #(
    .THIS_PORTID         (4),
    .CHDR_W              (BLOCK_CHDR_W),
    .NUM_PORTS           (2),
    .NIPC                (1),
    .ITEM_W              (32),
    .MTU                 (BLOCK_MTU)
  ) b_radio0_2 (
    .rfnoc_chdr_clk      (rfnoc_chdr_clk),
    .rfnoc_ctrl_clk      (rfnoc_ctrl_clk),
    .radio_clk           (radio0_radio_clk),
    .rfnoc_core_config   (rfnoc_core_config[512*3-1:512*2]),
    .rfnoc_core_status   (rfnoc_core_status[512*3-1:512*2]),
    .m_ctrlport_req_wr   (radio0_m_ctrlport_req_wr),
    .m_ctrlport_req_rd   (radio0_m_ctrlport_req_rd),
    .m_ctrlport_req_addr (radio0_m_ctrlport_req_addr),
    .m_ctrlport_req_data (radio0_m_ctrlport_req_data),
    .m_ctrlport_req_byte_en(radio0_m_ctrlport_req_byte_en),
    .m_ctrlport_req_has_time(radio0_m_ctrlport_req_has_time),
    .m_ctrlport_req_time (radio0_m_ctrlport_req_time),
    .m_ctrlport_resp_ack (radio0_m_ctrlport_resp_ack),
    .m_ctrlport_resp_status(radio0_m_ctrlport_resp_status),
    .m_ctrlport_resp_data(radio0_m_ctrlport_resp_data),
    .radio_time          (radio0_radio_time),
    .radio_rx_data       (radio0_radio_rx_data),
    .radio_rx_stb        (radio0_radio_rx_stb),
    .radio_rx_running    (radio0_radio_rx_running),
    .radio_tx_data       (radio0_radio_tx_data),
    .radio_tx_stb        (radio0_radio_tx_stb),
    .radio_tx_running    (radio0_radio_tx_running),
    .s_rfnoc_chdr_tdata  ({s_radio0_in_1_tdata , s_radio0_in_0_tdata }),
    .s_rfnoc_chdr_tlast  ({s_radio0_in_1_tlast , s_radio0_in_0_tlast }),
    .s_rfnoc_chdr_tvalid ({s_radio0_in_1_tvalid, s_radio0_in_0_tvalid}),
    .s_rfnoc_chdr_tready ({s_radio0_in_1_tready, s_radio0_in_0_tready}),
    .m_rfnoc_chdr_tdata  ({m_radio0_out_1_tdata , m_radio0_out_0_tdata }),
    .m_rfnoc_chdr_tlast  ({m_radio0_out_1_tlast , m_radio0_out_0_tlast }),
    .m_rfnoc_chdr_tvalid ({m_radio0_out_1_tvalid, m_radio0_out_0_tvalid}),
    .m_rfnoc_chdr_tready ({m_radio0_out_1_tready, m_radio0_out_0_tready}),
    .s_rfnoc_ctrl_tdata  (s_radio0_ctrl_tdata),
    .s_rfnoc_ctrl_tlast  (s_radio0_ctrl_tlast),
    .s_rfnoc_ctrl_tvalid (s_radio0_ctrl_tvalid),
    .s_rfnoc_ctrl_tready (s_radio0_ctrl_tready),
    .m_rfnoc_ctrl_tdata  (m_radio0_ctrl_tdata),
    .m_rfnoc_ctrl_tlast  (m_radio0_ctrl_tlast),
    .m_rfnoc_ctrl_tvalid (m_radio0_ctrl_tvalid),
    .m_rfnoc_ctrl_tready (m_radio0_ctrl_tready)
  );

  //-----------------------------------
  // fifo0
  //-----------------------------------

  wire                    fifo0_mem_clk;
  wire [BLOCK_CHDR_W-1:0] s_fifo0_in_1_tdata , s_fifo0_in_0_tdata ;
  wire                    s_fifo0_in_1_tlast , s_fifo0_in_0_tlast ;
  wire                    s_fifo0_in_1_tvalid, s_fifo0_in_0_tvalid;
  wire                    s_fifo0_in_1_tready, s_fifo0_in_0_tready;
  wire [BLOCK_CHDR_W-1:0] m_fifo0_out_1_tdata , m_fifo0_out_0_tdata ;
  wire                    m_fifo0_out_1_tlast , m_fifo0_out_0_tlast ;
  wire                    m_fifo0_out_1_tvalid, m_fifo0_out_0_tvalid;
  wire                    m_fifo0_out_1_tready, m_fifo0_out_0_tready;

  // axi_ram
  wire [   0:0] fifo0_axi_rst;
  wire [   3:0] fifo0_m_axi_awid;
  wire [ 191:0] fifo0_m_axi_awaddr;
  wire [  31:0] fifo0_m_axi_awlen;
  wire [  11:0] fifo0_m_axi_awsize;
  wire [   7:0] fifo0_m_axi_awburst;
  wire [   3:0] fifo0_m_axi_awlock;
  wire [  15:0] fifo0_m_axi_awcache;
  wire [  11:0] fifo0_m_axi_awprot;
  wire [  15:0] fifo0_m_axi_awqos;
  wire [  15:0] fifo0_m_axi_awregion;
  wire [   3:0] fifo0_m_axi_awuser;
  wire [   3:0] fifo0_m_axi_awvalid;
  wire [   3:0] fifo0_m_axi_awready;
  wire [2047:0] fifo0_m_axi_wdata;
  wire [ 255:0] fifo0_m_axi_wstrb;
  wire [   3:0] fifo0_m_axi_wlast;
  wire [   3:0] fifo0_m_axi_wuser;
  wire [   3:0] fifo0_m_axi_wvalid;
  wire [   3:0] fifo0_m_axi_wready;
  wire [   3:0] fifo0_m_axi_bid;
  wire [   7:0] fifo0_m_axi_bresp;
  wire [   3:0] fifo0_m_axi_buser;
  wire [   3:0] fifo0_m_axi_bvalid;
  wire [   3:0] fifo0_m_axi_bready;
  wire [   3:0] fifo0_m_axi_arid;
  wire [ 191:0] fifo0_m_axi_araddr;
  wire [  31:0] fifo0_m_axi_arlen;
  wire [  11:0] fifo0_m_axi_arsize;
  wire [   7:0] fifo0_m_axi_arburst;
  wire [   3:0] fifo0_m_axi_arlock;
  wire [  15:0] fifo0_m_axi_arcache;
  wire [  11:0] fifo0_m_axi_arprot;
  wire [  15:0] fifo0_m_axi_arqos;
  wire [  15:0] fifo0_m_axi_arregion;
  wire [   3:0] fifo0_m_axi_aruser;
  wire [   3:0] fifo0_m_axi_arvalid;
  wire [   3:0] fifo0_m_axi_arready;
  wire [   3:0] fifo0_m_axi_rid;
  wire [2047:0] fifo0_m_axi_rdata;
  wire [   7:0] fifo0_m_axi_rresp;
  wire [   3:0] fifo0_m_axi_rlast;
  wire [   3:0] fifo0_m_axi_ruser;
  wire [   3:0] fifo0_m_axi_rvalid;
  wire [   3:0] fifo0_m_axi_rready;

  rfnoc_block_axi_ram_fifo #(
    .THIS_PORTID         (5),
    .CHDR_W              (BLOCK_CHDR_W),
    .NUM_PORTS           (2),
    .MEM_ADDR_W          (31),
    .MEM_DATA_W          (64),
    .MEM_CLK_RATE        (300e6),
    .FIFO_ADDR_BASE      ({31'h02000000, 31'h00000000}),
    .FIFO_ADDR_MASK      ({31'h01FFFFFF, 31'h01FFFFFF}),
    .IN_FIFO_SIZE        (),
    .OUT_FIFO_SIZE       (),
    .MTU                 (BLOCK_MTU)
  ) b_fifo0_3 (
    .rfnoc_chdr_clk      (rfnoc_chdr_clk),
    .rfnoc_ctrl_clk      (rfnoc_ctrl_clk),
    .mem_clk             (fifo0_mem_clk),
    .rfnoc_core_config   (rfnoc_core_config[512*4-1:512*3]),
    .rfnoc_core_status   (rfnoc_core_status[512*4-1:512*3]),
    .axi_rst             (fifo0_axi_rst),
    .m_axi_awid          (fifo0_m_axi_awid),
    .m_axi_awaddr        (fifo0_m_axi_awaddr),
    .m_axi_awlen         (fifo0_m_axi_awlen),
    .m_axi_awsize        (fifo0_m_axi_awsize),
    .m_axi_awburst       (fifo0_m_axi_awburst),
    .m_axi_awlock        (fifo0_m_axi_awlock),
    .m_axi_awcache       (fifo0_m_axi_awcache),
    .m_axi_awprot        (fifo0_m_axi_awprot),
    .m_axi_awqos         (fifo0_m_axi_awqos),
    .m_axi_awregion      (fifo0_m_axi_awregion),
    .m_axi_awuser        (fifo0_m_axi_awuser),
    .m_axi_awvalid       (fifo0_m_axi_awvalid),
    .m_axi_awready       (fifo0_m_axi_awready),
    .m_axi_wdata         (fifo0_m_axi_wdata),
    .m_axi_wstrb         (fifo0_m_axi_wstrb),
    .m_axi_wlast         (fifo0_m_axi_wlast),
    .m_axi_wuser         (fifo0_m_axi_wuser),
    .m_axi_wvalid        (fifo0_m_axi_wvalid),
    .m_axi_wready        (fifo0_m_axi_wready),
    .m_axi_bid           (fifo0_m_axi_bid),
    .m_axi_bresp         (fifo0_m_axi_bresp),
    .m_axi_buser         (fifo0_m_axi_buser),
    .m_axi_bvalid        (fifo0_m_axi_bvalid),
    .m_axi_bready        (fifo0_m_axi_bready),
    .m_axi_arid          (fifo0_m_axi_arid),
    .m_axi_araddr        (fifo0_m_axi_araddr),
    .m_axi_arlen         (fifo0_m_axi_arlen),
    .m_axi_arsize        (fifo0_m_axi_arsize),
    .m_axi_arburst       (fifo0_m_axi_arburst),
    .m_axi_arlock        (fifo0_m_axi_arlock),
    .m_axi_arcache       (fifo0_m_axi_arcache),
    .m_axi_arprot        (fifo0_m_axi_arprot),
    .m_axi_arqos         (fifo0_m_axi_arqos),
    .m_axi_arregion      (fifo0_m_axi_arregion),
    .m_axi_aruser        (fifo0_m_axi_aruser),
    .m_axi_arvalid       (fifo0_m_axi_arvalid),
    .m_axi_arready       (fifo0_m_axi_arready),
    .m_axi_rid           (fifo0_m_axi_rid),
    .m_axi_rdata         (fifo0_m_axi_rdata),
    .m_axi_rresp         (fifo0_m_axi_rresp),
    .m_axi_rlast         (fifo0_m_axi_rlast),
    .m_axi_ruser         (fifo0_m_axi_ruser),
    .m_axi_rvalid        (fifo0_m_axi_rvalid),
    .m_axi_rready        (fifo0_m_axi_rready),
    .s_rfnoc_chdr_tdata  ({s_fifo0_in_1_tdata , s_fifo0_in_0_tdata }),
    .s_rfnoc_chdr_tlast  ({s_fifo0_in_1_tlast , s_fifo0_in_0_tlast }),
    .s_rfnoc_chdr_tvalid ({s_fifo0_in_1_tvalid, s_fifo0_in_0_tvalid}),
    .s_rfnoc_chdr_tready ({s_fifo0_in_1_tready, s_fifo0_in_0_tready}),
    .m_rfnoc_chdr_tdata  ({m_fifo0_out_1_tdata , m_fifo0_out_0_tdata }),
    .m_rfnoc_chdr_tlast  ({m_fifo0_out_1_tlast , m_fifo0_out_0_tlast }),
    .m_rfnoc_chdr_tvalid ({m_fifo0_out_1_tvalid, m_fifo0_out_0_tvalid}),
    .m_rfnoc_chdr_tready ({m_fifo0_out_1_tready, m_fifo0_out_0_tready}),
    .s_rfnoc_ctrl_tdata  (s_fifo0_ctrl_tdata),
    .s_rfnoc_ctrl_tlast  (s_fifo0_ctrl_tlast),
    .s_rfnoc_ctrl_tvalid (s_fifo0_ctrl_tvalid),
    .s_rfnoc_ctrl_tready (s_fifo0_ctrl_tready),
    .m_rfnoc_ctrl_tdata  (m_fifo0_ctrl_tdata),
    .m_rfnoc_ctrl_tlast  (m_fifo0_ctrl_tlast),
    .m_rfnoc_ctrl_tvalid (m_fifo0_ctrl_tvalid),
    .m_rfnoc_ctrl_tready (m_fifo0_ctrl_tready)
  );

  //---------------------------------------------------------------------------
  // Static Router
  //---------------------------------------------------------------------------

  assign s_duc0_in_0_tdata = m_ep0_out0_tdata;
  assign s_duc0_in_0_tlast = m_ep0_out0_tlast;
  assign s_duc0_in_0_tvalid = m_ep0_out0_tvalid;
  assign m_ep0_out0_tready = s_duc0_in_0_tready;

  assign s_radio0_in_0_tdata = m_duc0_out_0_tdata;
  assign s_radio0_in_0_tlast = m_duc0_out_0_tlast;
  assign s_radio0_in_0_tvalid = m_duc0_out_0_tvalid;
  assign m_duc0_out_0_tready = s_radio0_in_0_tready;

  assign s_ddc0_in_0_tdata = m_radio0_out_0_tdata;
  assign s_ddc0_in_0_tlast = m_radio0_out_0_tlast;
  assign s_ddc0_in_0_tvalid = m_radio0_out_0_tvalid;
  assign m_radio0_out_0_tready = s_ddc0_in_0_tready;

  assign s_ep0_in0_tdata = m_ddc0_out_0_tdata;
  assign s_ep0_in0_tlast = m_ddc0_out_0_tlast;
  assign s_ep0_in0_tvalid = m_ddc0_out_0_tvalid;
  assign m_ddc0_out_0_tready = s_ep0_in0_tready;

  assign s_duc0_in_1_tdata = m_ep1_out0_tdata;
  assign s_duc0_in_1_tlast = m_ep1_out0_tlast;
  assign s_duc0_in_1_tvalid = m_ep1_out0_tvalid;
  assign m_ep1_out0_tready = s_duc0_in_1_tready;

  assign s_radio0_in_1_tdata = m_duc0_out_1_tdata;
  assign s_radio0_in_1_tlast = m_duc0_out_1_tlast;
  assign s_radio0_in_1_tvalid = m_duc0_out_1_tvalid;
  assign m_duc0_out_1_tready = s_radio0_in_1_tready;

  assign s_ddc0_in_1_tdata = m_radio0_out_1_tdata;
  assign s_ddc0_in_1_tlast = m_radio0_out_1_tlast;
  assign s_ddc0_in_1_tvalid = m_radio0_out_1_tvalid;
  assign m_radio0_out_1_tready = s_ddc0_in_1_tready;

  assign s_ep1_in0_tdata = m_ddc0_out_1_tdata;
  assign s_ep1_in0_tlast = m_ddc0_out_1_tlast;
  assign s_ep1_in0_tvalid = m_ddc0_out_1_tvalid;
  assign m_ddc0_out_1_tready = s_ep1_in0_tready;

  assign s_fifo0_in_0_tdata = m_ep2_out0_tdata;
  assign s_fifo0_in_0_tlast = m_ep2_out0_tlast;
  assign s_fifo0_in_0_tvalid = m_ep2_out0_tvalid;
  assign m_ep2_out0_tready = s_fifo0_in_0_tready;

  assign s_ep2_in0_tdata = m_fifo0_out_0_tdata;
  assign s_ep2_in0_tlast = m_fifo0_out_0_tlast;
  assign s_ep2_in0_tvalid = m_fifo0_out_0_tvalid;
  assign m_fifo0_out_0_tready = s_ep2_in0_tready;

  assign s_fifo0_in_1_tdata = m_ep3_out0_tdata;
  assign s_fifo0_in_1_tlast = m_ep3_out0_tlast;
  assign s_fifo0_in_1_tvalid = m_ep3_out0_tvalid;
  assign m_ep3_out0_tready = s_fifo0_in_1_tready;

  assign s_ep3_in0_tdata = m_fifo0_out_1_tdata;
  assign s_ep3_in0_tlast = m_fifo0_out_1_tlast;
  assign s_ep3_in0_tvalid = m_fifo0_out_1_tvalid;
  assign m_fifo0_out_1_tready = s_ep3_in0_tready;


  //---------------------------------------------------------------------------
  // Unused Ports
  //---------------------------------------------------------------------------



  //---------------------------------------------------------------------------
  // Clock Domains
  //---------------------------------------------------------------------------

  assign radio0_radio_clk = radio_clk;
  assign duc0_ce_clk = rfnoc_chdr_clk;
  assign ddc0_ce_clk = rfnoc_chdr_clk;
  assign fifo0_mem_clk = dram_clk;


  //---------------------------------------------------------------------------
  // IO Port Connection
  //---------------------------------------------------------------------------

  // Master/Slave Connections:
  assign m_ctrlport_req_wr = radio0_m_ctrlport_req_wr;
  assign m_ctrlport_req_rd = radio0_m_ctrlport_req_rd;
  assign m_ctrlport_req_addr = radio0_m_ctrlport_req_addr;
  assign m_ctrlport_req_data = radio0_m_ctrlport_req_data;
  assign m_ctrlport_req_byte_en = radio0_m_ctrlport_req_byte_en;
  assign m_ctrlport_req_has_time = radio0_m_ctrlport_req_has_time;
  assign m_ctrlport_req_time = radio0_m_ctrlport_req_time;
  assign radio0_m_ctrlport_resp_ack = m_ctrlport_resp_ack;
  assign radio0_m_ctrlport_resp_status = m_ctrlport_resp_status;
  assign radio0_m_ctrlport_resp_data = m_ctrlport_resp_data;

  assign fifo0_axi_rst = axi_rst;
  assign m_axi_awid = fifo0_m_axi_awid;
  assign m_axi_awaddr = fifo0_m_axi_awaddr;
  assign m_axi_awlen = fifo0_m_axi_awlen;
  assign m_axi_awsize = fifo0_m_axi_awsize;
  assign m_axi_awburst = fifo0_m_axi_awburst;
  assign m_axi_awlock = fifo0_m_axi_awlock;
  assign m_axi_awcache = fifo0_m_axi_awcache;
  assign m_axi_awprot = fifo0_m_axi_awprot;
  assign m_axi_awqos = fifo0_m_axi_awqos;
  assign m_axi_awregion = fifo0_m_axi_awregion;
  assign m_axi_awuser = fifo0_m_axi_awuser;
  assign m_axi_awvalid = fifo0_m_axi_awvalid;
  assign fifo0_m_axi_awready = m_axi_awready;
  assign m_axi_wdata = fifo0_m_axi_wdata;
  assign m_axi_wstrb = fifo0_m_axi_wstrb;
  assign m_axi_wlast = fifo0_m_axi_wlast;
  assign m_axi_wuser = fifo0_m_axi_wuser;
  assign m_axi_wvalid = fifo0_m_axi_wvalid;
  assign fifo0_m_axi_wready = m_axi_wready;
  assign fifo0_m_axi_bid = m_axi_bid;
  assign fifo0_m_axi_bresp = m_axi_bresp;
  assign fifo0_m_axi_buser = m_axi_buser;
  assign fifo0_m_axi_bvalid = m_axi_bvalid;
  assign m_axi_bready = fifo0_m_axi_bready;
  assign m_axi_arid = fifo0_m_axi_arid;
  assign m_axi_araddr = fifo0_m_axi_araddr;
  assign m_axi_arlen = fifo0_m_axi_arlen;
  assign m_axi_arsize = fifo0_m_axi_arsize;
  assign m_axi_arburst = fifo0_m_axi_arburst;
  assign m_axi_arlock = fifo0_m_axi_arlock;
  assign m_axi_arcache = fifo0_m_axi_arcache;
  assign m_axi_arprot = fifo0_m_axi_arprot;
  assign m_axi_arqos = fifo0_m_axi_arqos;
  assign m_axi_arregion = fifo0_m_axi_arregion;
  assign m_axi_aruser = fifo0_m_axi_aruser;
  assign m_axi_arvalid = fifo0_m_axi_arvalid;
  assign fifo0_m_axi_arready = m_axi_arready;
  assign fifo0_m_axi_rid = m_axi_rid;
  assign fifo0_m_axi_rdata = m_axi_rdata;
  assign fifo0_m_axi_rresp = m_axi_rresp;
  assign fifo0_m_axi_rlast = m_axi_rlast;
  assign fifo0_m_axi_ruser = m_axi_ruser;
  assign fifo0_m_axi_rvalid = m_axi_rvalid;
  assign m_axi_rready = fifo0_m_axi_rready;

  assign radio0_radio_rx_data = radio_rx_data;
  assign radio0_radio_rx_stb = radio_rx_stb;
  assign radio_rx_running = radio0_radio_rx_running;
  assign radio_tx_data = radio0_radio_tx_data;
  assign radio0_radio_tx_stb = radio_tx_stb;
  assign radio_tx_running = radio0_radio_tx_running;

  // Broadcaster/Listener Connections:
  assign radio0_radio_time = radio_time;

endmodule


`default_nettype wire
