/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.event;

import java.awt.geom.Point2D;
import org.piccolo2d.PCamera;
import org.piccolo2d.event.PDragSequenceEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventFilter;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PDimension;

public class PPanEventHandler
extends PDragSequenceEventHandler {
    private static final int DEFAULT_MAX_AUTOPAN_SPEED = 750;
    private static final int DEFAULT_MIN_AUTOPAN_SPEED = 250;
    private boolean autopan;
    private double minAutopanSpeed = 250.0;
    private double maxAutopanSpeed = 750.0;

    public PPanEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
        this.setAutopan(true);
    }

    protected void drag(PInputEvent event) {
        super.drag(event);
        this.pan(event);
    }

    protected void pan(PInputEvent event) {
        PCamera c = event.getCamera();
        Point2D l = event.getPosition();
        if (c.getViewBounds().contains(l)) {
            PDimension d = event.getDelta();
            c.translateView(d.getWidth(), d.getHeight());
        }
    }

    public void setAutopan(boolean autopan) {
        this.autopan = autopan;
    }

    public boolean getAutopan() {
        return this.autopan;
    }

    public void setMinAutopanSpeed(double minAutopanSpeed) {
        this.minAutopanSpeed = minAutopanSpeed;
    }

    public void setMaxAutopanSpeed(double maxAutopanSpeed) {
        this.maxAutopanSpeed = maxAutopanSpeed;
    }

    public double getMinAutoPanSpeed() {
        return this.minAutopanSpeed;
    }

    public double getMaxAutoPanSpeed() {
        return this.maxAutopanSpeed;
    }

    protected void dragActivityStep(PInputEvent event) {
        if (!this.autopan) {
            return;
        }
        PCamera c = event.getCamera();
        PBounds b = c.getBoundsReference();
        Point2D l = event.getPositionRelativeTo(c);
        int outcode = b.outcode(l);
        PDimension delta = new PDimension();
        if ((outcode & 2) != 0) {
            delta.height = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l.getY() - b.getY()));
        } else if ((outcode & 8) != 0) {
            delta.height = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l.getY() - (b.getY() + b.getHeight())));
        }
        if ((outcode & 4) != 0) {
            delta.width = this.validatePanningSpeed(1.0 + 0.5 * Math.abs(l.getX() - (b.getX() + b.getWidth())));
        } else if ((outcode & 1) != 0) {
            delta.width = this.validatePanningSpeed(-1.0 - 0.5 * Math.abs(l.getX() - b.getX()));
        }
        c.localToView(delta);
        if (delta.width != 0.0 || delta.height != 0.0) {
            c.translateView(delta.width, delta.height);
        }
    }

    protected double validatePanningSpeed(double delta) {
        double stepsPerSecond = 1000.0 / (double)this.getDragActivity().getStepRate();
        double minDelta = this.minAutopanSpeed / stepsPerSecond;
        double maxDelta = this.maxAutopanSpeed / stepsPerSecond;
        double absDelta = Math.abs(delta);
        double clippedDelta = absDelta < minDelta ? minDelta : (absDelta > maxDelta ? maxDelta : delta);
        if (delta < 0.0) {
            return -clippedDelta;
        }
        return clippedDelta;
    }
}

