package uk.co.mccombe.terrain;

/**
 *
 * @author Mike McCombe
 */
public class TerrainProperties {

    private TerrainProperties(String value) {
        stringvalue = value;
    }

    @Override
    public String toString() {
        return stringvalue;
    }
    public static final TerrainProperties COORD = new TerrainProperties("coordinatesystem"); //Current CoordinateSystem
    public static final TerrainProperties REGION = new TerrainProperties("region"); //Region -- needed for obsolete SRTM2 dataset
    public static final TerrainProperties FTP = new TerrainProperties("ftpsite"); //URL for data download
    public static final TerrainProperties AUTO = new TerrainProperties("autodownload"); //Flag to say whether to download missing tiles
    public static final TerrainProperties GRIDREF = new TerrainProperties("currentgridref"); //Current gridref in current Projection
    public static final TerrainProperties EXAMPLE = new TerrainProperties("example"); //Example to show gridref format
    public static final TerrainProperties ELLIPSOID = new TerrainProperties("ellipsoid"); //Current Ellipsoid
    public static final TerrainProperties DATUM = new TerrainProperties("datum"); //Current Datum
    public static final TerrainProperties EW = new TerrainProperties("e-w_range"); //E-W range of mesh to generate
    public static final TerrainProperties NS = new TerrainProperties("n-s_range"); //N-S range of mesh to generate
    public static final TerrainProperties SPACING = new TerrainProperties("spacing"); //Mesh spacing
    public static final TerrainProperties EASTOFFSET = new TerrainProperties("eastoffset"); //Offset to apply to Easting values
    public static final TerrainProperties NORTHOFFSET = new TerrainProperties("northoffset"); //Offset to apply to Northing values
    public static final TerrainProperties HEIGHTOFFSET = new TerrainProperties("heightoffset"); //Offset to apply to height values
    public static final TerrainProperties ALIGNMENT = new TerrainProperties("alignment"); //Integer value to signify where gridref lies in the mesh
    public static final TerrainProperties LAT = new TerrainProperties("latitude"); //Current latitude value
    public static final TerrainProperties LON = new TerrainProperties("longitude"); //Current longitude value
    public static final TerrainProperties LOCALE = new TerrainProperties("locale"); //Current locale
    public static final TerrainProperties ASTER = new TerrainProperties("useASTER"); //Obsolete
    public static final TerrainProperties THERIONCS = new TerrainProperties("therionCoordinateSet"); //EPSG String for Therion
    public static final TerrainProperties DEMURL = new TerrainProperties("demURL"); //Same as FTP
    private final String stringvalue;
}
