package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpnPbrRouteEntries invokes the vpc.DescribeVpnPbrRouteEntries API synchronously
func (client *Client) DescribeVpnPbrRouteEntries(request *DescribeVpnPbrRouteEntriesRequest) (response *DescribeVpnPbrRouteEntriesResponse, err error) {
	response = CreateDescribeVpnPbrRouteEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpnPbrRouteEntriesWithChan invokes the vpc.DescribeVpnPbrRouteEntries API asynchronously
func (client *Client) DescribeVpnPbrRouteEntriesWithChan(request *DescribeVpnPbrRouteEntriesRequest) (<-chan *DescribeVpnPbrRouteEntriesResponse, <-chan error) {
	responseChan := make(chan *DescribeVpnPbrRouteEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpnPbrRouteEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpnPbrRouteEntriesWithCallback invokes the vpc.DescribeVpnPbrRouteEntries API asynchronously
func (client *Client) DescribeVpnPbrRouteEntriesWithCallback(request *DescribeVpnPbrRouteEntriesRequest, callback func(response *DescribeVpnPbrRouteEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpnPbrRouteEntriesResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpnPbrRouteEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpnPbrRouteEntriesRequest is the request struct for api DescribeVpnPbrRouteEntries
type DescribeVpnPbrRouteEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	VpnGatewayId         string           `position:"Query" name:"VpnGatewayId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVpnPbrRouteEntriesResponse is the response struct for api DescribeVpnPbrRouteEntries
type DescribeVpnPbrRouteEntriesResponse struct {
	*responses.BaseResponse
	PageSize           int                `json:"PageSize" xml:"PageSize"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	PageNumber         int                `json:"PageNumber" xml:"PageNumber"`
	TotalCount         int                `json:"TotalCount" xml:"TotalCount"`
	VpnPbrRouteEntries VpnPbrRouteEntries `json:"VpnPbrRouteEntries" xml:"VpnPbrRouteEntries"`
}

// CreateDescribeVpnPbrRouteEntriesRequest creates a request to invoke DescribeVpnPbrRouteEntries API
func CreateDescribeVpnPbrRouteEntriesRequest() (request *DescribeVpnPbrRouteEntriesRequest) {
	request = &DescribeVpnPbrRouteEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeVpnPbrRouteEntries", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpnPbrRouteEntriesResponse creates a response to parse from DescribeVpnPbrRouteEntries response
func CreateDescribeVpnPbrRouteEntriesResponse() (response *DescribeVpnPbrRouteEntriesResponse) {
	response = &DescribeVpnPbrRouteEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
