package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateVpnGatewayWithCertificate invokes the vpc.AssociateVpnGatewayWithCertificate API synchronously
func (client *Client) AssociateVpnGatewayWithCertificate(request *AssociateVpnGatewayWithCertificateRequest) (response *AssociateVpnGatewayWithCertificateResponse, err error) {
	response = CreateAssociateVpnGatewayWithCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateVpnGatewayWithCertificateWithChan invokes the vpc.AssociateVpnGatewayWithCertificate API asynchronously
func (client *Client) AssociateVpnGatewayWithCertificateWithChan(request *AssociateVpnGatewayWithCertificateRequest) (<-chan *AssociateVpnGatewayWithCertificateResponse, <-chan error) {
	responseChan := make(chan *AssociateVpnGatewayWithCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateVpnGatewayWithCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateVpnGatewayWithCertificateWithCallback invokes the vpc.AssociateVpnGatewayWithCertificate API asynchronously
func (client *Client) AssociateVpnGatewayWithCertificateWithCallback(request *AssociateVpnGatewayWithCertificateRequest, callback func(response *AssociateVpnGatewayWithCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateVpnGatewayWithCertificateResponse
		var err error
		defer close(result)
		response, err = client.AssociateVpnGatewayWithCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateVpnGatewayWithCertificateRequest is the request struct for api AssociateVpnGatewayWithCertificate
type AssociateVpnGatewayWithCertificateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DryRun          requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken     string           `position:"Query" name:"ClientToken"`
	CertificateId   string           `position:"Query" name:"CertificateId"`
	VpnGatewayId    string           `position:"Query" name:"VpnGatewayId"`
	CallerBid       string           `position:"Query" name:"callerBid"`
	CertificateType string           `position:"Query" name:"CertificateType"`
}

// AssociateVpnGatewayWithCertificateResponse is the response struct for api AssociateVpnGatewayWithCertificate
type AssociateVpnGatewayWithCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateVpnGatewayWithCertificateRequest creates a request to invoke AssociateVpnGatewayWithCertificate API
func CreateAssociateVpnGatewayWithCertificateRequest() (request *AssociateVpnGatewayWithCertificateRequest) {
	request = &AssociateVpnGatewayWithCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "AssociateVpnGatewayWithCertificate", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssociateVpnGatewayWithCertificateResponse creates a response to parse from AssociateVpnGatewayWithCertificate response
func CreateAssociateVpnGatewayWithCertificateResponse() (response *AssociateVpnGatewayWithCertificateResponse) {
	response = &AssociateVpnGatewayWithCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
