[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::chan::cat n 1]
[copyright {2011 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {Concatenation channel}]
[require Tcl 8.5]
[require TclOO]
[require tcl::chan::core [opt 1]]
[require tcl::chan::cat [opt 1]]
[description]
[para]

The [package tcl::chan::cat] package provides a command creating
concatenation channels. These are non-seekable channels owning a list
of subordinate channels whose contents they return in order, until all
are exhausted. In this manner the cahnnel is the concatentation of the
contents of all the sub-ordinate channels.

[para] Note that the created channels take ownership of the channels
they were constructed with. Whenever they have exhausted one of their
channel it will be closed. Similarly, closing the cat channel will
close all the sub-ordinates it still has.

[para] The internal [package TclOO] class implementing the channel
handler is a sub-class of the [package tcl::chan::core] framework.

[para] Event handling is delegated to the currently active sub-channel.

[section API]

[list_begin definitions]

[call [cmd ::tcl::chan::cat] [arg chan]...]

This command creates the concatenation channel using all the provided
channels, and returns its handle.

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph virtchannel] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[keywords {virtual channel} {reflected channel} {concatenation channel} {tip 219}]
[manpage_end]
