//=============================================================================
//
// file :         TemplateDevServClass.h
//
// description :  Include for the TemplateDevServClass root class.
//                This class is the singleton class for
//                the TemplateDevServ device class.
//                It contains all properties and methods which the 
//                TemplateDevServ requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author: pascal_verdier $
//
// $Revision: 14110 $
// $Date: 2010-02-10 08:47:17 +0100 (Wed, 10 Feb 2010) $
//
// SVN only:
// $HeadURL: $
//
// CVS only:
// $Source$
// $Log$
// Revision 3.8  2009/04/07 10:53:56  pascal_verdier
// Tango-7 release.
// SVN tags added
//
// Revision 3.7  2008/04/07 12:01:57  pascal_verdier
// CVS put property modified.
//
// Revision 3.6  2007/10/23 14:04:30  pascal_verdier
// Spelling mistakes correction
//
// Revision 3.5  2007/09/14 14:36:08  pascal_verdier
// Add an ifdef WIN32 for dll generation
//
// Revision 3.4  2005/09/08 08:45:23  pascal_verdier
// For Pogo-4.4.0 and above.
//
// Revision 3.3  2005/03/02 14:06:15  pascal_verdier
// namespace is different than class name.
//
// Revision 3.2  2004/11/08 11:33:16  pascal_verdier
// if device property not found in database, it takes class property value if exists.
//
// Revision 3.1  2004/09/06 09:27:05  pascal_verdier
// Modified for Tango 5 compatibility.
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#ifndef _TEMPLATEDEVSERVCLASS_H
#define _TEMPLATEDEVSERVCLASS_H

#include <tango.h>
#include <TemplateDevServ.h>


namespace TemplateDevServ_ns
{
//=====================================
//	Define classes for attributes
//=====================================
class ATTRIBUTEAttrib: public Tango::Attr
{
public:
	ATTRIBUTEAttrib():Attr("ATTRIBUTE", DATA_TYPE, RW_TYPE) {};
	~ATTRIBUTEAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<CLASS *>(dev))->read_ATTRIBUTE(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<CLASS *>(dev))->write_ATTRIBUTE(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<CLASS *>(dev))->is_ATTRIBUTE_allowed(ty);}
};


//=========================================
//	Define classes for commands
//=========================================
class DevTemplateCmd : public Tango::Command
{
public:
	DevTemplateCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevTemplateCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevTemplateCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<CLASS *>(dev))->is_COMMAND_allowed(any);}
};

//
// The TemplateDevServClass singleton definition
//

class
#ifdef _TG_WINDOWS_
	__declspec(dllexport)
#endif
	TemplateDevServClass : public Tango::DeviceClass
{
public:

//	add your own data members here
//------------------------------------

public:
	Tango::DbData	cl_prop;
	Tango::DbData	cl_def_prop;
	Tango::DbData	dev_def_prop;

//	Method prototypes
	static TemplateDevServClass *init(const char *);
	static TemplateDevServClass *instance();
	~TemplateDevServClass();
	Tango::DbDatum	get_class_property(string &);
	Tango::DbDatum	get_default_device_property(string &);
	Tango::DbDatum	get_default_class_property(string &);
	
protected:
	TemplateDevServClass(string &);
	static TemplateDevServClass *_instance;
	void command_factory();
	void write_class_property();
	void set_default_property();
	string get_cvstag();
	string get_cvsroot();

private:
	void device_factory(const Tango::DevVarStringArray *);
};


}	//	namespace TemplateDevServ_ns

#endif // _TEMPLATEDEVSERVCLASS_H
