---
date: February 2026
section: 1
title: QEMU-WEB-DESKTOP.PL
---

# NAME

qemu-web-desktop.pl - control qemu-web-desktop

# DESCRIPTION

usage: qwdctl \[help\|download\|refresh\|status\|start
VM\|stop\|gpu\|gpu-unlock\|enable\|disable\|purge\|edit\] \...

> controls the availability of virtual machines for the
> qemu-web-desktop/DARTS service. In addition, the status of the running
> sessions can be displayed and it is possible to start virtual machines
> manually and display them in a browser.

## OPTIONS:

**\--help**\|help\|-h

> show this help.

**\--download**\|download\|update

> scan the */etc/qemu-web-desktop/machines.conf* file for \[name.ext\]
> and download them when URL are given. a \'refresh\' is then performed.
> Virtual machine images are stored into
> */var/lib/qemu-web-desktop/machines*. Additional machine descriptions
> can be given in */etc/qemu-web-desktop/config*.d/\*.ini files.

**\--edit**\|edit \[machines\|config\|web\]

> edit the VM/machine list, the service configuration file or the
> service web page. In the case of the VM list, the \'qwdctl download\'
> command is triggered automatically after edit. Set the \$EDITOR
> variable to select the text editor to use. In case the \'qwdctl edit
> machines\' has no effect on the index.html service landing page,
> specify set \'QWDCTL_INSERT=yes\' or option \'\--machine-insert\'. It
> is recommended to use the \'\--enable\' and \'\--disable\' to manage
> the VM/machine list.

**\--gpu**\|gpu VENDOR:MODEL

> configure GPU for pass-through. The GPU_ids are e.g. \'10de:1d01\'.

**\--gpu-unlock**\|gpu-unlock

> unlock/re-attach all GPU\'s to server (uninstall pass-through).

**\--machines-insert**

> used with download/refresh, force to modify the index.html service
> landing page instead of using an include. Same as QWDCTL_INSERT=yes
> shell variable.

**\--refresh**\|refresh

> scan the */etc/qemu-web-desktop/machines.conf* file, and generate the
> */var/lib/qemu-web-desktop/machines.html* that lists available images
> to show in the qemu-web-desktop main form. Additional machine
> descriptions can be given in */etc/qemu-web-desktop/config*.d/\*.ini
> files.

**\--status**\|status

> list running sessions.

**\--start**\|start VM \...

> start the given VM or ISO file (full path) in a browser. Connect to it
> with the displayed URL. Further arguments are passed to the service
> (see config.pl) e.g. **\--snapshot_alloc_mem**=*1* (in GB) and
> **\--snapshot_alloc_cpu**=*2*. Changes are lost except when specifying
> option **\--snapshot_use_master**=*1*, requiring write access. When
> running ISO\'s you may also specify **\--snapshot_alloc_disk**=*40*
> (in GB). Use \'qwdctl **\--start**\' to get the full list of default
> VM settings.

**\--stop**\|stop TOKEN

> stop sessions matching TOKEN. Some snapshot files may be left-over.

**\--enable**\|enable VMNAME\|FILE\|URL {\'DESCRIPTION\'}

> add or (re)activate a VM name.ext, file or URL. Optional description
> is given as a string.

**\--disable**\|disable VMNAME

> deactivate a VM.

**\--purge**\|purge {VM}

> remove VM files which are inactive and not used. When VM argument is
> given, only files starting by \'VM\' are checked.

**\--version**\|version\|-v

> show qwdctl version.

**\--yes**\|-y

> assume yes to questions. Same as QWDCTL_YES=1 shell variable.

## AUTHOR:

> Written by Roland Mas and Emmanuel Farhi.

## FILES:

> \- */etc/qemu-web-desktop/config.pl*

> \- */etc/qemu-web-desktop/config*.d/\*.pl

> \- */etc/qemu-web-desktop/machines.conf* -
> */etc/qemu-web-desktop/config*.d/\*.ini Entries should contain lines:

> \[name.ext or URL\] description=\<name of machine to appear in the
> form\>

> In addition, any line with:

> url=\<link\>

> will retrieve the given file with: qwdctl download When the
> description is missing, the VM file name is used. Supported virtual
> machine formats: ISO, QCOW2, VDI, VMDK, RAW, VHD/VHDX, QED

> \- */var/lib/qemu-web-desktop/machines* -
> */var/lib/qemu-web-desktop/machines.html*

> \- */usr/share/qemu-web-desktop/html/desktop*

> \- */usr/share/qemu-web-desktop/html/desktop/index.html*

> \-
> https://gitlab.com/soleil-data-treatment/soleil-software-projects/qemu-web-desktop

## ENVIRONMENT VARIABLES:

EDITOR

:   Set the text editor to use, e.g. nano. Default is to use \'editor\'
    or \$EDITOR or \'edit\'.

    QWDCTL_INSERT=yes is equivalent to setting **\--machine-insert**.
    QWDCTL_YES=1 is equivalent to setting **\--yes** (skip confirm).

# AUTHOR

Written by Emmanuel Farhi \<emmanuel.farhi@synchrotron-soleil.fr\>

# COPYRIGHT

Copyright © 2020- Synchrotron Soleil, AGPL3.\
This is free software; see the source for copying conditions. There is
NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

# SEE ALSO

The full documentation for **qemu-web-desktop.pl** is maintained as a
Texinfo manual. If the **info** and **qemu-web-desktop.pl** programs are
properly installed at your site, the command

> **info qemu-web-desktop.pl**

should give you access to the complete manual.
