Minutes from 14th OpenVDB TSC meeting, April 25, 2019

Attendees: *Nick* A., *Dan* B., *Peter* C., *Jeff* L.


Additional Attendees: Bruce Chernia (Intel), Andrew Pearce (DWA)

Regrets: *Ken* M.

Agenda:

1) Confirmation of quorum
2) Selection of secretary
3) VDB Visualize Changes
4) CMake Update

1) A quorum was confirmed. Dan chaired.

2) Secretary - Jeff Lait

3) VDB Visualize Changes

Proposal to remove meshing options from the open source version to
have it match the SideFX version.  Unanimous consent.

It is too many clicks to setup the visualize to put-values-on-points
to work with the spreadsheet.   Suggestion is to make a shelf
tool that shows up in the tab menu only to alias that functionality
(like how Extract All Points works in 17.5)   Any change will
wait until after 6.1

4) CMake Update

It is unclear how much detail goes into readme vs the doxygen,
especially as doxygen only shows up after build, or from the
website that is out of date.   Will merge and figure these
out afterwards as we want CI stabilized first.

VRay has to be installed only into one directory, the mantra
specific dso, not both.

Current CMake rules make it hard to install one SOP.  (Not build,
install)  Commenting out unwanted SOPs in the build list doesn't
work as some build rules refer to SOPs specifically.  In particular,
the OpenVDB Write.

An uninstall target, while not common practice, would be useful.

Lint integration will be delayed until after CMake PR is successful.

Should we auto-install all available dependencies, or demand the
default library match a core requirement?  In particular is BLOSC
which people are unlikely to have installed.  OTOH, if you build
VDB without BLOSC you will not be able to inter-operate.  Conclusion
was to require BLOSC by default.

We should make a list of missing CMake features so we can slowly
check them off.

5) Circle vs Azure

Azure is currently gcc 5.4 and slower.   And Circle's Debian is nicer
to work with.  But Azure has all 3 main platforms and supports GPU.

6) 6.1 Release

The deprecation ticket is complete.

VDB Point issue has had advection tested and is fine.

Note that ragged arrays are supported in Houdini and VDB Points, but not
in the glue between them.  Probably should be.

Warnings as errors is almost finsihed.

7) Bug reporting

For bugs that come within the TSC, submit with JIRA.

8) Standard Types

3rd party uses uint32 datatype in VDB to Points, rendering their files
unreadable with standard install.  Lack of uint32 is an intentional
choice to avoid type explosion.  It is agreed the problems of unsigned
are not worth saving a bit, if you are at that boundary you should
just go to int64.  Or, if absolutely necessary, cast on the client
end.

We should add a comment in the core library where types are registered
providing our reasoning and warning against adding a type there.

Registering a type from outside the core library should be locked
and generate a warning to avoid people accidentally becoming
incompatible.

9) VDB Course

Course approved!   Everyone should do the rights management.

10) Renderman Handoff

Renderman requires a MIPMAP of min/max values, likely for early culling
and partial loading.

Not clear if this has to be a power of 2 pyramid, or could be min/max
on tiles.

Concerns about live min/max data in the VDB structure is it will be
swiftly out of date and cause confusion.  Solved for pipelines by
always regenerating on write and ignoring any already on the
grid.

If load data from an old version that doesn't know how to regenerate
on write, throw away the data.

We need more clarity about what this metadata would consist of.

11) Next Meeting

May 2nd 2019.  3pm-4pm EDT (GMT-4).
