###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openforum_auth_bypass_vuln.nasl 4296 2009-08-28 16:16:57Z aug $
#
# OpenForum 'profile.php' Authentication Bypass Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900927);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-7066");
  script_bugtraq_id(32536);
  script_name("OpenForum 'profile.php' Authentication Bypass Vulnerability");
  desc = "

  Overview: This host is installed with OpenForum and is prone to Authentication
  Bypass vulnerability.

  Vulnerability Insight:
  The 'profile.php' script fails to restrict access to the admin function whcih
  can be exploited via a direct request with the update parameter set to 1.

  Impact:
  Successful exploitation will allow remote attackers to bypass security
  restrictions and modified user and password parameters.

  Impact Level: Application

  Affected Software/OS:
  OpenForum version 0.66 Beta and prior.

  Fix: No solution or patch is available as on 26th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://openforum.sourceforge.net/

  References:
  http://www.milw0rm.com/exploits/7291
  http://xforce.iss.net/xforce/xfdb/46969

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of OpenForum");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_openforum_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

opnfrmPort = get_http_port(default:80);
if(!opnfrmPort){
  exit(0);
}

opnfrmVer = get_kb_item("www/" + opnfrmPort + "/OpenForum");
opnfrmVer = eregmatch(pattern:"^(.+) under (/.*)$", string:opnfrmVer);

if(opnfrmVer[1] != NULL)
{
  if(version_is_less_equal(version:opnfrmVer[1], test_version:"0.66.Beta")){
     security_hole(opnfrmPort);
   }
}
