###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mw6_barcode_bof_vuln.nasl 905 2009-01-30 15:15:24Z jan $
#
# MW6 Technologies Barcode ActiveX Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900455);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0298");
  script_bugtraq_id(33451);
  script_name("MW6 Technologies Barcode ActiveX Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with MW6 Technologies Barcode ActiveX and
  is prone to Buffer Overflow Vulnerability.

  Vulnerability Insight:
  ActiveX control in Barcode.dll due to a boundary error in the
  Barcode.MW6Barcode.1.

  Impact:
  Successful exploitation will let the attacker cause a heap buffer overflow
  via an overly long string assigned to the Supplement property.

  Impact Level: System/Application

  Affected Software/OS:
  Barcode ActiveX (Barcode.dll) version 3.0.0.1 and prior

  Workaround:
  Set the Killbit for the vulnerable CLSID
  http://support.microsoft.com/kb/240797

  Fix: No solution or patch is available as on 30th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For further updates refer, http://mw6tech.com/download.html

  References:
  http://secunia.com/advisories/33663
  http://www.milw0rm.com/exploits/7869

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:N/C:C/I:C/A:C)
    CVSS Temporal Score : 8.0
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Barcode Library File version and kill bit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Classes\Barcode.MW6Barcode")){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Barcode.dll");

dllVer = GetVer(file:file, share:share);
if(!dllVer){
  exit(0);
}

# Grep for Barcode.dll version 3.0.0.1 and prior.
if(version_is_less_equal(version:dllVer, test_version:"3.0.0.1"))
{
  # Workaround Check
  if(!is_killbit_set(clsid:"{14D09688-CFA7-11D5-995A-005004CE563B}")){
    security_hole(0);
  }
}
