###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_adobe_shockwave_player_unspecified_vuln.nasl 3119 2009-06-30 13:51:02Z jun $
#
# Adobe Shockwave Player Unspecified Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900587);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2186");
  script_name("Adobe Shockwave Player Unspecified Vulnerability");
  desc = "

  Overview: This host has Adobe Shockwave Player installed and is prone to
  unspecified vulnerability.

  Vulnerability Insight:
  The flaw exists due to inadequate sanitisation while processing
  unknown vectors.

  Impact:
  Successful attack could allow attackers to execute of arbitrary code.

  Impact Level: Application

  Affected Software/OS:
  Adobe Shockwave Player before 11.0.0.465 on Windows.

  Fix: Upgrade to Adobe Flash Player 11.0.0.465
  http://get.adobe.com/shockwave

  References:
  http://secunia.com/advisories/35544
  http://www.adobe.com/support/security/bulletins/apsb09-08.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High ";

  script_description(desc);
  script_summary("Check for the version of Adobe Shockwave Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_adobe_shockwave_player_detect.nasl");
  script_require_keys("Adobe/ShockwavePlayer/Ver");
  exit(0);
}


include("version_func.inc");

shockVer = get_kb_item("Adobe/ShockwavePlayer/Ver");
if(!shockVer){
  exit(0);
}

# Grep for versions prior to 11.0.0.465
if(version_is_less(version:shockVer, test_version:"11.0.0.465")){
  security_hole(0);
}
