###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for compiz-fusion-plugins-main vulnerability USN-688-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840218);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "688-1");
  script_name( "Ubuntu Update for compiz-fusion-plugins-main vulnerability USN-688-1");
  desc = "

  Vulnerability Insight:

  It was discovered that the Expo plugin for Compiz did not correctly
  restrict the screensaver window from being moved with the mouse.  A local
  attacker could use the mouse to move the screensaver off the screen and
  gain access to the locked desktop session underneath. Default installs
  of Ubuntu were not vulnerable as Expo does not come pre-configured with
  mouse bindings.

  Affected Software/OS:
  compiz-fusion-plugins-main vulnerability on Ubuntu 7.10 ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/000799.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of compiz-fusion-plugins-main vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"compiz-fusion-plugins-main", ver:"0.7.8-0ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"compiz-fusion-plugins-main", ver:"0.7.4-0ubuntu6.2", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"compiz-fusion-plugins-main", ver:"0.5.2+git20070928-0ubuntu2.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}