###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_sys_web_serv_bof_vuln_win.nasl 5655 2009-11-10 11:15:32Z nov $
#
# Sun Java System Web Server Buffer Overflow Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801146);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3878");
  script_bugtraq_id(36813);
  script_name("Sun Java System Web Server Buffer Overflow Vulnerability (Win)");
  desc = "
  Overview: This host has Sun Java Web Server running which is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  An unspecified error and can be exploited to cause a buffer overflow.

  Impact:
  Successful exploitation will let the attackers to execute arbitrary code
  in the context of an affected system.

  Impact Level: System/Application

  Affected Software/OS:
  Sun Java System Web Server version 7.0 update 6 and prior on Windows.

  Fix:
  No solution or patch is available as on 10th November, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.sun.com/

  References:
  http://intevydis.com/vd-list.shtml
  http://www.intevydis.com/blog/?p=79
  http://secunia.com/advisories/37115
  http://www.vupen.com/english/advisories/2009/3024

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Java System Web Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_sun_java_sys_web_serv_detect.nasl", "secpod_reg_enum.nasl");
  script_require_keys("Sun/Java/SysWebServ/Ver", "SMB/WindowsVersion");
  script_require_ports("Services/www", 80, 8888);
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

jswsVer = get_kb_item("Sun/JavaSysWebServ/Ver");
if(!jswsVer){
  exit(0);
}

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Sun Microsystems\WebServer")){
  exit(0);
}

if("7.0" >< jswsVer)
{
  jswsPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\Uninstall\Sun Java System Web Server",
                             item:"UninstallString");
  if(jswsPath != NULL)
  {
    jswsPath = ereg_replace(pattern:'\"(.*)\"', replace:"\1", string:jswsPath);
    jswsPath = jswsPath - "\bin\uninstall.exe" + "\README.TXT";

    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:jswsPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",string:jswsPath);
    jswsVer = read_file(share:share, file:file, offset:0, count:150);

    if(jswsVer != NULL)
    {
      jswsVer = eregmatch(pattern:"Web Server ([0-9.]+)([ a-zA-z]+)?([0-9]+)?",
                          string:jswsVer);
      if(jswsVer[1] != NULL)
      {
        if(jswsVer[3] != NULL)
          jswsVer = jswsVer[1] + "." + jswsVer[3];
        else
         jswsVer = jswsVer[1];
      }
    }
  }
}

if(jswsVer != NULL)
{
  # Check for Web Server version <= 7.0 Update 6
  if(version_is_less_equal(version:jswsVer, test_version:"7.0.6"))
  {
    jswsPort = get_kb_item("Sun/JavaSysWebServ/Port");
    security_hole(jswsPort);
  }
}
