###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for nautilus MDVA-2008:090 (nautilus)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830374);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:090");
  script_name( "Mandriva Update for nautilus MDVA-2008:090 (nautilus)");
  desc = "

  Vulnerability Insight:

  A regression was introduced in the Mandriva Linux GNOME package while
  fixing CD-ROM drives ejecting when using the hardware button when
  the CD-ROM drive was present in the system fstab.  This regression
  caused an error popup to appear when using the eject hardware button
  on CD-ROM drives not present in the system fstab.
  
  This package update fixes this regression and includes many stability
  and bug fixes, as well as translation updates from the GNOME 2.22.2
  release of nautilus and gvfs.

  Affected Software/OS:
  nautilus on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-06/msg00014.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nautilus");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"gvfs", rpm:"gvfs~0.2.4~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgvfs0", rpm:"libgvfs0~0.2.4~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgvfs-devel", rpm:"libgvfs-devel~0.2.4~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnautilus1", rpm:"libnautilus1~2.22.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnautilus-devel", rpm:"libnautilus-devel~2.22.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nautilus", rpm:"nautilus~2.22.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gvfs0", rpm:"lib64gvfs0~0.2.4~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gvfs-devel", rpm:"lib64gvfs-devel~0.2.4~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nautilus1", rpm:"lib64nautilus1~2.22.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nautilus-devel", rpm:"lib64nautilus-devel~2.22.3~2.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}