###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bpftp_detect.nasl 797 2009-01-02 19:07:24Z jan $
#
# BulletProof FTP Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800329);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("BulletProof FTP Version Detection");
  desc = "
  Overview : This script finds the installed BulletProof FTP Version and
  saves the version in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set Version of BulletProof FTP in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall" +
      "\BulletProof FTP Client_is1";
if("BulletProof FTP Client" >< registry_get_sz(key:key, item:"DisplayName"))
{
  exePath = registry_get_sz(key:key, item:"DisplayIcon");
  if(!exePath){
    exit(0);
  }
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

  bpftpVer = GetVer(file:file, share:share);

  # Set the Version in KB
  if(bpftpVer)
  {
    set_kb_item(name:"BulletProof/Client/Ver", value:bpftpVer);
    security_note(data:"Bullet Proof FTP Client version " + bpftpVer + " running"+ 
                       " at location " + exePath + " was detected on the host");
  }
}
