#
#VID 842bafdd-be2f-11dd-a578-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 842bafdd-be2f-11dd-a578-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61953);
 script_cve_id("CVE-2008-2237", "CVE-2008-2238");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: openoffice.org-2, openoffice.org-2-RC, openoffice.org-2-devel";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   openoffice.org-2
   openoffice.org-2-RC
   openoffice.org-2-devel

CVE-2008-2237
Heap-based buffer overflow in OpenOffice.org (OOo) 2.x before 2.4.2
allows remote attackers to execute arbitrary code via a crafted WMF
file associated with a StarOffice/StarSuite document.

CVE-2008-2238
Multiple integer overflows in OpenOffice.org (OOo) 2.x before 2.4.2
allow remote attackers to execute arbitrary code via crafted EMR
records in an EMF file associated with a StarOffice/StarSuite
document, which trigger a heap-based buffer overflow.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.openoffice.org/security/cves/CVE-2008-2237.html
http://www.openoffice.org/security/cves/CVE-2008-2238.html
http://www.vuxml.org/freebsd/842bafdd-be2f-11dd-a578-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: openoffice.org-2, openoffice.org-2-RC, openoffice.org-2-devel";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"openoffice.org-2");
if(!isnull(bver) && revcomp(a:bver, b:"2.4")>=0 && revcomp(a:bver, b:"2.4.2")<0) {
    security_note(0, data:"Package openoffice.org-2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"2.4.20040402")>=0) {
    security_note(0, data:"Package openoffice.org-2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"openoffice.org-2-RC");
if(!isnull(bver) && revcomp(a:bver, b:"2.4")>=0 && revcomp(a:bver, b:"2.4.2")<0) {
    security_note(0, data:"Package openoffice.org-2-RC version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"2.4.20040402")>=0) {
    security_note(0, data:"Package openoffice.org-2-RC version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"openoffice.org-2-devel");
if(!isnull(bver) && revcomp(a:bver, b:"2.4")>=0 && revcomp(a:bver, b:"2.4.2")<0) {
    security_note(0, data:"Package openoffice.org-2-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"2.4.20040402")>=0) {
    security_note(0, data:"Package openoffice.org-2-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
