#
#VID 91c606fc-b5d0-11d9-a788-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52545);
 script_cve_id("CVE-2005-1195");
 script_bugtraq_id(13270,13271);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "mplayer & libxine -- MMS and Real RTSP buffer overflow vulnerabilities";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   mplayer
   mplayer-gtk
   mplayer-gtk2
   mplayer-esound
   mplayer-gtk-esound
   mplayer-gtk2-esound
   libxine

CVE-2005-1195
Multiple heap-based buffer overflows in the code used to handle (1)
MMST streams or (2) RealMedia RTSP streams in MPlayer 1.0pre6 and
earlier allow remote malicious servers to execute arbitrary code.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.mplayerhq.hu/homepage/design7/news.html#vuln10
http://www.mplayerhq.hu/homepage/design7/news.html#vuln11
http://xinehq.de/index.php/security/XSA-2004-8
http://www.vuxml.org/freebsd/91c606fc-b5d0-11d9-a788-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "mplayer & libxine -- MMS and Real RTSP buffer overflow vulnerabilities";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mplayer");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package mplayer version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package mplayer-gtk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk2");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package mplayer-gtk2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package mplayer-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package mplayer-gtk-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk2-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7")<0) {
    security_note(0, data:"Package mplayer-gtk2-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"libxine");
if(!isnull(bver) && revcomp(a:bver, b:"0.9.9")>=0 && revcomp(a:bver, b:"1.0.1")<0) {
    security_note(0, data:"Package libxine version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
