# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1814-1 (libsndfile)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64250);
 script_cve_id("CVE-2009-1788", "CVE-2009-1791");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1814-1 (libsndfile)";
 script_name(name);

 desc = "The remote host is missing an update to libsndfile
announced via advisory DSA 1814-1.


Two vulnerabilities have been found in libsndfile, a library to read
and write sampled audio data.  The Common Vulnerabilities and Exposures
project identified the following problems:

Tobias Klein discovered that the VOC parsing routines suffer of a heap-based
buffer overflow which can be triggered by an attacker via a crafted VOC
header (CVE-2009-1788).

The vendor discovered that the  AIFF parsing routines suffer of a heap-based
buffer overflow similar to CVE-2009-1788 which can be triggered by an attacker
via a crafted AIFF header (CVE-2009-1791).

In both cases the overflowing data is not completely attacker controlled but
still leads to application crashes or under some circumstances might still
lead to arbitrary code execution.


For the oldstable distribution (etch), this problem has been fixed in
version 1.0.16-2+etch2.

For the stable distribution (lenny), this problem has been fixed in
version 1.0.17-4+lenny2.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 1.0.20-1.


We recommend that you upgrade your libsndfile packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201814-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1814-1 (libsndfile)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsndfile1-dev", ver:"1.0.16-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsndfile1", ver:"1.0.16-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sndfile-programs", ver:"1.0.16-2+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsndfile1", ver:"1.0.17-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsndfile1-dev", ver:"1.0.17-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sndfile-programs", ver:"1.0.17-4+lenny2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
