#! /usr/bin/env python

from __future__ import print_function
from openturns import *
from math import *

TESTPREAMBLE()

try:
    # Create a function
    inputVar = Description(2)
    inputVar[0] = "x"
    inputVar[1] = "y"
    outputVar = Description(1)
    outputVar[0] = "z"
    formula = Description(1)
    formula[0] = "exp(-sin(cos(y)^2*x^2+sin(x)^2*y^2))"
    f = Function(inputVar, outputVar, formula)

    # Generate the data for the curves to be drawn
    discretization = Point(2)
    nX = 75
    nY = 75
    discretization[0] = nX
    discretization[1] = nY
    inputData = Box(discretization).generate()
    inputData *= [10.0] * 2
    inputData += [-5.0] * 2
    data = f(inputData)
    size = 7
    levels = Point(size)
    for i in range(size):
        levels[i] = (0.5 + i) / size
    # Create an empty graph
    myGraph = Graph("Complex iso lines", "u1", "u2", True, "topright")

    # Create the first cloud
    myContour = Contour(nX + 2, nY + 2, data)
    myContour.setLevels(levels)
    myContour.setColor("red")
    print("contour=", myContour)

    # Then, draw it
    myGraph.add(myContour)
    myGraph.draw("Graph_Contour_OT")

    # Check that the correct files have been generated by computing their
    # checksum

except:
    import sys
    print("t_Contour_std.py", sys.exc_info()[0], sys.exc_info()[1])
