%feature("docstring") OT::Indices
R"RAW(Collection of unsigned integers.

Available constructors:
    Indices(*size=0, value=0*)

    Indices(*sequence*)

Parameters
----------
size : int, :math:`size \geq 0`
    Size of the collection.
value : positive int
    Value set to the *size* elements.
sequence : sequence of int
    Components of the vector.

Examples
--------
>>> import openturns as ot

Use the first constructor:

>>> ot.Indices(3)
[0,0,0]
>>> ot.Indices(3, 4)
[4,4,4]

Use the second constructor:

>>> vector = ot.Indices([100, 30, 70])
>>> vector
[100,30,70]

Use some functionalities:

>>> vector[1] = 20
>>> vector
[100,20,70]
>>> vector.add(50)
>>> vector
[100,20,70,50]

The `Indices` class has a method that can search for an
element and return `True` if the element is in the indices, 
and `False` otherwise.
We can access to it using the `in` keyword.

>>> indices = ot.Indices([3, 5, 7, 9])
>>> print(0 in indices)
False
>>> print(3 in indices)
True)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::Indices::check
"Check that no value is repeated and no value exceeds the given bound.

Parameters
----------
bound : positive int
    The bound value.

Returns
-------
check : bool
    *True* if no value is repeated and all values are < bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Indices::complement
R"RAW(Build the complement of the current indices wrt :math:`\{0,\dots,n-1\}`.

Parameters
----------
bound : positive int
    The value of :math:`n`.

Returns
-------
complement : :class:`~openturns.Indices`
    The increasing collection of integers in :math:`\{0,\dots,n-1\}` not in the current indices.

Examples
--------
>>> import openturns as ot
>>> indices = ot.Indices([1, 3, 4])
>>> print(indices.complement(7))
[0,2,5,6])RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::Indices::fill
"Fill the indices with a linear progression.

Starting from the start value *initialValue* by step *stepSize*.

Parameters
----------
initialValue : positive int
    Initial value. By default it is equal to 0.
stepSize : positive int
    Step size. By default it is equal to 1.

Examples
--------
>>> import openturns as ot
>>> indices = ot.Indices(3)
>>> indices.fill()
>>> print(indices)
[0,1,2]
>>> indices = ot.Indices(3)
>>> indices.fill(2, 4)
>>> print(indices)
[2,6,10]"

// ---------------------------------------------------------------------

%feature("docstring") OT::Indices::isIncreasing
"Check if the indices are increasing.

Returns
-------
isIncreasing : bool
    *True* if the indices are increasing.

Examples
--------
>>> import openturns as ot
>>> indices = ot.Indices(3)
>>> indices.fill()
>>> indices.isIncreasing()
True"

// ---------------------------------------------------------------------

%feature("docstring") OT::Indices::isStrictlyIncreasing
"Check if the indices are strictly increasing.

Returns
-------
isStrictlyIncreasing : bool
    *True* if the indices are strictly increasing.

Examples
--------
>>> import openturns as ot
>>> indices = ot.Indices([1, 2, 5])
>>> indices.isIncreasing()
True"

// ---------------------------------------------------------------------

%feature("docstring") OT::Indices::normInf
"Compute the infinite norm of the indices.

Returns
-------
norm: int
    The maximum of the indices.

Examples
--------
>>> import openturns as ot
>>> indices = ot.Indices([3, 5, 7, 9])
>>> print(indices.normInf())
9"

// ---------------------------------------------------------------------

%feature("docstring") OT::Indices::norm1
"Compute the 1-norm of the indices.

Returns
-------
norm: int
    The sum of the indices.

Examples
--------
>>> import openturns as ot
>>> indices = ot.Indices([3, 5, 7, 9])
>>> print(indices.norm1())
24"
