%feature("docstring") OT::DistributionFactoryResult
"Results of distribution estimation.

This class is the result of a distribution estimation through a
:class:`~openturns.DistributionFactory`.

Parameters
----------
distribution : :class:`~openturns.Distribution`
    The estimated distribution.
parameterDistribution : :class:`~openturns.Distribution`
    The distribution of the parameter.


See also
--------
DistributionFactory


Examples
--------
We demonstrate the method on a Beta Distribution.

Create a sample from a Beta distribution:

>>> import openturns as ot
>>> sample = ot.Beta().getSample(10)
>>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

Fit a Beta distribution and create a :class:`~openturns.DistributionFactory`: 

>>> fittedRes = ot.BetaFactory().buildEstimator(sample)

Get the fitted Beta distribution and its parameters:

>>> fittedBeta =  fittedRes.getDistribution()

Get the asymptotic parameters distribution: 

>>> paramDist = fittedRes.getParameterDistribution()"

// ---------------------------------------------------------------------

%feature("docstring") OT::DistributionFactoryResult::getDistribution
"Accessor to the estimated distribution.

Returns
-------
distribution : :class:`~openturns.Distribution`
    The estimated distribution."

// ---------------------------------------------------------------------

%feature("docstring") OT::DistributionFactoryResult::setDistribution
"Accessor to the estimated distribution.

Parameters
----------
distribution : :class:`~openturns.Distribution`
    The estimated distribution."

// ---------------------------------------------------------------------

%feature("docstring") OT::DistributionFactoryResult::getParameterDistribution
"Accessor to the distribution of the parameter.

Returns
-------
parameterDistribution : :class:`~openturns.Distribution`
    The distribution of the parameter."

// ---------------------------------------------------------------------

%feature("docstring") OT::DistributionFactoryResult::setParameterDistribution
"Accessor to the distribution of the parameter.

Parameters
----------
parameterDistribution : :class:`~openturns.Distribution`
    The distribution of the parameter."
