/*
 *  Copyright (c) 2009,2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENRIJN_KERNEL_SOURCE_H_
#define _OPENRIJN_KERNEL_SOURCE_H_

#include <OpenRijn/Export.h>
#include <GTLFragment/Source.h>

namespace OpenRijn {
  class Metadata;
  /**
   * @ingroup OpenRijn
   * 
   * Define the source code of a Sketch. Allow to access to information like the metadata,
   * or the source code.
   */
  class OPENRIJN_EXPORT Source : public GTLFragment::Source {
    public:
      Source();
      Source(const Source& );
      Source& operator=(const Source& );
      ~Source();
    public:
      enum SourceType {
        InvalidSource, ///< Not a valid Rijn source code
        Library, ///< \ref Library
        Drawing, ///< A \ref Sketch with only an output image
      };
      /**
       * @return the type of the Kernel/Library
       */
      SourceType sourceType() const;
    private:
      struct Private;
      inline const Private* d_func() const;
  };
}

#endif
