/*
 *  Copyright (c) 2007 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GTLCore/Parameter.h"

#include "Debug.h"
#include "GTLCore/Type.h"
#include "GTLCore/Value.h"

using namespace GTLCore;

struct Parameter::Private {
  GTLCore::String name;
  const GTLCore::Type* type;
  bool output;
  bool varying;
  Value defaultValue;
};

Parameter::Parameter() : d(new Private )
{
}

Parameter::Parameter(const GTLCore::String& _name, const GTLCore::Type* _type, bool _output, bool _varying, const Value& _defaultValue) : d(new Private)

{
  GTL_ASSERT(_type);
  d->name = _name;
  d->type = _type;
  d->output = _output;
  d->varying = _varying;
  d->defaultValue = _defaultValue;
}

Parameter::Parameter(const Parameter& arg) : d(new Private)
{
  *this = arg;
}

Parameter& Parameter::operator=(const Parameter& rhs)
{
  *d = *rhs.d;
  return *this;
}

Parameter::~Parameter()
{
  delete d;
}

const GTLCore::String& Parameter::name() const
{
  return d->name;
}

const GTLCore::Type* Parameter::type() const
{
  GTL_ASSERT(d);
  return d->type;
}

bool Parameter::isOutput() const
{
  return d->output;
}

Value Parameter::defaultValue() const
{
  return d->defaultValue;
}
