/*###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_BatteryConformsToProfileAccess.h"

int Battery_OpenDRIM_BatteryConformsToProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Battery_CIM_RegisteredProfile_load(broker, errorMessage));
	CF_assert(Battery_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Battery_CIM_RegisteredProfile_unload(errorMessage));
	CF_assert(Battery_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_isAssociated(const Instance& ConformantStandard, const Instance& ManagedElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BatteryConformsToProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_enumerateConformantStandards(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_enumerateConformantStandards(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		Battery_OpenDRIM_BatteryConformsToProfile_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			ConformantStandard_classnames[0], ManagedElement_classnames[0],
			ConformantStandard_role.c_str(), ManagedElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_referenceConformantStandardToManagedElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BatteryConformsToProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath ConformantStandard_objectpath;
	instance.getConformantStandard(ConformantStandard_objectpath);
	Instance ConformantStandard_instance;
	CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_getConformantStandard(broker, ctx, ConformantStandard_objectpath, ConformantStandard_instance, NULL, errorMessage));
	
	Objectpath ManagedElement_objectpath;
	instance.getManagedElement(ManagedElement_objectpath);
	Instance ManagedElement_instance;
	CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_getManagedElement(broker, ctx, ManagedElement_objectpath, ManagedElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_isAssociated(ConformantStandard_instance, ManagedElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BatteryConformsToProfile& newInstance, const OpenDRIM_BatteryConformsToProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_BatteryConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BatteryConformsToProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_BatteryConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BatteryConformsToProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_BatteryConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ManagedElement_instances;
	if (discriminant=="a")
		CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ManagedElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_isAssociated(ConformantStandard_instance, ManagedElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			ManagedElement_associatedInstances.push_back(ManagedElement_instances[i]);
	}
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ConformantStandard_instances;
	if (discriminant=="a")
		CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_enumerateConformantStandards(broker, ctx, ConformantStandard_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_enumerateConformantStandards(broker, ctx, ConformantStandard_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_enumerateConformantStandards(broker, ctx, ConformantStandard_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ConformantStandard_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Battery_OpenDRIM_BatteryConformsToProfile_isAssociated(ConformantStandard_instances[i], ManagedElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			ConformantStandard_associatedInstances.push_back(ConformantStandard_instances[i]);
	}
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_BatteryConformsToProfile>& OpenDRIM_BatteryConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ManagedElement_instances.size(); i++) {
		OpenDRIM_BatteryConformsToProfile instance;
		instance.setConformantStandard(((Instance) ConformantStandard_instance).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instances[i]).getObjectpath());
		
		OpenDRIM_BatteryConformsToProfile_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_BatteryConformsToProfile>& OpenDRIM_BatteryConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ConformantStandard_instances.size(); i++) {
		OpenDRIM_BatteryConformsToProfile instance;
		instance.setConformantStandard(((Instance) ConformantStandard_instances[i]).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instance).getObjectpath());
		
		OpenDRIM_BatteryConformsToProfile_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Battery_OpenDRIM_BatteryConformsToProfile_populate(OpenDRIM_BatteryConformsToProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

