/* omega, (C) 1987,1988,1989 by Laurence Raphael Brothers */
/* minit.h */
/* This file defines and initializes the Monsters Array */

/* the struct monster (from defs.h) looks like:

struct monster {
  struct objectlist *possessions;
  unsigned char attacked;
  int aux1,aux2,x,y,click;
  int id,hp,hit,ac,dmg,sense,wakeup,level,speed;
  unsigned char sleep,treasure;
  long xpv;
  int corpseweight,corpsevalue,transformid,startthing;
  unsigned char uniqueness;
  int talkf,movef,meleef,strikef,specialf;
  long status,immunity;
  Symbol monchar;
  char *monstring,*corpsestr,*meleestr;
};

*/

struct monster Monsters[NUMMONSTERS] = {
{ NULL,0,0,0,0,0,0,ML0+0,1,1,10,2,4,1,0,1,50,0,1,1,1,-1,-1,COMMON,M_TALK_STUPID,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|FLYING|POISONOUS,0,'h'|CLR(YELLOW),"hornet","dead hornet","AXAX" },

{ NULL,0,0,0,0,0,0,ML0+1,30,0,0,0,10,10,0,5,100,2,15,1000,0,-1,-1,COMMON,M_TALK_MP,M_MOVE_FOLLOW,M_MELEE_MP,M_NO_OP,M_SP_MP,MOBILE|NEEDY,0,'@'|CLR(RED),"mendicant priest","dead mendicant priest","BX" },

{ NULL,0,0,0,0,0,0,ML0+2,15,0,0,0,10,10,0,7,0,3,5,1000,0,-1,-1,COMMON,M_TALK_IM,M_MOVE_FOLLOW,M_NO_OP,M_NO_OP,M_SP_ESCAPE,MOBILE,0,'@'|CLR(RED),"itinerant merchant","dead itinerant merchant","BX" },

{ NULL,0,0,0,0,0,0,ML0+3,150,20,20,25,10,1,0,3,50,0,150,1000,0,-1,WEAPONID+5,COMMON,M_TALK_GUARD,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_SP_WHISTLEBLOWER,MOBILE,0,'G'|CLR(RED),"guardsman","dead guardsman","A?A?A?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML0+4,5,5,5,5,5,5,0,5,5,0,5,1000,0,-1,-1,COMMON,M_TALK_MAN,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,AWAKE|HOSTILE,0,'@'|CLR(RED),"Log NPC","dead NPC","A?B?" },

{ NULL,0,0,0,0,0,0,ML0+5,5,5,5,1,2,1,0,5,25,0,2,200,10,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_RANDOM,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|SWIMMING|EDIBLE,0,'s'|CLR(WHITE),"sheep","side of mutton","ALBX" },

{ NULL,0,0,0,0,0,0,ML0+6,16,6,6,1,2,1,0,6,0,0,6,200,0,-1,-1,COMMON,M_TALK_MERCHANT,M_NO_OP,M_MELEE_NORMAL,M_NO_OP,M_SP_MERCHANT,MOBILE,0,'@'|CLR(RED),"merchant","dead merchant","A?B?" },

{ NULL,0,0,0,0,0,0,ML0+7,10,5,5,5,5,5,0,5,25,1,5,1800,0,-1,-1,COMMON,M_TALK_MAN,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|WANDERING,0,'@'|CLR(RED),"0th level NPC","dead 0th level NPC","AXBX" },

{ NULL,0,0,0,0,0,0,ML0+8,5,5,5,5,5,5,0,5,5,0,5,1000,0,-1,-1,UNIQUE_MADE,M_TALK_MAN,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,AWAKE|HOSTILE,0,'@'|CLR(RED),"Hiscore NPC","dead NPC","A?B?" },

{ NULL,0,0,0,0,0,0,ML1+0,25,12,5,15,3,3,1,8,100,0,10,100,0,-1,WEAPONID+17,COMMON,M_TALK_STUPID,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|POISONOUS,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY),'g'|CLR(BROWN),"grunt","dead grunt","ACAC" },

{ NULL,0,0,0,0,0,0,ML1+1,1,10,5,2,10,10,1,4,0,0,3,1,5,POTIONID+5,-1,COMMON,M_TALK_STUPID,M_MOVE_FLUTTER,M_MELEE_SLEEP,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|FLYING,0,'t'|CLR(PURPLE),"tse-tse fly","dead tse-tse fly","AX" },

{ NULL,0,0,0,0,0,0,ML1+2,1,0,0,0,10,10,1,10,0,1,5,2,50,SCROLLID+21,-1,COMMON,M_TALK_STUPID,M_MOVE_FLUTTER,M_NO_OP,M_NO_OP,M_SP_SUMMON,0,0,'f'|CLR(PURPLE),"fnord","fnord's antennae","" },
  
{ NULL,0,0,0,0,0,0,ML1+3,5,5,3,5,5,2,1,3,30,0,5,10,0,-1,-1,COMMON,M_TALK_STUPID,M_MOVE_FLUTTER,M_MELEE_DISEASE,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|SWIMMING,0,'r'|CLR(BROWN),"sewer rat","dead sewer rat","ALAL" },
  
{ NULL,0,0,0,0,0,0,ML1+4,12,0,0,0,10,10,1,10,0,0,1,1,0,-1,-1,COMMON,M_TALK_STUPID,M_NO_OP,M_NO_OP,M_NO_OP,M_SP_AGGRAVATE,0,pow2(FLAME),'f'|CLR(CYAN),"aggravator fungus","aggravator fungus spores","" },

  /* WDT: this one used to blink.  I HATE BLINKING. */
{ NULL,0,0,0,0,0,0,ML1+5,50,0,5,0,3,3,1,24,100,2,20,20,25,SCROLLID+5,-1,COMMON,M_TALK_STUPID,M_NO_OP,M_NO_OP,M_NO_OP,M_MOVE_TELEPORT,MOBILE,0,'b'|CLR(BRIGHT_WHITE)/*|CLR(FG_BLINK)*/,"blipper","blipper organ","BX" },

{ NULL,0,0,0,0,0,0,ML1+6,8,10,8,8,10,2,1,5,0,1,10,500,0,-1,WEAPONID+0,COMMON,M_TALK_GREEDY,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|GREEDY,0,'g'|CLR(GREEN),"goblin","dead goblin","AXBX" },

{ NULL,0,0,0,0,0,0,ML1+7,10,10,10,10,4,4,1,9,50,1,25,5,10,SCROLLID+19,-1,COMMON,M_TALK_SILENT,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_SP_ILLUSION,MOBILE|HOSTILE|POISONOUS,pow2(SLEEP),'p'|CLR(RED),"phantasticon","phantasticon's eyes","AXAXBX" },

{ NULL,0,0,0,0,0,0,ML1+8,5,10,10,15,10,3,1,12,100,0,15,25,0,-1,-1,COMMON,M_TALK_ROBOT,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE,pow2(ELECTRICITY)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'R'|CLR(GREY),"household robot","household robot battery","ACBC" },

{ NULL,0,0,0,0,0,0,ML1+9,1,5,5,5,10,10,1,8,50,0,1,250,0,-1,-1,COMMON,M_TALK_STUPID,M_MOVE_SCAREDY,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE,0,'g'|CLR(WHITE),"pencil-necked geek","dead pencil-necked geek","AX" },

{ NULL,0,0,0,0,0,0,ML1+10,6,8,5,6,4,3,1,4,50,0,6,30,0,-1,-1,COMMON,M_TALK_MIMSY,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|FLYING|EDIBLE,0,'b'|CLR(GREEN),"borogrove","borogrove wings","AXBX" },

{ NULL,0,0,0,0,0,0,ML1+11,3,0,15,1,4,4,1,2,50,0,1,20,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|FLYING|EDIBLE,0,'q'|CLR(BROWN),"quail","quail en brochet","" },

{ NULL,0,0,0,0,0,0,ML1+12,13,10,5,5,2,1,1,4,50,0,3,20,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|SWIMMING|EDIBLE,0,'b'|CLR(BROWN),"badger","badger ribs","ALAL" },

{ NULL,0,0,0,0,0,0,ML1+13,7,15,10,10,10,5,1,2,50,0,10,20,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|FLYING|EDIBLE,0,'h'|CLR(BROWN),"hawk","buffalo style hawk wings","AH" },

{ NULL,0,0,0,0,0,0,ML1+14,23,5,10,5,10,10,1,2,50,0,5,500,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|SWIMMING|EDIBLE,0,'d'|CLR(BROWN),"deer","venison","AXBXBX" },

{ NULL,0,0,0,0,0,0,ML1+15,30,10,5,10,4,2,1,5,50,0,5,500,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|EDIBLE,0,'c'|CLR(BROWN),"camel","hump au jus","AXBX" },

{ NULL,0,0,0,0,0,0,ML1+16,20,0,5,5,4,2,1,4,50,0,3,400,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|SWIMMING|EDIBLE,0,'a'|CLR(BROWN),"anteater","roast loin of anteater","AL" },

{ NULL,0,0,0,0,0,0,ML1+17,3,0,7,1,4,4,1,3,50,0,1,20,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|SWIMMING|EDIBLE,0,'r'|CLR(BROWN),"rabbit","bunnyburgers","AL" },

{ NULL,0,0,0,0,0,0,ML1+18,3,0,18,1,4,4,1,2,50,0,1,20,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_NO_OP,M_NO_OP,M_NO_OP,MOBILE|ONLYSWIM|EDIBLE,0,'t'|CLR(CYAN),"trout","filet of trout","" },

{ NULL,0,0,0,0,0,0,ML1+19,1,0,0,0,4,4,1,4,50,0,1,20,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_NO_OP,M_NO_OP,M_NO_OP,MOBILE|ONLYSWIM|EDIBLE,0,'b'|CLR(CYAN),"striped bass","bass filets","" },

{ NULL,0,0,0,0,0,0,ML1+20,5,10,10,12,10,2,1,3,50,0,5,20,0,-1,-1,COMMON,M_TALK_PARROT,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HUNGRY|FLYING|EDIBLE,0,'p'|CLR(PURPLE),"parrot","grilled breast of parrot","AH" },

{ NULL,0,0,0,0,0,0,ML1+21,10,10,5,5,10,2,1,4,20,0,8,20,0,-1,-1,COMMON,M_TALK_HYENA,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|SWIMMING|EDIBLE,0,'h'|CLR(BROWN),"hyena","hyena ribs","AX" },

{ NULL,0,0,0,0,0,0,ML2+0,20,16,10,15,10,3,2,3,50,1,40,1000,0,-1,WEAPONID+1,COMMON,M_TALK_NINJA,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_SP_SURPRISE,MOBILE|HOSTILE|M_INVISIBLE,0,'n'|CLR(GREY),"apprentice ninja","dead ninja","A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML2+1,30,15,10,5,10,10,2,6,0,0,35,250,100,-1,-1,COMMON,M_TALK_TITTER,M_MOVE_FLUTTER,M_MELEE_NG,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|FLYING|POISONOUS,0,'n'|CLR(GREY),"night gaunt","dead night gaunt","ACAC" },

{ NULL,0,0,0,0,0,0,ML2+2,32,0,10,0,10,10,2,2,0,3,20,1000,0,-1,-1,COMMON,M_TALK_THIEF,M_MOVE_SMART,M_NO_OP,M_NO_OP,M_SP_THIEF,MOBILE|HOSTILE|GREEDY,0,'@'|CLR(RED),"sneak-thief","dead sneak-thief","AXB?B?B?" },

{ NULL,0,0,0,0,0,0,ML2+3,25,0,0,0,10,10,2,5,0,0,10,1,20,POTIONID+16,-1,COMMON,M_NO_OP,M_MOVE_RANDOM,M_NO_OP,M_NO_OP,M_SP_EXPLODE,MOBILE|FLYING,pow2(SLEEP),'e'|CLR(GREEN),"floating eye","dead floating eye","" },

{ NULL,0,0,0,0,0,0,ML2+4,30,10,10,10,6,3,2,4,0,0,25,10,0,-1,-1,COMMON,M_TALK_SLITHY,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE,0,'t'|CLR(GREEN),"tove","dead tove","ALBX" },

{ NULL,0,0,0,0,0,0,ML2+5,32,15,10,5,5,3,2,8,0,1,30,50,30,POTIONID+10,-1,COMMON,M_NO_OP,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_NO_OP,MOBILE|HOSTILE|M_INVISIBLE,0,'n'|CLR(GREY),"transparent nasty","dead transparent nasty","ACAC" },

{ NULL,0,0,0,0,0,0,ML2+6,32,0,10,0,5,10,2,20,0,0,30,1,0,-1,-1,COMMON,M_TALK_HINT,M_MOVE_SPIRIT,M_NO_OP,M_NO_OP,M_SP_GHOST,MOBILE|WANDERING|INTANGIBLE,pow2(NORMAL_DAMAGE)|pow2(FEAR)|pow2(SLEEP),'g'|CLR(GREY),"ghost","ghost ectoplasm","" },

{ NULL,0,0,0,0,0,0,ML2+7,20,5,10,5,5,3,2,8,0,2,40,1,100,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_SCAREDY,M_MELEE_NORMAL,M_NO_OP,M_SP_SPELL,MOBILE|HOSTILE,pow2(COLD),'e'|CLR(RED),"enchanter","dead enchanter","AXBXBX" },

{ NULL,0,0,0,0,0,0,ML2+8,7,0,0,0,10,3,2,12,0,0,40,1,10,SCROLLID+22,-1,COMMON,M_NO_OP,M_NO_OP,M_NO_OP,M_NO_OP,M_SP_BLACKOUT,AWAKE|HOSTILE|POISONOUS,0,'f'|CLR(GREY),"murk fungus","murk cloud particles","" },

{ NULL,0,0,0,0,0,0,ML2+9,25,20,12,10,10,3,2,4,0,1,30,1,-1,-1,WEAPONID+12,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_NO_OP,MOBILE|HOSTILE|GREEDY,pow2(FEAR),'G'|CLR(GREEN),"goblin chieftain","dead goblin chieftain","A?A?B?" },

{ NULL,0,0,0,0,0,0,ML2+10,40,15,5,15,8,3,2,4,10,0,35,50,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|SWIMMING|EDIBLE,pow2(FEAR)|pow2(SLEEP),'w'|CLR(BROWN),"wolf","wolf cutlets","AXAXAX" },

{ NULL,0,0,0,0,0,0,ML2+11,20,15,15,10,3,3,2,3,10,0,30,50,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_NORMAL,M_MELEE_POISON,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|POISONOUS,pow2(FEAR)|pow2(SLEEP),'a'|CLR(RED),"giant soldier ant","ant mandibles","AXAXAX" },

{ NULL,0,0,0,0,0,0,ML2+12,100,25,25,50,3,3,2,12,10,0,50,500,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HUNGRY|SWIMMING|EDIBLE,0,'e'|CLR(GREY),"elephant","trunk steak","AX" },

{ NULL,0,0,0,0,0,0,ML2+13,50,20,5,20,6,3,2,4,10,0,40,500,0,-1,-1,COMMON,M_TALK_HORSE,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HUNGRY|SWIMMING|EDIBLE,0,'h'|CLR(BROWN),"horse","steaming horsemeat","AX" },

{ NULL,0,0,0,0,0,0,ML3+0,35,15,5,30,4,1,3,4,50,0,75,50,50,RINGID+4,-1,COMMON,M_TALK_STUPID,M_MOVE_FLUTTER,M_MELEE_FIRE,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|GREEDY,pow2(FLAME),'s'|CLR(LIGHT_RED),"salamander","salamander scales","AXAX" },

{ NULL,0,0,0,0,0,0,ML3+1,100,10,10,20,5,2,3,8,50,0,50,10,50,RINGID+3,-1,COMMON,M_TALK_STUPID,M_MOVE_NORMAL,M_MELEE_NORMAL,M_STRIKE_BLIND,M_NO_OP,MOBILE|HOSTILE|HUNGRY|GREEDY,0,'C'|CLR(GREEN),"catoblepas","catoblepas' eyes","AXBX" },

{ NULL,0,0,0,0,0,0,ML3+2,15,18,15,15,3,3,3,4,0,2,80,25,50,STICKID+10,-1,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_COLD,M_NO_OP,M_SP_DEMON,MOBILE|HOSTILE,pow2(COLD)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'f'|CLR(LIGHT_BLUE),"lesser frost demon","lesser frost demon's heart","A?A?B?" },

{ NULL,0,0,0,0,0,0,ML3+3,10,20,0,50,5,1,3,20,0,0,60,10,0,-1,-1,COMMON,M_NO_OP,M_MOVE_FOLLOW,M_MELEE_NORMAL,M_NO_OP,M_SP_ACID_CLOUD,MOBILE|FLYING,pow2(POISON)|pow2(SLEEP),'a'|CLR(YELLOW),"acid cloud","acid pool","AX" },

{ NULL,0,0,0,0,0,0,ML3+4,1,20,0,0,5,5,2,10,100,0,90,10,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_SPIRIT,M_MELEE_SPIRIT,M_NO_OP,M_SP_SURPRISE,MOBILE|HOSTILE|FLYING|INTANGIBLE|M_INVISIBLE,pow2(NORMAL_DAMAGE)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'p'|CLR(GREY),"phantom","hardly anything at all","AX" },

{ NULL,0,0,0,0,0,0,ML3+5,32,18,10,32,5,20,3,5,100,3,500,100,0,-1,WEAPONID+36,UNIQUE_MADE,M_TALK_GREEDY,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_NO_OP,MOBILE|HOSTILE|GREEDY,0,'K'|CLR(LIGHT_GREEN),"The Goblin King","The Head of the Goblin King","A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML3+6,42,16,10,10,8,4,3,3,0,0,75,500,1,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|FLYING|EDIBLE,pow2(FEAR)|pow2(SLEEP),'P'|CLR(PURPLE),"pterodactyl","pterodactyl patee","AH" },

{ NULL,0,0,0,0,0,0,ML3+7,25,10,10,10,5,5,3,6,0,2,40,500,-1,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_SP_SPELL,MOBILE|HOSTILE|GREEDY,0,'G'|CLR(GREEN),"goblin shaman","dead goblin shaman","AXBX" },

{ NULL,0,0,0,0,0,0,ML3+8,60,20,10,25,5,1,3,3,0,0,50,50,-1,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|SWIMMING|EDIBLE,0,'l'|CLR(YELLOW),"lion","lion souflee","AXAX" },

{ NULL,0,0,0,0,0,0,ML3+9,30,15,10,15,5,1,3,5,0,2,75,50,-1,-1,WEAPONID+27,COMMON,M_TALK_GREEDY,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_NO_OP,MOBILE|HOSTILE|GREEDY,0,'b'|CLR(RED),"brigand","dead brigand","AXAXBX" },

{ NULL,0,0,0,0,0,0,ML3+10,70,25,20,40,3,1,3,10,80,0,55,500,-1,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_ANIMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HUNGRY|SWIMMING|EDIBLE,pow2(FEAR),'b'|CLR(BROWN),"bear","bear's sirloin tips","AXAXBX" },

{ NULL,0,0,0,0,0,0,ML3+11,10,25,10,20,3,1,3,3,40,0,45,30,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_NORMAL,M_MELEE_POISON,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|POISONOUS,0,'m'|CLR(RED),"mamba","mamba filet","AXAX" },

{ NULL,0,0,0,0,0,0,ML3+12,40,15,10,30,3,1,3,7,0,1,40,20,0,-1,-1,COMMON,M_NO_OP,M_MOVE_NORMAL,M_MELEE_POISON,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|ONLYSWIM|POISONOUS,pow2(POISON),'M'|CLR(BLUE),"man o' war","deliquescing tentacles","AXAX" },

{ NULL,0,0,0,0,0,0,ML3+13,40,5,10,10,5,2,3,5,0,1,100,20,0,-1,-1,COMMON,M_TALK_MAN,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_SP_WERE,MOBILE,0,'@'|CLR(RED),"were-human","dead were-human","AXBX" },

{ NULL,0,0,0,0,0,0,ML3+14,4,0,0,1,5,2,3,5,0,1,50,20,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_SPIRIT,M_MELEE_SPIRIT,M_NO_OP,M_NO_OP,MOBILE|HOSTILE,pow2(COLD)|pow2(ELECTRICITY)|pow2(POISON)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(OTHER_MAGIC)|pow2(THEFT)|pow2(GAZE)|pow2(INFECTION),'T'|CLR(GREY),"thought-form","a velleity","ACACACACAC" },

{ NULL,0,0,0,0,0,0,ML4+0,100,15,12,25,6,2,4,6,25,2,150,300,20,STICKID+11,-1,COMMON,M_TALK_HUNGRY,M_MOVE_NORMAL,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_NO_OP,MOBILE|HOSTILE|HUNGRY|FLYING,0,'M'|CLR(YELLOW),"manticore","manticore spikes","AXAX" },

{ NULL,0,0,0,0,0,0,ML4+1,50,12,10,10,10,10,4,2,50,0,100,300,10,POTIONID+6,-1,COMMON,M_TALK_HUNGRY,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY,0,'T'|CLR(BROWN),"tasmanian devil","dead tasmanian devil","AXAXAXAX" },

{ NULL,0,0,0,0,0,0,ML4+2,100,15,15,50,5,2,4,7,100,0,100,100,0,-1,-1,COMMON,M_TALK_ROBOT,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_SP_POISON_CLOUD,MOBILE|HOSTILE,pow2(ELECTRICITY)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'a'|CLR(GREY),"automatum minor","automatum minor battery","ACBC" },

{ NULL,0,0,0,0,0,0,ML4+3,75,30,10,15,5,1,4,12,75,0,125,50,20,POTIONID+17,-1,COMMON,M_TALK_SILENT,M_MOVE_NORMAL,M_MELEE_DISEASE,M_NO_OP,M_SP_SURPRISE,MOBILE|HOSTILE|HUNGRY|M_INVISIBLE|SWIMMING,pow2(FLAME)|pow2(ELECTRICITY)|pow2(POISON),'s'|CLR(GREEN),"denebian slime devil","denebian slime","AL" },
  
{ NULL,0,0,0,0,0,0,ML4+4,50,18,12,25,5,1,4,3,75,0,125,500,0,-1,-1,COMMON,M_TALK_BURBLE,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|FLYING|EDIBLE,pow2(POISON),'j'|CLR(PURPLE),"jub-jub bird","jube-jubes","AHAH" },

{ NULL,0,0,0,0,0,0,ML4+5,50,15,5,20,4,1,4,7,0,0,150,500,0,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_NORMAL,M_MELEE_POISON,M_NO_OP,M_SP_SURPRISE,MOBILE|HOSTILE|HUNGRY|M_INVISIBLE|POISONOUS,pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'h'|CLR(GREY),"haunt","dessicated corpse","ACAC" },

{ NULL,0,0,0,0,0,0,ML4+6,50,20,10,10,4,4,4,5,0,1,150,1,200,-1,-1,COMMON,M_TALK_DEMONLOVER,M_MOVE_SMART,M_NO_OP,M_NO_OP,M_SP_DEMONLOVER,MOBILE|NEEDY|POISONOUS,pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'!'|CLR(RED),"incubus/succubus","(null)","(null)" },

{ NULL,0,0,0,0,0,0,ML4+7,50,0,10,0,4,4,4,6,0,0,50,1,0,-1,-1,COMMON,M_TALK_SEDUCTOR,M_MOVE_SMART,M_NO_OP,M_NO_OP,M_SP_SEDUCTOR,MOBILE|NEEDY,0,'!'|CLR(RED),"satyr or nymph","(null)","(null)" },

{ NULL,0,0,0,0,0,0,ML4+8,80,25,20,30,4,1,4,8,50,0,100,300,100,-1,-1,COMMON,M_NO_OP,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|ONLYSWIM,0,'c'|CLR(GREEN),"giant crocodile","crocodile hide","ALALBX" },

{ NULL,0,0,0,0,0,0,ML4+9,40,30,0,10,4,4,4,12,0,0,120,30,50,POTIONID+5,-1,COMMON,M_TALK_STUPID,M_MOVE_NORMAL,M_MELEE_SLEEP,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY,pow2(FEAR)|pow2(SLEEP),'t'|CLR(BROWN),"torpor beast","a valium gland","AXBX" },

{ NULL,0,0,0,0,0,0,ML4+10,40,20,10,15,8,8,4,2,0,0,120,300,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_LEASH,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE,pow2(FEAR)|pow2(SLEEP),'d'|CLR(BROWN),"doberman death-hound","dead doberman death-hound","LXLXLX" },

{ NULL,0,0,0,0,0,0,ML4+11,40,10,10,10,8,8,4,1,0,0,100,0,0,-1,-1,COMMON,M_NO_OP,M_MOVE_SPIRIT,M_MELEE_COLD,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|INTANGIBLE,pow2(FLAME)|pow2(FEAR)|pow2(SLEEP),'F'|CLR(GREY),"astral fuzzy","nothing much","AX" },

{ NULL,0,0,0,0,0,0,ML4+12,30,40,40,20,8,8,4,5,0,2,120,0,0,-1,-1,COMMON,M_TALK_SERVANT,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_SP_SERVANT,MOBILE,pow2(FEAR)|pow2(SLEEP),'l'|CLR(BLUE),"servant of law","dead servant","L?R?" },

{ NULL,0,0,0,0,0,0,ML4+13,40,25,20,10,8,8,4,5,0,2,120,500,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_SP_SERVANT,MOBILE,pow2(FEAR)|pow2(SLEEP),'c'|CLR(RED),"servant of chaos","dead servant","AXAXAXAX?" },

{ NULL,0,0,0,0,0,0,ML4+14,40,15,0,10,3,0,4,10,0,0,50,1,0,-1,-1,COMMON,M_NO_OP,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_SP_SWARM,MOBILE|HOSTILE|FLYING,pow2(NORMAL_DAMAGE)|pow2(FEAR)|pow2(SLEEP),'s'|CLR(YELLOW),"swarm","dead swarm members","AX" },

{ NULL,0,0,0,0,0,0,ML4+15,40,10,20,10,8,8,4,4,0,2,100,50,0,-1,-1,COMMON,M_TALK_SCREAM,M_MOVE_NORMAL,M_MELEE_SPIRIT,M_STRIKE_SONIC,M_NO_OP,MOBILE|HOSTILE|FLYING,pow2(FEAR)|pow2(SLEEP),'b'|CLR(GREY),"ban sidhe","dead ban sidhe","LX" },

{ NULL,0,0,0,0,0,0,ML4+16,50,20,20,20,3,1,4,6,60,3,100,1,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_SPIRIT,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|INTANGIBLE,pow2(NORMAL_DAMAGE),'e'|CLR(GREEN),"etheric grue","dead etheric grue","LHAHLH" },

{ NULL,0,0,0,0,0,0,ML4+17,40,20,13,30,8,4,4,5,0,1,100,500,100,-1,-1,COMMON,M_TALK_NINJA,M_MOVE_NORMAL,M_MELEE_POISON,M_STRIKE_MISSILE,M_SP_SURPRISE,MOBILE|HOSTILE|M_INVISIBLE,pow2(POISON)|pow2(SLEEP),'n'|CLR(GREY),"ninja (genin)","dead ninja","A?A?R?R" },

{ NULL,0,0,0,0,0,0,ML5+0,50,20,15,40,10,2,5,3,90,4,180,500,50,RINGID+4,-1,COMMON,M_TALK_GREEDY,M_MOVE_NORMAL,M_MELEE_DRAGON,M_STRIKE_FBOLT,M_NO_OP,MOBILE|HOSTILE|HUNGRY|GREEDY|FLYING|EDIBLE,pow2(FLAME),'d'|CLR(LIGHT_RED),"dragonette","dragon steak","AXAXBXBX" },

{ NULL,0,0,0,0,0,0,ML5+1,50,15,10,40,10,2,5,12,40,0,150,100,200,STICKID+3,-1,COMMON,M_TALK_STUPID,M_MOVE_FLUTTER,M_MELEE_ELEC,M_STRIKE_LBALL,M_NO_OP,MOBILE|HOSTILE,pow2(ELECTRICITY),'t'|CLR(LIGHT_BLUE),"tesla monster","tesla monster whip","AXAX" },

{ NULL,0,0,0,0,0,0,ML5+2,100,20,12,20,4,2,5,4,80,2,150,100,150,RINGID+6,-1,COMMON,M_TALK_GREEDY,M_MOVE_NORMAL,M_MELEE_POISON,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|GREEDY|FLYING|POISONOUS,pow2(FLAME),'W'|CLR(LIGHT_RED),"wyvern","wyvern's sting","AXAXBXBX" },

{ NULL,0,0,0,0,0,0,ML5+3,50,15,10,20,10,2,5,2,50,0,250,400,0,-1,-1,COMMON,M_TALK_HUNGRY,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_SP_FLUTTER,MOBILE|HOSTILE|HUNGRY|FLYING,pow2(FEAR),'c'|CLR(BROWN),"radeligian cateagle","dead radeligian cateagle","AXAXAXAXAX" },

{ NULL,0,0,0,0,0,0,ML5+4,75,20,20,20,5,5,5,3,50,3,200,50,200,STICKID+4,-1,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_COLD,M_STRIKE_SNOWBALL,M_SP_DEMON,MOBILE|HOSTILE|POISONOUS,pow2(COLD)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'f'|CLR(WHITE),"frost demon","frost demon's heart","A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML5+5,75,20,20,20,5,2,5,6,50,0,200,10,200,CLOAKID+1,-1,COMMON,M_TALK_EVIL,M_MOVE_SPIRIT,M_MELEE_SPIRIT,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|FLYING,pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'S'|CLR(GREY),"spectre","spectre's veil","A?A?A?" },

{ NULL,0,0,0,0,0,0,ML5+6,50,12,13,10,5,5,5,5,0,4,205,10,500,-1,SCROLLID+1,COMMON,M_TALK_EVIL,M_MOVE_SCAREDY,M_MELEE_NORMAL,M_NO_OP,M_SP_SPELL,MOBILE|HOSTILE,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY),'n'|CLR(RED),"necromancer","dead necromancer","A?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML5+7,40,18,18,20,5,5,5,7,50,2,175,2,10,SCROLLID+22,-1,COMMON,M_TALK_EVIL,M_MOVE_SPIRIT,M_MELEE_SPIRIT,M_NO_OP,M_SP_BLACKOUT,MOBILE|HOSTILE|INTANGIBLE,pow2(NORMAL_DAMAGE),'S'|CLR(GREY),"shadow spirit","shadowstuff","ACACAC" },

{ NULL,0,0,0,0,0,0,ML5+8,80,22,8,30,3,3,5,12,50,2,275,20,0,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_GRAPPLE,M_NO_OP,M_SP_BOG,MOBILE|HOSTILE|ONLYSWIM|POISONOUS,pow2(NORMAL_DAMAGE),'B'|CLR(GREEN),"bog thing","swamp slime","AXAXB?B?" },

{ NULL,0,0,0,0,0,0,ML5+9,40,25,0,0,20,3,5,6,0,2,175,20,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_SPIRIT,M_MELEE_SPIRIT,M_NO_OP,M_SP_AV,MOBILE|HOSTILE|INTANGIBLE,pow2(NORMAL_DAMAGE)|pow2(FEAR)|pow2(SLEEP),'V'|CLR(GREY),"astral vampire","dead astral vampire","R?R?R?" },

{ NULL,0,0,0,0,0,0,ML5+10,100,40,0,60,3,1,5,10,75,0,175,2000,0,-1,-1,COMMON,M_NO_OP,M_MOVE_NORMAL,M_MELEE_FIRE,M_NO_OP,M_SP_LW,MOBILE|HOSTILE|SWIMMING|POISONOUS,pow2(FLAME),'W'|CLR(LIGHT_RED),"lava worm","dead lava worm","AX" },

{ NULL,0,0,0,0,0,0,ML5+11,1,0,0,0,30,30,5,20,0,0,100,0,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_RANDOM,M_NO_OP,M_NO_OP,M_SP_MB,MOBILE|HOSTILE|INTANGIBLE,0,'m'|CLR(PURPLE),"manaburst","feeling of warmth","BX" },

{ NULL,0,0,0,0,0,0,ML5+12,120,25,20,20,6,6,5,4,0,1,150,2000,0,-1,WEAPONID+8,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_FIRE,M_MELEE_POISON,M_SP_DEMON,MOBILE|HOSTILE|POISONOUS,pow2(FLAME)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'d'|CLR(LIGHT_RED),"outer circle demon","dead outer circle demon","L?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML5+13,40,15,10,30,8,8,5,6,0,1,100,20,0,-1,-1,COMMON,M_NO_OP,M_MOVE_SMART,M_MELEE_SPIRIT,M_NO_OP,M_SP_MIRROR,MOBILE|HOSTILE,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY),'m'|CLR(GREY),"mirrorshade","some broken glass","AXAXAX" },

{ NULL,0,0,0,0,0,0,ML6+0,125,30,0,50,10,2,6,4,100,0,250,1,200,STICKID+7,-1,COMMON,M_TALK_SILENT,M_MOVE_NORMAL,M_MELEE_FIRE,M_STRIKE_FBALL,M_NO_OP,MOBILE|HOSTILE|FLYING,pow2(FLAME)|pow2(POISON)|pow2(ACID)|pow2(SLEEP),'F'|CLRS(WHITE,RED),"fire elemental","essence of fire elemental","AXAXAXRXRX" },

{ NULL,0,0,0,0,0,0,ML6+1,125,25,0,20,10,2,6,2,100,0,250,1,200,CLOAKID+2,-1,COMMON,M_TALK_SILENT,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_SP_WHIRL,MOBILE|HOSTILE|FLYING|INTANGIBLE,pow2(ELECTRICITY)|pow2(POISON)|pow2(ACID)|pow2(SLEEP),'A'|CLRS(WHITE,BLUE),"air elemental","essence of air elemental","AXAXAXAXBXBX" },

{ NULL,0,0,0,0,0,0,ML6+2,100,15,10,30,5,1,6,6,100,0,250,1,200,STICKID+14,-1,COMMON,M_TALK_SILENT,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|ONLYSWIM,pow2(COLD)|pow2(SLEEP),'W'|CLRS(WHITE,BLUE),"water elemental","essence of water elemental","AXAXBXBX" },

{ NULL,0,0,0,0,0,0,ML6+3,200,20,25,100,5,1,6,15,100,0,250,1,200,CLOAKID+4,-1,COMMON,M_TALK_SILENT,M_MOVE_SPIRIT,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE,pow2(POISON)|pow2(SLEEP),'E'|CLRS(WHITE,BROWN),"earth elemental","essence of earth elemental","AXBX" },

{ NULL,0,0,0,0,0,0,ML6+4,100,20,20,50,3,1,6,2,50,1,250,1000,100,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE,pow2(SLEEP),'b'|CLRS(YELLOW,BROWN),"bandersnatch","bandersnatch hide","AXAXAXBX" },

{ NULL,0,0,0,0,0,0,ML6+5,100,15,20,50,5,1,6,3,50,5,300,100,1000,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_SPIRIT,M_NO_OP,M_SP_SPELL,MOBILE|HOSTILE,pow2(FLAME)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'L'|CLRS(BLACK,WHITE),"lich","lich's skeleton","A?A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML6+6,100,20,20,30,5,3,6,5,30,3,300,10,500,-1,WEAPONID+21,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_SP_SPELL,MOBILE|HOSTILE|SWIMMING,pow2(SLEEP),'T'|CLRS(LIGHT_GREEN,BLUE),"triton","dead triton","A?A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML6+7,100,0,20,0,10,3,6,3,0,5,200,10,0,-1,THINGID+2,COMMON,M_TALK_THIEF,M_MOVE_SMART,M_NO_OP,M_NO_OP,M_SP_THIEF,MOBILE|HOSTILE|GREEDY|SWIMMING,0,'@'|CLR(RED),"human","dead master thief","A?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML6+8,200,50,50,80,3,1,6,8,0,0,300,100000,0,-1,-1,COMMON,M_TALK_ANIMAL,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|SWIMMING,pow2(FEAR)|pow2(SLEEP),'T'|CLRS(GREEN,BROWN),"triceratops","dead triceratops","LX" },

{ NULL,0,0,0,0,0,0,ML6+9,100,20,20,20,10,2,6,3,50,4,250,10,0,-1,WEAPONID+5,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_FBOLT,M_SP_ILLUSION,MOBILE|HOSTILE,pow2(FLAME)|pow2(FEAR)|pow2(SLEEP),'R'|CLRS(YELLOW,WHITE),"rakshasa","dead rakshasa","L?L?R?R?" },

{ NULL,0,0,0,0,0,0,ML6+10,100,40,20,30,5,1,6,7,90,4,250,10,500,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_NORMAL,M_MELEE_POISON,M_STRIKE_FBALL,M_SP_DEMON,MOBILE|HOSTILE|SWIMMING,pow2(FLAME)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'S'|CLRS(GREEN,RED),"demon serpent","demon serpent's jewel","L?L?" },

{ NULL,0,0,0,0,0,0,ML6+11,120,30,20,20,10,10,6,4,0,1,250,10,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_SP_ANGEL,MOBILE|FLYING,pow2(FEAR)|pow2(SLEEP),'a'|CLRS(YELLOW,WHITE),"angel","angel's gown","L?R?RX" },

{ NULL,0,0,0,0,0,0,ML6+12,100,25,15,40,9,4,6,4,0,1,200,100,100,-1,-1,COMMON,M_TALK_NINJA,M_MOVE_NORMAL,M_MELEE_POISON,M_STRIKE_MISSILE,M_SP_SURPRISE,MOBILE|HOSTILE|M_INVISIBLE,pow2(POISON)|pow2(SLEEP),'n'|CLRS(BLACK,WHITE),"ninja (chunin)","dead ninja","A?A?R?R?R" },

{ NULL,0,0,0,0,0,0,ML7+0,300,30,5,120,3,3,7,15,100,0,400,500,50,RINGID+2,-1,COMMON,M_TALK_STUPID,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_SP_HUGE,MOBILE|HOSTILE|SWIMMING,pow2(ELECTRICITY),'B'|CLRS(BLACK,BROWN),"behemoth","behemoth's gonads","AHBXBX" },

{ NULL,0,0,0,0,0,0,ML7+1,250,40,20,20,10,5,7,5,0,0,500,100,2000,-1,WEAPONID+24,COMMON,M_TALK_EVIL,M_MOVE_SPIRIT,M_MELEE_SPIRIT,M_NO_OP,M_SP_SPELL,MOBILE|HOSTILE|FLYING,pow2(COLD)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'N'|CLRS(BLACK,WHITE),"nazgul","nazgul's husk","A?A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML7+2,100,100,30,50,10,3,7,2,50,0,400,100,500,RINGID+6,-1,COMMON,M_TALK_SILENT,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_MOVE_SCAREDY,MOBILE|SWIMMING,pow2(POISON)|pow2(FEAR),'U'|CLRS(BLACK,WHITE),"unicorn","unicorn's horn","ACACB?B?B?B?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML7+3,150,30,20,50,10,3,7,3,50,0,400,100,0,-1,-1,COMMON,M_NO_OP,M_MOVE_NORMAL,M_MELEE_DISEASE,M_NO_OP,M_SP_SURPRISE,MOBILE|HOSTILE|HUNGRY|M_INVISIBLE|SWIMMING,pow2(FEAR),'r'|CLRS(BLACK,BROWN),"rodent of unusual size","dead R.O.U.S.","AXAXAX" },

{ NULL,0,0,0,0,0,0,ML7+4,100,20,25,30,10,2,7,5,50,3,400,0,0,-1,-1,COMMON,M_NO_OP,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_SP_ILLUSION,MOBILE|HOSTILE|GREEDY,pow2(OTHER_MAGIC),'F'|CLRS(BLACK,WHITE),"illusory fiend","not much of anything","AXAXAX" },

{ NULL,0,0,0,0,0,0,ML7+5,250,40,30,20,10,1,7,5,100,8,500,1500,2000,-1,WEAPONID+34,UNIQUE_MADE,M_TALK_EVIL,M_MOVE_NORMAL,M_MELEE_NORMAL,M_MELEE_COLD,M_SP_WYRM,MOBILE|HOSTILE|SWIMMING,pow2(COLD)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'W'|CLRS(GREY,RED),"Great Wyrm","The head of the Great Wyrm","AXAXAX" },

{ NULL,0,0,0,0,0,0,ML7+6,150,30,30,20,10,1,7,1,100,8,350,1500,0,-1,WEAPONID+33,COMMON,M_NO_OP,M_MOVE_SMART,M_MELEE_FIRE,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|FLYING,pow2(FLAME)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'F'|CLRS(GREY,RED),"flame devil","dead flame devil","A?A?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML7+7,150,50,10,20,1,0,7,1,100,4,400,1500,0,-1,-1,COMMON,M_NO_OP,M_NO_OP,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,HOSTILE|HUNGRY,0,OPEN_DOOR,"lurker at the threshold","dead lurker","L?L?L?" },

{ NULL,0,0,0,0,0,0,ML7+8,50,30,30,20,10,1,7,4,0,2,450,500,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_NORMAL,M_MELEE_SLEEP,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|FLYING,pow2(NORMAL_DAMAGE)|pow2(SLEEP),'S'|CLRS(YELLOW,BROWN),"sandman","mound of sand","AX" },

{ NULL,0,0,0,0,0,0,ML7+9,50,40,10,10,10,10,7,2,0,5,350,50,0,-1,-1,COMMON,M_NO_OP,M_MOVE_SMART,M_MELEE_SLEEP,M_NO_OP,M_SP_MIRROR,MOBILE|HOSTILE|FLYING,pow2(OTHER_MAGIC),'m'|CLRS(RED,WHITE),"mirror master","shards of glass","AXAX" },

{ NULL,0,0,0,0,0,0,ML7+10,150,30,30,20,10,1,7,4,90,2,450,500,0,-1,-1,COMMON,M_TALK_HUNGRY,M_MOVE_NORMAL,M_MELEE_POISON,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|FLYING,pow2(POISON)|pow2(FEAR),'G'|CLRS(GREY,GREEN),"elder etheric grue","dead elder etheric grue","AXAXAXL?B?B?" },

{ NULL,0,0,0,0,0,0,ML7+11,150,50,40,60,3,3,7,8,90,6,380,500,0,-1,-1,COMMON,M_TALK_HUNGRY,M_MOVE_NORMAL,M_MELEE_POISON,M_NO_OP,M_SP_ACID_CLOUD,MOBILE|HOSTILE|HUNGRY|SWIMMING,pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'S'|CLRS(GREY,GREEN),"loathly serpent","dead loathly serpent","AXAXAXL?B?B?" },
 
{ NULL,0,0,0,0,0,0,ML7+12,100,10,30,20,8,3,7,3,20,2,460,500,0,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_SCAREDY,M_MELEE_SPIRIT,M_NO_OP,M_SP_RAISE,MOBILE|HOSTILE,pow2(FEAR),'Z'|CLRS(BLACK,WHITE),"zombie overlord","extremely dead zombie overlord","L?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML7+13,50,30,30,2,13,1,7,1,30,0,250,50,0,-1,-1,COMMON,M_TALK_STUPID,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_MOVE_FLUTTER,MOBILE|HOSTILE|FLYING,0,'r'|CLRS(GREY,BROWN),"ricochet","dead ricochet","L?" },

{ NULL,0,0,0,0,0,0,ML7+14,240,35,30,40,8,8,7,3,0,3,300,3000,0,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_FIRE,M_MELEE_SLEEP,M_SP_DEMON,MOBILE|HOSTILE|POISONOUS,pow2(FLAME)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'D'|CLRS(GREY,RED),"inner circle demon","dead inner circle demon","L?L?R?R?R?RXRXRX" },

{ NULL,0,0,0,0,0,0,ML8+0,1,0,100,0,6,2,8,3,0,0,50,100,0,-1,-1,COMMON,M_TALK_GF,M_MOVE_RANDOM,M_NO_OP,M_NO_OP,M_NO_OP,MOBILE|FLYING,pow2(FLAME)|pow2(COLD)|pow2(SLEEP),'f'|CLRS(YELLOW,WHITE),"fairy","good fairy dust","B?" },

{ NULL,0,0,0,0,0,0,ML8+1,100,50,50,20,10,10,8,3,0,0,500,3,0,-1,-1,COMMON,M_TALK_EF,M_MOVE_RANDOM,M_NO_OP,M_NO_OP,M_NO_OP,MOBILE|FLYING|POISONOUS,pow2(FLAME)|pow2(COLD)|pow2(SLEEP),'f'|CLRS(YELLOW,WHITE),"fairy","evil fairy dust","B?" },

{ NULL,0,0,0,0,0,0,ML8+2,500,30,50,100,5,2,8,3,100,0,500,1000,0,-1,WEAPONID+23,COMMON,M_TALK_ROBOT,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_LBALL,M_SP_POISON_CLOUD,MOBILE|HOSTILE,pow2(ELECTRICITY)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'A'|CLRS(GREY,WHITE),"automatum major","automatum major components","A?A?R?R?" },

{ NULL,0,0,0,0,0,0,ML8+3,500,50,30,75,20,1,8,5,100,7,750,500,1000,ARMORID+12,-1,COMMON,M_TALK_GREEDY,M_MOVE_NORMAL,M_MELEE_DRAGON,M_STRIKE_FBOLT,M_NO_OP,MOBILE|HOSTILE|HUNGRY|GREEDY|FLYING,pow2(FLAME)|pow2(POISON)|pow2(SLEEP),'D'|CLRS(GREY,RED),"dragon","dragon scales","A?A?A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML8+4,500,40,25,100,5,1,8,2,75,2,600,500,1000,WEAPONID+31,-1,COMMON,M_TALK_BURBLE,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY,pow2(POISON)|pow2(SLEEP),'J'|CLRS(BROWN,RED),"jabberwock","jabberwock's head","A?A?A?A?A?" },

{ NULL,0,0,0,0,0,0,ML8+5,350,40,40,40,10,10,8,2,25,5,700,100,500,WEAPONID+24,-1,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_COLD,M_STRIKE_SNOWBALL,M_SP_DEMON,MOBILE|HOSTILE|HUNGRY,pow2(COLD)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'F'|CLRS(LIGHT_BLUE,WHITE),"frost demon lord","frost demon lord's sigil","A?A?A?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML8+6,350,35,30,40,10,4,8,2,25,0,700,100,100,-1,-1,COMMON,M_NO_OP,M_MOVE_NORMAL,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|HUNGRY|ONLYSWIM,pow2(COLD)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'T'|CLRS(YELLOW,BLUE),"tigershark","tigershark pelt","AXAXAXAX" },

{ NULL,0,0,0,0,0,0,ML8+7,250,40,25,50,10,4,8,3,0,2,800,100,100,-1,-1,COMMON,M_TALK_NINJA,M_MOVE_NORMAL,M_MELEE_POISON,M_STRIKE_MISSILE,M_SP_SURPRISE,MOBILE|HOSTILE|M_INVISIBLE,pow2(POISON)|pow2(SLEEP),'n'|CLRS(BLACK,WHITE),"ninja (jonin)","dead ninja","A?A?R?R?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML8+8,250,30,40,30,10,4,8,3,0,3,500,10,75,RINGID+0,-1,COMMON,M_TALK_EVIL,M_MOVE_SPIRIT,M_MELEE_POISON,M_SP_SPELL,M_SP_BLACKOUT,MOBILE|HOSTILE|INTANGIBLE|M_INVISIBLE,pow2(NORMAL_DAMAGE)|pow2(POISON)|pow2(SLEEP),'S'|CLRS(BLACK,WHITE),"shadow slayer","shadow matrix","A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML8+9,250,30,30,30,10,4,8,6,0,3,700,10,75,-1,WEAPONID+13,COMMON,M_TALK_SILENT,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_SP_SPELL,MOBILE|HOSTILE,pow2(SLEEP),'@'|CLR(RED),"militant priest","dead militant priest","A?A?A?B?B?" },

{ NULL,0,0,0,0,0,0,ML8+10,150,25,40,30,10,4,8,5,0,3,500,10,75,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_SMART,M_MELEE_SLEEP,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|M_INVISIBLE,pow2(SLEEP),'C'|CLRS(GREY,BROWN),"coma beast","dead coma beast","AXAXAXBX" },

{ NULL,0,0,0,0,0,0,ML8+11,250,50,40,30,10,10,8,3,0,3,500,10,0,-1,-1,COMMON,M_TALK_SILENT,M_MOVE_SMART,M_MELEE_NORMAL,M_STRIKE_FBOLT,M_SP_ANGEL,MOBILE|FLYING,pow2(FLAME)|pow2(FEAR)|pow2(SLEEP),'A'|CLRS(YELLOW,WHITE),"high angel","high angel's robes","L?R?RXRX" },

{ NULL,0,0,0,0,0,0,ML9+0,750,80,50,200,10,2,9,8,90,5,1000,500,2000,-1,WEAPONID+38,COMMON,M_TALK_GREEDY,M_MOVE_NORMAL,M_MELEE_NORMAL,M_STRIKE_MISSILE,M_SP_HUGE,MOBILE|HOSTILE|HUNGRY|GREEDY,pow2(COLD)|pow2(FEAR),'J'|CLRS(GREY,BROWN),"jotun","jotun's head","AHAHB?" },

{ NULL,0,0,0,0,0,0,ML9+1,1000,50,30,40,20,2,9,4,40,0,750,100,200,CLOAKID+2,-1,COMMON,M_TALK_SILENT,M_MOVE_FLUTTER,M_MELEE_NORMAL,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|FLYING|M_INVISIBLE,pow2(ELECTRICITY),'i'|CLRS(BLACK,WHITE),"invisible slayer","dead slayer","AXAXAX" },

{ NULL,0,0,0,0,0,0,ML9+2,700,50,32,50,5,2,9,3,80,4,1000,100,50,RINGID+6,-1,COMMON,M_TALK_GREEDY,M_MOVE_NORMAL,M_MELEE_POISON,M_NO_OP,M_NO_OP,MOBILE|HOSTILE|GREEDY|FLYING,pow2(FLAME)|pow2(POISON),'W'|CLRS(GREEN,RED),"king wyvern","king wyvern's sting","AXAXAXBXBX" },

{ NULL,0,0,0,0,0,0,ML9+3,500,30,50,30,10,2,9,4,50,0,500,40,500,WEAPONID+33,-1,COMMON,M_NO_OP,M_MOVE_RANDOM,M_MELEE_NORMAL,M_NO_OP,M_SP_EXPLODE,MOBILE|HOSTILE|HUNGRY|FLYING|POISONOUS,pow2(FLAME),'d'|CLRS(BLACK,WHITE),"deathstar","deathstar's eye","BX" },

{ NULL,0,0,0,0,0,0,ML9+4,250,20,25,25,5,5,9,4,50,4,1500,50,3000,-1,-1,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_NORMAL,M_SP_SPELL,M_SP_SPELL,MOBILE,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY),'T'|CLRS(YELLOW,WHITE),"high thaumaturgist","dead thaumaturgist","A?B?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML9+5,750,70,50,50,10,1,9,2,50,0,1000,1,200,CLOAKID+1,-1,COMMON,M_TALK_EVIL,M_MOVE_SPIRIT,M_MELEE_SPIRIT,M_MELEE_SPIRIT,M_SP_SURPRISE,MOBILE|HOSTILE|FLYING|M_INVISIBLE,pow2(POISON)|pow2(FEAR)|pow2(SLEEP),'V'|CLRS(BLACK,RED),"vampire lord","vampire dust","A?A?A?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML9+6,1000,100,50,50,20,20,9,2,100,5,1500,15,3000,-1,WEAPONID+34,COMMON,M_TALK_SILENT,M_MOVE_SMART,M_MELEE_NORMAL,M_MELEE_SLEEP,M_SP_ANGEL,MOBILE|FLYING,pow2(FLAME)|pow2(COLD)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP)|pow2(OTHER_MAGIC),'A'|CLRS(YELLOW,WHITE),"archangel","archangel's diadem","L?R?R?R?R?R?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML9+7,800,80,40,80,12,12,9,2,0,5,1200,4500,3000,-1,WEAPONID+24,COMMON,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_NORMAL,M_MELEE_NORMAL,M_SP_DEMON,MOBILE|HOSTILE|FLYING|POISONOUS,pow2(FLAME)|pow2(POISON)|pow2(FEAR)|pow2(SLEEP)|pow2(OTHER_MAGIC),'D'|CLRS(BLACK,RED),"demon prince","dead demon prince","LLLCLHRLRCRHRLRCRH" },

{ NULL,0,0,0,0,0,0,ML10+0,100,10,10,1,100,100,100,10,0,0,0,0,1,-1,WEAPONID+39,UNIQUE_MADE,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_DEATH,M_NO_OP,M_SP_DEATH,MOBILE|HOSTILE,pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(OTHER_MAGIC),'D'|CLRS(BLACK,WHITE),"Death","No way can you be seeing this!","AX" },

{ NULL,0,0,0,0,0,0,ML10+1,1000,0,20,0,3,3,10,5,50,0,10000,1000,250,STICKID+13,-1,UNIQUE_MADE,M_TALK_SILENT,M_MOVE_RANDOM,M_NO_OP,M_NO_OP,M_SP_EATER,MOBILE,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY)|pow2(POISON)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(OTHER_MAGIC)|pow2(THEFT)|pow2(GAZE)|pow2(INFECTION),'E'|CLRS(BLACK,WHITE),"The Eater of Magic","The Heart of the Eater of Magic","B?B?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML10+2,500,50,50,50,5,3,10,5,50,0,10000,1000,2000,-1,WEAPONID+34,UNIQUE_MADE,M_TALK_LB,M_MOVE_SMART,M_MELEE_NORMAL,M_NO_OP,M_SP_LAWBRINGER,MOBILE,pow2(NORMAL_DAMAGE),'L'|CLRS(BRIGHT_WHITE,BLUE),"The LawBringer","The LawBringer's Crown","A?A?B?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML10+3,2000,100,100,100,10,1,10,1,100,10,10000,1000,2000,ARMORID+12,-1,UNIQUE_MADE,M_TALK_EVIL,M_MOVE_NORMAL,M_MELEE_DRAGON,M_STRIKE_FBOLT,M_SP_DRAGONLORD,MOBILE|HOSTILE|FLYING,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY)|pow2(ACID),'D'|CLRS(BRIGHT_WHITE,RED),"The Dragon Lord","The Dragon Lord's Hide","A?A?A?A?A?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML10+4,3000,200,100,200,20,20,10,2,0,7,20000,1000,3000,-1,ARTIFACTID+23,UNIQUE_MADE,M_TALK_EVIL,M_MOVE_SPIRIT,M_MELEE_SPIRIT,M_MELEE_NORMAL,M_SP_DEMON,MOBILE|HOSTILE|INTANGIBLE|M_INVISIBLE,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY)|pow2(POISON)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(OTHER_MAGIC)|pow2(THEFT)|pow2(GAZE)|pow2(INFECTION),'D'|CLRS(GREY,RED),"The Demon Emperor","The Demon Emperor's Regalia","L?L?L?L?L?R?R?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML10+5,2000,200,100,200,5,1,10,12,0,0,5000,10000,1,-1,ARTIFACTID+4,UNIQUE_MADE,M_TALK_SILENT,M_MOVE_SPIRIT,M_MELEE_NORMAL,M_MELEE_NORMAL,M_SP_DE,MOBILE|INTANGIBLE,pow2(FLAME)|pow2(COLD)|pow2(POISON)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(OTHER_MAGIC)|pow2(THEFT)|pow2(GAZE)|pow2(INFECTION),'E'|CLRS(BROWN,WHITE),"The Elemental Lord of Earth","some dirt","A?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML10+6,1000,100,50,50,20,1,10,1,100,0,5000,0,1,-1,ARTIFACTID+3,UNIQUE_MADE,M_TALK_SILENT,M_MOVE_SPIRIT,M_MELEE_NORMAL,M_STRIKE_LBALL,M_SP_WHIRL,MOBILE|FLYING|INTANGIBLE|M_INVISIBLE,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY)|pow2(POISON)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(THEFT)|pow2(GAZE)|pow2(INFECTION),'A'|CLRS(LIGHT_BLUE,WHITE),"The Elemental Lord of Air","some air","A?A?A?A?A?A?A?A?A?B?" },

{ NULL,0,0,0,0,0,0,ML10+7,1500,100,100,100,5,1,10,5,100,0,5000,10,1,-1,ARTIFACTID+1,UNIQUE_MADE,M_TALK_SILENT,M_MOVE_NORMAL,M_MELEE_NORMAL,M_STRIKE_SNOWBALL,M_NO_OP,MOBILE|ONLYSWIM,pow2(COLD)|pow2(ELECTRICITY)|pow2(POISON)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(OTHER_MAGIC)|pow2(THEFT)|pow2(GAZE)|pow2(INFECTION),'W'|CLRS(BLUE,WHITE),"The Elemental Lord of Water","some water","A?A?A?B?B?B?" },

{ NULL,0,0,0,0,0,0,ML10+8,1500,200,100,300,10,1,10,3,100,0,5000,1000,1,-1,ARTIFACTID+2,UNIQUE_MADE,M_TALK_SILENT,M_MOVE_NORMAL,M_MELEE_FIRE,M_STRIKE_FBALL,M_NO_OP,MOBILE,pow2(FLAME)|pow2(ELECTRICITY)|pow2(POISON)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(OTHER_MAGIC)|pow2(THEFT)|pow2(GAZE)|pow2(INFECTION),'F'|CLRS(LIGHT_RED,WHITE),"The Elemental Lord of Fire","a spark","A?A?A?R?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML10+9,1000,200,200,200,20,20,10,2,0,10,10000,10000,1,-1,ARTIFACTID+0,UNIQUE_MADE,M_TALK_EVIL,M_MOVE_SMART,M_MELEE_MASTER,M_STRIKE_MASTER,M_SP_MASTER,MOBILE|FLYING|SWIMMING,pow2(NORMAL_DAMAGE)|pow2(COLD)|pow2(ELECTRICITY)|pow2(POISON)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(OTHER_MAGIC)|pow2(THEFT)|pow2(GAZE)|pow2(INFECTION),'M'|CLRS(PURPLE,WHITE),"The Elemental Master","A burning mound of bubbling mud","A?A?A?A?R?R?R?R?" },

{ NULL,0,0,0,0,0,0,ML10+10,1150,90,90,48,10,20,10,2,0,7,6000,40,40,-1,ARTIFACTID+25,UNIQUE_MADE,M_TALK_MAHARAJA,M_MOVE_SMART,M_MELEE_NORMAL,M_MELEE_NORMAL,M_SP_DEMON,MOBILE|HOSTILE,pow2(FLAME)|pow2(COLD)|pow2(ELECTRICITY)|pow2(ACID)|pow2(FEAR)|pow2(SLEEP)|pow2(NEGENERGY)|pow2(THEFT)|pow2(INFECTION),'D'|CLRS(GREY,RED),"The Maharaja","The Maharaja's Skull","L?L?B?B?R?R?R?" }

};
