// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_BrentMinimum_HeaderFile
#define _math_BrentMinimum_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class math_Function;



//! This class implements the Brent's method to find the minimum of <br>
//! a function of a single variable. <br>
//! No knowledge of the derivative is required. <br>
class math_BrentMinimum  {
public:

  DEFINE_STANDARD_ALLOC

  
//! This constructor should be used in a sub-class to initialize <br>
//! correctly all the fields of this class. <br>
  Standard_EXPORT   math_BrentMinimum(const Standard_Real TolX,const Standard_Integer NbIterations = 100,const Standard_Real ZEPS = 1.0e-12);
  
//! This constructor should be used in a sub-class to initialize <br>
//! correctly all the fields of this class. <br>
//! It has to be used if F(Bx) is known. <br>
  Standard_EXPORT   math_BrentMinimum(const Standard_Real TolX,const Standard_Real Fbx,const Standard_Integer NbIterations = 100,const Standard_Real ZEPS = 1.0e-12);
  
//! Given a bracketing triplet of abscissae Ax, Bx, Cx <br>
//! (such as Bx is between Ax and Cx, F(Bx) is <br>
//! less than both F(Bx) and F(Cx)) the Brent minimization is done <br>
//! on the function F. <br>
//! The tolerance required on F is given by Tolerance. <br>
//! The solution is found when : <br>
//!    abs(Xi - Xi-1) <= TolX * abs(Xi) + ZEPS; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
  Standard_EXPORT   math_BrentMinimum(math_Function& F,const Standard_Real Ax,const Standard_Real Bx,const Standard_Real Cx,const Standard_Real TolX,const Standard_Integer NbIterations = 100,const Standard_Real ZEPS = 1.0e-12);
  
//! Brent minimization is performed on function F from a given <br>
//! bracketing triplet of abscissas Ax, Bx, Cx (such that Bx is <br>
//! between Ax and Cx, F(Bx) is less than both F(Bx) and F(Cx)) <br>
//! Warning <br>
//! The initialization constructors must have been called <br>
//! before the call to the Perform method. <br>
  Standard_EXPORT     void Perform(math_Function& F,const Standard_Real Ax,const Standard_Real Bx,const Standard_Real Cx) ;
  
//! This method is called at the end of each iteration to check if the <br>
//! solution is found. <br>
//! It can be redefined in a sub-class to implement a specific test to <br>
//! stop the iterations. <br>
  Standard_EXPORT   virtual  Standard_Boolean IsSolutionReached(math_Function& F) ;
  //! Returns true if the computations are successful, otherwise returns false. <br>
        Standard_Boolean IsDone() const;
  //! returns the location value of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
        Standard_Real Location() const;
  //! returns the value of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
        Standard_Real Minimum() const;
  //! returns the number of iterations really done during the <br>
//! computation of the minimum. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
        Standard_Integer NbIterations() const;
  //! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
  Standard_EXPORT     void Dump(Standard_OStream& o) const;





protected:



Standard_Real a;
Standard_Real b;
Standard_Real x;
Standard_Real fx;
Standard_Real fv;
Standard_Real fw;
Standard_Real XTol;
Standard_Real EPSZ;


private:



Standard_Boolean Done;
Standard_Integer iter;
Standard_Integer Itermax;
Standard_Boolean myF;


};


#include <math_BrentMinimum.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
