// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESSolid_Loop_HeaderFile
#define _IGESSolid_Loop_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IGESSolid_Loop_HeaderFile
#include <Handle_IGESSolid_Loop.hxx>
#endif

#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_IGESData_HArray1OfIGESEntity_HeaderFile
#include <Handle_IGESData_HArray1OfIGESEntity.hxx>
#endif
#ifndef _Handle_IGESBasic_HArray1OfHArray1OfInteger_HeaderFile
#include <Handle_IGESBasic_HArray1OfHArray1OfInteger.hxx>
#endif
#ifndef _Handle_IGESBasic_HArray1OfHArray1OfIGESEntity_HeaderFile
#include <Handle_IGESBasic_HArray1OfHArray1OfIGESEntity.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IGESData_IGESEntity_HeaderFile
#include <Handle_IGESData_IGESEntity.hxx>
#endif
class TColStd_HArray1OfInteger;
class IGESData_HArray1OfIGESEntity;
class IGESBasic_HArray1OfHArray1OfInteger;
class IGESBasic_HArray1OfHArray1OfIGESEntity;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class IGESData_IGESEntity;


//! defines Loop, Type <508> Form Number <1> <br>
//!          in package IGESSolid <br>
//!          A Loop entity specifies a bound of a face. It represents <br>
//!          a connected collection of face boundaries, seams, and <br>
//!          poles of a single face. <br>
//! <br>
//!          From IGES-5.3, a Loop can be free with Form Number 0, <br>
//!          else it is a bound of a face (it is the default) <br>
class IGESSolid_Loop : public IGESData_IGESEntity {

public:

  
  Standard_EXPORT   IGESSolid_Loop();
  //! This method is used to set the fields of the class Loop <br>
//!       - types              : 0 = Edge; 1 = Vertex <br>
//!       - edges              : Pointer to the EdgeList or VertexList <br>
//!       - index              : Index of the edge into the EdgeList <br>
//!                              VertexList entity <br>
//!       - orient             : Orientation flag of the edge <br>
//!       - nbParameterCurves  : the number of parameter space curves <br>
//!                              for each edge <br>
//!       - isoparametricFlags : the isoparametric flag of the <br>
//!                              parameter space curve <br>
//!       - curves             : the parameter space curves <br>
//! raises exception if length of types, edges, index, orient and <br>
//! nbParameterCurves do not match or the length of <br>
//! isoparametricFlags and curves do not match <br>
  Standard_EXPORT     void Init(const Handle(TColStd_HArray1OfInteger)& types,const Handle(IGESData_HArray1OfIGESEntity)& edges,const Handle(TColStd_HArray1OfInteger)& index,const Handle(TColStd_HArray1OfInteger)& orient,const Handle(TColStd_HArray1OfInteger)& nbParameterCurves,const Handle(IGESBasic_HArray1OfHArray1OfInteger)& isoparametricFlags,const Handle(IGESBasic_HArray1OfHArray1OfIGESEntity)& curves) ;
  //! Tells if a Loop is a Bound (FN 1) else it is free (FN 0) <br>
  Standard_EXPORT     Standard_Boolean IsBound() const;
  //! Sets or Unset the Bound Status (from Form Number) <br>
//!           Default is True <br>
  Standard_EXPORT     void SetBound(const Standard_Boolean bound) ;
  //! returns the number of edge tuples <br>
  Standard_EXPORT     Standard_Integer NbEdges() const;
  //! returns the type of Index'th edge (0 = Edge, 1 = Vertex) <br>
//! raises exception if Index <= 0 or Index > NbEdges() <br>
  Standard_EXPORT     Standard_Integer EdgeType(const Standard_Integer Index) const;
  //! return the EdgeList or VertexList corresponding to the Index <br>
//! raises exception if Index <= 0 or Index > NbEdges() <br>
  Standard_EXPORT     Handle_IGESData_IGESEntity Edge(const Standard_Integer Index) const;
  //! returns the orientation flag corresponding to Index'th edge <br>
//! raises exception if Index <= 0 or Index > NbEdges() <br>
  Standard_EXPORT     Standard_Boolean Orientation(const Standard_Integer Index) const;
  //! return the number of parameter space curves associated with <br>
//! Index'th Edge <br>
//! raises exception if Index <= 0 or Index > NbEdges() <br>
  Standard_EXPORT     Standard_Integer NbParameterCurves(const Standard_Integer Index) const;
  
  Standard_EXPORT     Standard_Boolean IsIsoparametric(const Standard_Integer EdgeIndex,const Standard_Integer CurveIndex) const;
  //! returns the CurveIndex'th parameter space curve associated with <br>
//! EdgeIndex'th edge <br>
//! raises exception if EdgeIndex <= 0 or EdgeIndex > NbEdges() or <br>
//! if CurveIndex <= 0 or CurveIndex > NbParameterCurves(EdgeIndex) <br>
  Standard_EXPORT     Handle_IGESData_IGESEntity ParametricCurve(const Standard_Integer EdgeIndex,const Standard_Integer CurveIndex) const;
  //! raises exception If num <= 0 or num > NbEdges() <br>
  Standard_EXPORT     Standard_Integer ListIndex(const Standard_Integer num) const;




  DEFINE_STANDARD_RTTI(IGESSolid_Loop)

protected:




private: 


Handle_TColStd_HArray1OfInteger theTypes;
Handle_IGESData_HArray1OfIGESEntity theEdges;
Handle_TColStd_HArray1OfInteger theIndex;
Handle_TColStd_HArray1OfInteger theOrientationFlags;
Handle_TColStd_HArray1OfInteger theNbParameterCurves;
Handle_IGESBasic_HArray1OfHArray1OfInteger theIsoparametricFlags;
Handle_IGESBasic_HArray1OfHArray1OfIGESEntity theCurves;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
