<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [FileChooser](./puppeteer.filechooser.md)

## FileChooser class

File choosers let you react to the page requesting for a file.

<b>Signature:</b>

```typescript
export declare class FileChooser 
```

## Remarks

`FileChooser` objects are returned via the `page.waitForFileChooser` method.

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `FileChooser` class.

## Example

An example of using `FileChooser`:

```js
const [fileChooser] = await Promise.all([
  page.waitForFileChooser(),
  page.click('#upload-file-button'), // some button that triggers file selection
]);
await fileChooser.accept(['/tmp/myfile.pdf']);

```
\*\*NOTE\*\* In browsers, only one file chooser can be opened at a time. All file choosers must be accepted or canceled. Not doing so will prevent subsequent file choosers from appearing.

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [accept(filePaths)](./puppeteer.filechooser.accept.md) |  | Accept the file chooser request with given paths. |
|  [cancel()](./puppeteer.filechooser.cancel.md) |  | Closes the file chooser without selecting any files. |
|  [isMultiple()](./puppeteer.filechooser.ismultiple.md) |  | Whether file chooser allow for [multiple](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/file#attr-multiple) file selection. |

