/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedTupleIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleSorter
extends Expression {
    private Expression select;
    private SortKeyDefinition[] sortKeyDefinitions;
    private AtomicComparer[] comparators;

    public TupleSorter(Expression base, SortKeyDefinition[] keys) {
        this.select = base;
        this.sortKeyDefinitions = keys;
        this.adoptChildExpression(base);
    }

    public AtomicComparer[] getComparators() {
        return this.comparators;
    }

    public Expression getBaseExpression() {
        return this.select;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.typeCheck(this.select, contextItemType);
        if (this.comparators == null) {
            this.comparators = new AtomicComparer[this.sortKeyDefinitions.length];
            XPathContext context = visitor.getStaticContext().makeEarlyEvaluationContext();
            for (int i = 0; i < this.sortKeyDefinitions.length; ++i) {
                visitor.typeCheck(this.sortKeyDefinitions[i].getSortKey(), contextItemType);
                this.comparators[i] = this.sortKeyDefinitions[i].makeComparator(context);
                this.sortKeyDefinitions[i].setSortKey(new StringLiteral(StringValue.EMPTY_STRING));
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        return this;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator(this.select);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.select = this.select.promote(offer, parent);
        return this;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SortedTupleIterator iter = new SortedTupleIterator(context, this.select.iterate(context), this.comparators);
        return new MappingIterator(iter, TupleUnwrapper.getInstance());
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("tupleSorter");
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        for (int s = 0; s < this.sortKeyDefinitions.length; ++s) {
            out.startSubsidiaryElement("by");
            this.sortKeyDefinitions[s].getSortKey().explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    public static class TupleUnwrapper
    implements MappingFunction {
        private static TupleUnwrapper THE_INSTANCE = new TupleUnwrapper();

        private TupleUnwrapper() {
        }

        public static TupleUnwrapper getInstance() {
            return THE_INSTANCE;
        }

        public SequenceIterator map(Item item) throws XPathException {
            ObjectValue tuple = (ObjectValue)item;
            Object o = tuple.getObject();
            if (o == null) {
                return null;
            }
            if (o instanceof Item) {
                return SingletonIterator.makeIterator((Item)o);
            }
            Value value = (Value)o;
            return value.iterate();
        }
    }
}

