#ifndef _PDU_DNS_H
#define _PDU_DNS_H 1

/* pdu-dns.h
 
   Function prototypes and variables used by the builder of DNS PDUs.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Stores a DNS question record specified by the user */
struct dnsqr_option {
    char *qname;
    uint16_t qtype;
    uint16_t qclass;
};

struct dnshdr_options {
    numspec_t *id;
    int qr;
    int opcode;
    int aa;
    int tc;
    int rd;
    int ra;
    int z;
    int rcode;
    numspec_t *qdcount;
    numspec_t *ancount;
    numspec_t *nscount;
    numspec_t *arcount;

    uint16_t nqueries;
    struct dnsqr_option *queries; /* Array of DNS question records */

    uint16_t nanswers;
    void *answers;

    uint16_t nnservers;
    void *nservers;

    uint16_t nextrarrs;
    void *extrarrs;
};

/* DNS header on the wire */
struct dns_hdr {
    uint16_t id;
    uint16_t flags;
    uint16_t qdcount; /* number of entries in the question section */
    uint16_t ancount; /* number of resource records in the answer section */
    uint16_t nscount; /* number of name server resource records in the
			 authority records section*/
    uint16_t arcount; /* number of resource records in the additional
			 records section */
} __attribute__((packed));

#endif /* _PDU_DNS_H */
