#ifndef _SPAWN_NETWORK_H
#define _SPAWN_NETWORK_H

/* spawn_network.h -- Definitions for spawn_network and related commands

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*********************************************************************
 ***			      Listeners                            ***
 *********************************************************************/

#define LISTENER_SPAWN_ID_VARNAME "listener_id"

#define NEXP_LISTENER_SPEAKER_NAMELEN (16 + TCL_INTEGER_SPACE)

/*
 * Better to not make it part of the enum below to prevent compiler warnings.
 * Used only during processing of the spawn_network command. Obviously
 * an arbitrary number.
 */
#define LISTENER_NONE 0xffff1073

enum listener_types {
    LISTENER_LIVE,
    LISTENER_SAVEFILE,
    LISTENER_STREAM,
    LISTENER_DGRAM
};

/*
 * The nexp_listener structure keeps track of a listener that has been
 * activated via the spawn_network command. Listeners are specified using the
 * -i switch of the expect_network and send_expect commands.
 */
struct nexp_listener {
    struct nexp_listener *next;

    char name[NEXP_LISTENER_SPEAKER_NAMELEN + 1];

    struct timeval first_ts; /* Time when a packet was first read from this
				listener */
    struct timeval prev_cap_ts; /* Time when a packet was last read from this
				   listener */
    struct timeval prev_cap_ts_real; /* Time when a packet was last read from
					this listener (current time) */

    uint32_t nreads; /* Number of times this listener has been read */

    enum listener_types type;

    union {
	/* Used when reading packets from a PCAP file */
	struct {
	    pcap_t *pd;
	    int fd; /* File descriptor suitable to be passed to select() */
	    int datalink_type;
	    char *cfilter; /* Capture (pcap) filter */
	    char *rfilter; /* Read (libwireshark, a.k.a. display) filter */
	    dfilter_t *rfcode; /* Read filter code */
	    int fullspeed;
	    const char *fname;
	    int npackets; /* Number of packets in the savefile */
	    int npacketsl; /* Number of packets in list of packets that the
			      user wants to read */
	    int *packet_list; /* List of packets the user wants to read */
	    int curr_pkt;
	    struct timeval *delays; /* Delays from a packet to the next */
	} __pcap;

	/* Used when reading live traffic from an interface */
	struct {
	    pcap_t *pd;
	    int fd; /* File descriptor suitable to be passed to select() */
	    int datalink_type;
	    char *cfilter; /* Capture (pcap) filter */
	    char *rfilter; /* Read (libwireshark, a.k.a. display) filter */
	    dfilter_t *rfcode; /* Read filter code */
	    const char *ifname;
	} __live;

	/* Used when reading from a TCP or UDP socket */
	struct {
	    int fd;
	    char *dsthost;
	    char *dstport;
	} __socket;
    } __type_u;
};

#define _pcap __type_u.__pcap
#define _live __type_u.__live
#define _socket __type_u.__socket

extern struct nexp_listener *lookup_listener(const char *);
extern struct nexp_speaker *lookup_speaker(const char *);
extern int listener_fd(struct nexp_listener *);
extern void nexp_init_spawn_cmds _ANSI_ARGS_((Tcl_Interp *));

#endif /* _SPAWN_NETWORK_H */
