/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xml.tools.java.generator;

import java.awt.event.ActionEvent;
import java.util.*;
import java.text.DateFormat;

import org.openide.filesystems.FileObject;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.EditCookie;
import org.openide.loaders.*;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class GenerateSupportUtils {

    /**
     * Use some heuristics and create valid java name.
     */
    public static String getJavaName (String name) {
        StringTokenizer st = new StringTokenizer (name, " -.:"); // NOI18N
        StringBuffer sb = new StringBuffer ();
        if (st.hasMoreTokens()) {
            sb.append (st.nextToken());
            while (st.hasMoreTokens()) {
                sb.append ("_").append (st.nextToken()); // NOI18N
            }
        }
        return sb.toString();
    }


    /*
     * Generate default java header.
     * @param primFile a model used for generated code or null
     */
    public static String getJavaFileHeader (String name, FileObject primFile) {
        Date now = new Date();

        StringBuffer sb = new StringBuffer ();
        sb.append("/*\n * File:           ").append (name).append (".java"); // NOI18N
        if (primFile != null) {
            sb.append ("\n * Generated from: ").append (primFile.getName()).append (".").append (primFile.getExt()); // NOI18N
        }
        sb.append("\n * Date:           ").append (DateFormat.getDateInstance (DateFormat.LONG).format (now)); // NOI18N
        sb.append ("  ").append (DateFormat.getTimeInstance (DateFormat.SHORT).format (now)); // NOI18N
        sb.append("\n *"); // NOI18N
        sb.append("\n * @author  ").append(System.getProperty ("user.name")); // NOI18N
        sb.append("\n * @version generated by NetBeans XML module"); // NOI18N
        sb.append("\n */"); // NOI18N
        return sb.toString();
    }
    
//      public static final void debug(String msg, Throwable ex) {
//          if (Boolean.getBoolean("netbeans.debug.xml")) { // NOI18N
//              System.err.println(msg);
//              ex.printStackTrace();
//          }
//      }

    
    /**
     * Test whether given identifier is valid Java return type
     */
    public static boolean isValidReturnType(String value) {
        
        if (value == null || "".equals(value)) return false; // NOI18N
        int length = value.length();
        
        // check for arrays e.g. "String[][]"
        while (length > 2 && value.charAt(length-2) == '[' && value.charAt(length-1) == ']') {
            value = value.substring(0, length-2);
            length -= 2;
        }
        
        if (value.charAt(0) == '.' || value.charAt(value.length()-1) == '.')
            return false;
        
        for(int i=1; i<length-2; i++) {
            if (value.charAt(i) == '.' && value.charAt(i+1) == '.')
                return false;
        }
        
                    
        StringTokenizer st = new StringTokenizer(value, "."); // NOI18N
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!!!isPrimitiveType(token) && !!!Utilities.isJavaIdentifier(token))
                return false;
        }
        return true;
    }

    /**
     * @return true if given value does represent Java primitive type.
     */
    public static boolean isPrimitiveType(String value) {

        String val[] = {"int", "char", "boolean", "long", "float", "double", "void"}; // NOI18N
        for(int i=0;i<val.length;i++) {
            if(val[i].equals(value))
                return true;
        }
        return false;
    }            
    
}
