/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2011 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2011 Sun Microsystems, Inc.
 */
package org.netbeans.modules.php.dbgp.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.netbeans.modules.php.dbgp.models.VariablesModelFilter;
import org.netbeans.modules.php.dbgp.models.VariablesModelFilter.FilterType;

/**
 *
 * @author den
 */
public class LocalFilterPanel extends javax.swing.JPanel {
    private static final long serialVersionUID = -523385854753396290L;

    /**
     * Creates new form LocalFilterPanel.
     */
    public LocalFilterPanel() {
        initComponents();
        init();
    }

    public FilterType[] getSelectedTypes() {
        List<FilterType> result = new LinkedList<>();
        if (myScalars.isSelected()) {
            result.add(FilterType.SCALARS);
        }
        if (myArray.isSelected()) {
            result.add(FilterType.ARRAY);
        }
        if (myObject.isSelected()) {
            result.add(FilterType.OBJECT);
        }
        if (myResource.isSelected()) {
            result.add(FilterType.RESOURCE);
        }
        if (myNull.isSelected()) {
            result.add(FilterType.NULL);
        }
        if (myUninit.isSelected()) {
            result.add(FilterType.UNINIT);
        }
        if (mySuperglobal.isSelected()) {
            result.add(FilterType.SUPERGLOBALS);
        }
        return result.toArray(new FilterType[result.size()]);
    }

    private void init() {
        FilterType[] types = VariablesModelFilter.getFilters();
        if (types == null) {
            return;
        }
        Set<FilterType> set = new HashSet<>(Arrays.asList(types));
        myScalars.setSelected(set.contains(FilterType.SCALARS));
        myArray.setSelected(set.contains(FilterType.ARRAY));
        myObject.setSelected(set.contains(FilterType.OBJECT));
        myResource.setSelected(set.contains(FilterType.RESOURCE));
        myNull.setSelected(set.contains(FilterType.NULL));
        myUninit.setSelected(set.contains(FilterType.UNINIT));
        mySuperglobal.setSelected(set.contains(FilterType.SUPERGLOBALS));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mySelectLbl = new javax.swing.JLabel();
        myScalars = new javax.swing.JCheckBox();
        myArray = new javax.swing.JCheckBox();
        myObject = new javax.swing.JCheckBox();
        myResource = new javax.swing.JCheckBox();
        myNull = new javax.swing.JCheckBox();
        myUninit = new javax.swing.JCheckBox();
        mySuperglobal = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(mySelectLbl, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Select")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myScalars, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Scalars")); // NOI18N
        myScalars.setActionCommand(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Scalars")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myArray, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Array")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myObject, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Object")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myResource, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Resource")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myNull, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Null")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(myUninit, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Uninit")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(mySuperglobal, org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LBL_Superglobal")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(mySelectLbl)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(myArray)
                            .addComponent(myScalars)
                            .addComponent(myObject)
                            .addComponent(myResource)
                            .addComponent(myNull)
                            .addComponent(myUninit)
                            .addComponent(mySuperglobal))))
                .addContainerGap(37, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(mySelectLbl)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(myScalars)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(myArray)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(myObject)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(myResource)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(myNull)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(myUninit)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(mySuperglobal)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        mySelectLbl.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.mySelectLbl.AccessibleContext.accessibleName")); // NOI18N
        mySelectLbl.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.mySelectLbl.AccessibleContext.accessibleDescription")); // NOI18N
        myScalars.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Scalars")); // NOI18N
        myScalars.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.myScalars.AccessibleContext.accessibleDescription")); // NOI18N
        myArray.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Array")); // NOI18N
        myArray.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.myArray.AccessibleContext.accessibleDescription")); // NOI18N
        myObject.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Object")); // NOI18N
        myObject.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.myObject.AccessibleContext.accessibleDescription")); // NOI18N
        myResource.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Resource")); // NOI18N
        myResource.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.myResource.AccessibleContext.accessibleDescription")); // NOI18N
        myNull.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Null")); // NOI18N
        myNull.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.myNull.AccessibleContext.accessibleDescription")); // NOI18N
        myUninit.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Uninit")); // NOI18N
        myUninit.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.myUninit.AccessibleContext.accessibleDescription")); // NOI18N
        mySuperglobal.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "A11_Superglobal")); // NOI18N
        mySuperglobal.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.mySuperglobal.AccessibleContext.accessibleDescription")); // NOI18N

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(LocalFilterPanel.class, "LocalFilterPanel.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox myArray;
    private javax.swing.JCheckBox myNull;
    private javax.swing.JCheckBox myObject;
    private javax.swing.JCheckBox myResource;
    private javax.swing.JCheckBox myScalars;
    private javax.swing.JLabel mySelectLbl;
    private javax.swing.JCheckBox mySuperglobal;
    private javax.swing.JCheckBox myUninit;
    // End of variables declaration//GEN-END:variables

}
