/***********************************************************
 * Copyright 2010 Adobe Systems Incorporated.  All Rights Reserved.
 *
 * *********************************************************
 * The contents of this file are subject to the Berkeley Software Distribution (BSD) Licence
 * (the "License"); you may not use this file except in
 * compliance with the License. 
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 *
 * The Initial Developer of the Original Code is Adobe Systems Incorporated.
 * Portions created by Adobe Systems Incorporated are Copyright (C) 2010 Adobe Systems
 * Incorporated. All Rights Reserved.
 * 
 **********************************************************/

package org.osmf.player.errors
{
	import org.osmf.player.utils.StrobePlayerStrings;
	import org.osmf.utils.OSMFStrings;

	/**
	 * Defines the error codes as used on error messages generated by the
	 * player.
	 */	
	public class StrobePlayerErrorCodes
	{
		public static const ILLEGAL_INPUT_VARIABLE:int 			    = 1000;
		public static const DYNAMIC_STREAMING_RESOURCE_EXPECTED:int = 1001;
		public static const CONFIGURATION_LOAD_ERROR:int 			= 1002;
		public static const UNKNOWN_ERROR:int 						= 1003;
		public static const PLUGIN_NOT_IN_WHITELIST:int				= 1004;
		public static const PLUGIN_LOAD_FAILED:int					= 1005;
		
		/**
		 * @private
		 * 
		 * Returns a message for the error of the specified ID.  If the error ID
		 * is unknown, returns the empty string.
		 * 
		 * @param errorID The ID for the error.
		 * 
		 * @return The message for the error with the specified ID.
		 *  
		 *  @langversion 3.0
		 *  @playerversion Flash 10
		 *  @playerversion AIR 1.5
		 *  @productversion OSMF 1.0
		 */
		internal static function getMessageForErrorID(errorID:int):String
		{
			var message:String = "";
			
			for (var i:int = 0; i < errorMap.length; i++)
			{
				if (errorMap[i].errorID == errorID)
				{
					message = StrobePlayerStrings.getString(errorMap[i].message);
					break;
				}
			}
			
			return message;
		}
		
		private static const errorMap:Array
			=	[	{ errorID:ILLEGAL_INPUT_VARIABLE
					, message:StrobePlayerStrings.ILLEGAL_INPUT_VARIABLE
					}
				,	{ errorID:DYNAMIC_STREAMING_RESOURCE_EXPECTED
					, message:StrobePlayerStrings.DYNAMIC_STREAMING_RESOURCE_EXPECTED
					}	
				,	{ errorID:CONFIGURATION_LOAD_ERROR
					, message:StrobePlayerStrings.CONFIGURATION_LOAD_ERROR
					}	
				,	{ errorID:PLUGIN_NOT_IN_WHITELIST
					, message:StrobePlayerStrings.PLUGIN_NOT_IN_WHITELIST
					}	
				];
	}
}