"use strict";

var helpers = require("../helpers/helpers");

exports["NZ"] = {

	"guess:by:offset" : helpers.makeTestGuess("NZ", { offset: true, expect: "Pacific/Auckland" }),

	"guess:by:abbr" : helpers.makeTestGuess("NZ", { abbr: true, expect: "Pacific/Auckland" }),

	"1927" : helpers.makeTestYear("NZ", [
		["1927-11-05T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1927-11-05T14:30:00+00:00", "03:00:00", "NZST", -750]
	]),

	"1928" : helpers.makeTestYear("NZ", [
		["1928-03-03T13:29:59+00:00", "01:59:59", "NZST", -750],
		["1928-03-03T13:30:00+00:00", "01:00:00", "NZMT", -690],
		["1928-10-13T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1928-10-13T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1929" : helpers.makeTestYear("NZ", [
		["1929-03-16T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1929-03-16T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1929-10-12T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1929-10-12T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1930" : helpers.makeTestYear("NZ", [
		["1930-03-15T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1930-03-15T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1930-10-11T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1930-10-11T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1931" : helpers.makeTestYear("NZ", [
		["1931-03-14T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1931-03-14T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1931-10-10T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1931-10-10T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1932" : helpers.makeTestYear("NZ", [
		["1932-03-19T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1932-03-19T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1932-10-08T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1932-10-08T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1933" : helpers.makeTestYear("NZ", [
		["1933-03-18T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1933-03-18T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1933-10-07T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1933-10-07T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1934" : helpers.makeTestYear("NZ", [
		["1934-04-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1934-04-28T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1934-09-29T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1934-09-29T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1935" : helpers.makeTestYear("NZ", [
		["1935-04-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1935-04-27T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1935-09-28T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1935-09-28T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1936" : helpers.makeTestYear("NZ", [
		["1936-04-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1936-04-25T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1936-09-26T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1936-09-26T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1937" : helpers.makeTestYear("NZ", [
		["1937-04-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1937-04-24T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1937-09-25T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1937-09-25T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1938" : helpers.makeTestYear("NZ", [
		["1938-04-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1938-04-23T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1938-09-24T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1938-09-24T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1939" : helpers.makeTestYear("NZ", [
		["1939-04-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1939-04-29T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1939-09-23T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1939-09-23T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1940" : helpers.makeTestYear("NZ", [
		["1940-04-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1940-04-27T14:00:00+00:00", "01:30:00", "NZMT", -690],
		["1940-09-28T14:29:59+00:00", "01:59:59", "NZMT", -690],
		["1940-09-28T14:30:00+00:00", "02:30:00", "NZST", -720]
	]),

	"1945" : helpers.makeTestYear("NZ", [
		["1945-12-31T11:59:59+00:00", "23:59:59", "NZST", -720],
		["1945-12-31T12:00:00+00:00", "00:00:00", "NZST", -720]
	]),

	"1974" : helpers.makeTestYear("NZ", [
		["1974-11-02T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1974-11-02T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1975" : helpers.makeTestYear("NZ", [
		["1975-02-22T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1975-02-22T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1975-10-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1975-10-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1976" : helpers.makeTestYear("NZ", [
		["1976-03-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1976-03-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1976-10-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1976-10-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1977" : helpers.makeTestYear("NZ", [
		["1977-03-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1977-03-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1977-10-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1977-10-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1978" : helpers.makeTestYear("NZ", [
		["1978-03-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1978-03-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1978-10-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1978-10-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1979" : helpers.makeTestYear("NZ", [
		["1979-03-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1979-03-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1979-10-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1979-10-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1980" : helpers.makeTestYear("NZ", [
		["1980-03-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1980-03-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1980-10-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1980-10-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1981" : helpers.makeTestYear("NZ", [
		["1981-02-28T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1981-02-28T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1981-10-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1981-10-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1982" : helpers.makeTestYear("NZ", [
		["1982-03-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1982-03-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1982-10-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1982-10-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1983" : helpers.makeTestYear("NZ", [
		["1983-03-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1983-03-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1983-10-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1983-10-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1984" : helpers.makeTestYear("NZ", [
		["1984-03-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1984-03-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1984-10-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1984-10-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1985" : helpers.makeTestYear("NZ", [
		["1985-03-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1985-03-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1985-10-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1985-10-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1986" : helpers.makeTestYear("NZ", [
		["1986-03-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1986-03-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1986-10-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1986-10-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1987" : helpers.makeTestYear("NZ", [
		["1987-02-28T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1987-02-28T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1987-10-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1987-10-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1988" : helpers.makeTestYear("NZ", [
		["1988-03-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1988-03-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1988-10-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1988-10-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1989" : helpers.makeTestYear("NZ", [
		["1989-03-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1989-03-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1989-10-07T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1989-10-07T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1990" : helpers.makeTestYear("NZ", [
		["1990-03-17T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1990-03-17T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1990-10-06T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1990-10-06T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1991" : helpers.makeTestYear("NZ", [
		["1991-03-16T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1991-03-16T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1991-10-05T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1991-10-05T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1992" : helpers.makeTestYear("NZ", [
		["1992-03-14T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1992-03-14T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1992-10-03T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1992-10-03T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1993" : helpers.makeTestYear("NZ", [
		["1993-03-20T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1993-03-20T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1993-10-02T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1993-10-02T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1994" : helpers.makeTestYear("NZ", [
		["1994-03-19T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1994-03-19T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1994-10-01T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1994-10-01T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1995" : helpers.makeTestYear("NZ", [
		["1995-03-18T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1995-03-18T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1995-09-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1995-09-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1996" : helpers.makeTestYear("NZ", [
		["1996-03-16T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1996-03-16T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1996-10-05T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1996-10-05T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1997" : helpers.makeTestYear("NZ", [
		["1997-03-15T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1997-03-15T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1997-10-04T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1997-10-04T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1998" : helpers.makeTestYear("NZ", [
		["1998-03-14T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1998-03-14T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1998-10-03T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1998-10-03T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"1999" : helpers.makeTestYear("NZ", [
		["1999-03-20T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["1999-03-20T14:00:00+00:00", "02:00:00", "NZST", -720],
		["1999-10-02T13:59:59+00:00", "01:59:59", "NZST", -720],
		["1999-10-02T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2000" : helpers.makeTestYear("NZ", [
		["2000-03-18T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2000-03-18T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2000-09-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2000-09-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2001" : helpers.makeTestYear("NZ", [
		["2001-03-17T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2001-03-17T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2001-10-06T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2001-10-06T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2002" : helpers.makeTestYear("NZ", [
		["2002-03-16T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2002-03-16T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2002-10-05T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2002-10-05T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2003" : helpers.makeTestYear("NZ", [
		["2003-03-15T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2003-03-15T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2003-10-04T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2003-10-04T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2004" : helpers.makeTestYear("NZ", [
		["2004-03-20T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2004-03-20T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2004-10-02T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2004-10-02T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2005" : helpers.makeTestYear("NZ", [
		["2005-03-19T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2005-03-19T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2005-10-01T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2005-10-01T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2006" : helpers.makeTestYear("NZ", [
		["2006-03-18T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2006-03-18T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2006-09-30T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2006-09-30T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2007" : helpers.makeTestYear("NZ", [
		["2007-03-17T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2007-03-17T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2007-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2007-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2008" : helpers.makeTestYear("NZ", [
		["2008-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2008-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2008-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2008-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2009" : helpers.makeTestYear("NZ", [
		["2009-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2009-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2009-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2009-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2010" : helpers.makeTestYear("NZ", [
		["2010-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2010-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2010-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2010-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2011" : helpers.makeTestYear("NZ", [
		["2011-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2011-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2011-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2011-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2012" : helpers.makeTestYear("NZ", [
		["2012-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2012-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2012-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2012-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2013" : helpers.makeTestYear("NZ", [
		["2013-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2013-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2013-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2013-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2014" : helpers.makeTestYear("NZ", [
		["2014-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2014-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2014-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2014-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2015" : helpers.makeTestYear("NZ", [
		["2015-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2015-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2015-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2015-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2016" : helpers.makeTestYear("NZ", [
		["2016-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2016-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2016-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2016-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2017" : helpers.makeTestYear("NZ", [
		["2017-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2017-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2017-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2017-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2018" : helpers.makeTestYear("NZ", [
		["2018-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2018-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2018-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2018-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2019" : helpers.makeTestYear("NZ", [
		["2019-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2019-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2019-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2019-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2020" : helpers.makeTestYear("NZ", [
		["2020-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2020-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2020-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2020-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2021" : helpers.makeTestYear("NZ", [
		["2021-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2021-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2021-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2021-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2022" : helpers.makeTestYear("NZ", [
		["2022-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2022-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2022-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2022-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2023" : helpers.makeTestYear("NZ", [
		["2023-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2023-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2023-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2023-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2024" : helpers.makeTestYear("NZ", [
		["2024-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2024-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2024-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2024-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2025" : helpers.makeTestYear("NZ", [
		["2025-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2025-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2025-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2025-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2026" : helpers.makeTestYear("NZ", [
		["2026-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2026-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2026-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2026-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2027" : helpers.makeTestYear("NZ", [
		["2027-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2027-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2027-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2027-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2028" : helpers.makeTestYear("NZ", [
		["2028-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2028-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2028-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2028-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2029" : helpers.makeTestYear("NZ", [
		["2029-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2029-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2029-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2029-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2030" : helpers.makeTestYear("NZ", [
		["2030-04-06T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2030-04-06T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2030-09-28T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2030-09-28T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2031" : helpers.makeTestYear("NZ", [
		["2031-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2031-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2031-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2031-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2032" : helpers.makeTestYear("NZ", [
		["2032-04-03T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2032-04-03T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2032-09-25T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2032-09-25T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2033" : helpers.makeTestYear("NZ", [
		["2033-04-02T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2033-04-02T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2033-09-24T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2033-09-24T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2034" : helpers.makeTestYear("NZ", [
		["2034-04-01T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2034-04-01T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2034-09-23T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2034-09-23T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2035" : helpers.makeTestYear("NZ", [
		["2035-03-31T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2035-03-31T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2035-09-29T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2035-09-29T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2036" : helpers.makeTestYear("NZ", [
		["2036-04-05T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2036-04-05T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2036-09-27T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2036-09-27T14:00:00+00:00", "03:00:00", "NZDT", -780]
	]),

	"2037" : helpers.makeTestYear("NZ", [
		["2037-04-04T13:59:59+00:00", "02:59:59", "NZDT", -780],
		["2037-04-04T14:00:00+00:00", "02:00:00", "NZST", -720],
		["2037-09-26T13:59:59+00:00", "01:59:59", "NZST", -720],
		["2037-09-26T14:00:00+00:00", "03:00:00", "NZDT", -780]
	])
};