"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Miquelon"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Miquelon", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Miquelon", { abbr: true }),

	"1911" : helpers.makeTestYear("America/Miquelon", [
		["1911-05-15T03:44:39+00:00", "23:59:59", "LMT", 13480 / 60],
		["1911-05-15T03:44:40+00:00", "23:44:40", "AST", 240]
	]),

	"1980" : helpers.makeTestYear("America/Miquelon", [
		["1980-05-01T03:59:59+00:00", "23:59:59", "AST", 240],
		["1980-05-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("America/Miquelon", [
		["1987-04-05T04:59:59+00:00", "01:59:59", "-03", 180],
		["1987-04-05T05:00:00+00:00", "03:00:00", "-02", 120],
		["1987-10-25T03:59:59+00:00", "01:59:59", "-02", 120],
		["1987-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1988" : helpers.makeTestYear("America/Miquelon", [
		["1988-04-03T04:59:59+00:00", "01:59:59", "-03", 180],
		["1988-04-03T05:00:00+00:00", "03:00:00", "-02", 120],
		["1988-10-30T03:59:59+00:00", "01:59:59", "-02", 120],
		["1988-10-30T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1989" : helpers.makeTestYear("America/Miquelon", [
		["1989-04-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["1989-04-02T05:00:00+00:00", "03:00:00", "-02", 120],
		["1989-10-29T03:59:59+00:00", "01:59:59", "-02", 120],
		["1989-10-29T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1990" : helpers.makeTestYear("America/Miquelon", [
		["1990-04-01T04:59:59+00:00", "01:59:59", "-03", 180],
		["1990-04-01T05:00:00+00:00", "03:00:00", "-02", 120],
		["1990-10-28T03:59:59+00:00", "01:59:59", "-02", 120],
		["1990-10-28T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1991" : helpers.makeTestYear("America/Miquelon", [
		["1991-04-07T04:59:59+00:00", "01:59:59", "-03", 180],
		["1991-04-07T05:00:00+00:00", "03:00:00", "-02", 120],
		["1991-10-27T03:59:59+00:00", "01:59:59", "-02", 120],
		["1991-10-27T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1992" : helpers.makeTestYear("America/Miquelon", [
		["1992-04-05T04:59:59+00:00", "01:59:59", "-03", 180],
		["1992-04-05T05:00:00+00:00", "03:00:00", "-02", 120],
		["1992-10-25T03:59:59+00:00", "01:59:59", "-02", 120],
		["1992-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1993" : helpers.makeTestYear("America/Miquelon", [
		["1993-04-04T04:59:59+00:00", "01:59:59", "-03", 180],
		["1993-04-04T05:00:00+00:00", "03:00:00", "-02", 120],
		["1993-10-31T03:59:59+00:00", "01:59:59", "-02", 120],
		["1993-10-31T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1994" : helpers.makeTestYear("America/Miquelon", [
		["1994-04-03T04:59:59+00:00", "01:59:59", "-03", 180],
		["1994-04-03T05:00:00+00:00", "03:00:00", "-02", 120],
		["1994-10-30T03:59:59+00:00", "01:59:59", "-02", 120],
		["1994-10-30T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1995" : helpers.makeTestYear("America/Miquelon", [
		["1995-04-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["1995-04-02T05:00:00+00:00", "03:00:00", "-02", 120],
		["1995-10-29T03:59:59+00:00", "01:59:59", "-02", 120],
		["1995-10-29T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1996" : helpers.makeTestYear("America/Miquelon", [
		["1996-04-07T04:59:59+00:00", "01:59:59", "-03", 180],
		["1996-04-07T05:00:00+00:00", "03:00:00", "-02", 120],
		["1996-10-27T03:59:59+00:00", "01:59:59", "-02", 120],
		["1996-10-27T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1997" : helpers.makeTestYear("America/Miquelon", [
		["1997-04-06T04:59:59+00:00", "01:59:59", "-03", 180],
		["1997-04-06T05:00:00+00:00", "03:00:00", "-02", 120],
		["1997-10-26T03:59:59+00:00", "01:59:59", "-02", 120],
		["1997-10-26T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1998" : helpers.makeTestYear("America/Miquelon", [
		["1998-04-05T04:59:59+00:00", "01:59:59", "-03", 180],
		["1998-04-05T05:00:00+00:00", "03:00:00", "-02", 120],
		["1998-10-25T03:59:59+00:00", "01:59:59", "-02", 120],
		["1998-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1999" : helpers.makeTestYear("America/Miquelon", [
		["1999-04-04T04:59:59+00:00", "01:59:59", "-03", 180],
		["1999-04-04T05:00:00+00:00", "03:00:00", "-02", 120],
		["1999-10-31T03:59:59+00:00", "01:59:59", "-02", 120],
		["1999-10-31T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2000" : helpers.makeTestYear("America/Miquelon", [
		["2000-04-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["2000-04-02T05:00:00+00:00", "03:00:00", "-02", 120],
		["2000-10-29T03:59:59+00:00", "01:59:59", "-02", 120],
		["2000-10-29T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2001" : helpers.makeTestYear("America/Miquelon", [
		["2001-04-01T04:59:59+00:00", "01:59:59", "-03", 180],
		["2001-04-01T05:00:00+00:00", "03:00:00", "-02", 120],
		["2001-10-28T03:59:59+00:00", "01:59:59", "-02", 120],
		["2001-10-28T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2002" : helpers.makeTestYear("America/Miquelon", [
		["2002-04-07T04:59:59+00:00", "01:59:59", "-03", 180],
		["2002-04-07T05:00:00+00:00", "03:00:00", "-02", 120],
		["2002-10-27T03:59:59+00:00", "01:59:59", "-02", 120],
		["2002-10-27T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2003" : helpers.makeTestYear("America/Miquelon", [
		["2003-04-06T04:59:59+00:00", "01:59:59", "-03", 180],
		["2003-04-06T05:00:00+00:00", "03:00:00", "-02", 120],
		["2003-10-26T03:59:59+00:00", "01:59:59", "-02", 120],
		["2003-10-26T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2004" : helpers.makeTestYear("America/Miquelon", [
		["2004-04-04T04:59:59+00:00", "01:59:59", "-03", 180],
		["2004-04-04T05:00:00+00:00", "03:00:00", "-02", 120],
		["2004-10-31T03:59:59+00:00", "01:59:59", "-02", 120],
		["2004-10-31T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2005" : helpers.makeTestYear("America/Miquelon", [
		["2005-04-03T04:59:59+00:00", "01:59:59", "-03", 180],
		["2005-04-03T05:00:00+00:00", "03:00:00", "-02", 120],
		["2005-10-30T03:59:59+00:00", "01:59:59", "-02", 120],
		["2005-10-30T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2006" : helpers.makeTestYear("America/Miquelon", [
		["2006-04-02T04:59:59+00:00", "01:59:59", "-03", 180],
		["2006-04-02T05:00:00+00:00", "03:00:00", "-02", 120],
		["2006-10-29T03:59:59+00:00", "01:59:59", "-02", 120],
		["2006-10-29T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2007" : helpers.makeTestYear("America/Miquelon", [
		["2007-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2007-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2007-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2007-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2008" : helpers.makeTestYear("America/Miquelon", [
		["2008-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2008-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2008-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2008-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2009" : helpers.makeTestYear("America/Miquelon", [
		["2009-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2009-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2009-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2009-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2010" : helpers.makeTestYear("America/Miquelon", [
		["2010-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2010-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2010-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2010-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2011" : helpers.makeTestYear("America/Miquelon", [
		["2011-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2011-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2011-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2011-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2012" : helpers.makeTestYear("America/Miquelon", [
		["2012-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2012-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2012-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2012-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2013" : helpers.makeTestYear("America/Miquelon", [
		["2013-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2013-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2013-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2013-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2014" : helpers.makeTestYear("America/Miquelon", [
		["2014-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2014-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2014-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2014-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2015" : helpers.makeTestYear("America/Miquelon", [
		["2015-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2015-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2015-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2015-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2016" : helpers.makeTestYear("America/Miquelon", [
		["2016-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2016-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2016-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2016-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2017" : helpers.makeTestYear("America/Miquelon", [
		["2017-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2017-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2017-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2017-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2018" : helpers.makeTestYear("America/Miquelon", [
		["2018-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2018-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2018-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2018-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2019" : helpers.makeTestYear("America/Miquelon", [
		["2019-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2019-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2019-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2019-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2020" : helpers.makeTestYear("America/Miquelon", [
		["2020-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2020-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2020-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2020-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2021" : helpers.makeTestYear("America/Miquelon", [
		["2021-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2021-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2021-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2021-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2022" : helpers.makeTestYear("America/Miquelon", [
		["2022-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2022-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2022-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2022-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2023" : helpers.makeTestYear("America/Miquelon", [
		["2023-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2023-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2023-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2023-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2024" : helpers.makeTestYear("America/Miquelon", [
		["2024-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2024-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2024-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2024-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2025" : helpers.makeTestYear("America/Miquelon", [
		["2025-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2025-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2025-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2025-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2026" : helpers.makeTestYear("America/Miquelon", [
		["2026-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2026-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2026-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2026-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2027" : helpers.makeTestYear("America/Miquelon", [
		["2027-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2027-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2027-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2027-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2028" : helpers.makeTestYear("America/Miquelon", [
		["2028-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2028-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2028-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2028-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2029" : helpers.makeTestYear("America/Miquelon", [
		["2029-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2029-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2029-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2029-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2030" : helpers.makeTestYear("America/Miquelon", [
		["2030-03-10T04:59:59+00:00", "01:59:59", "-03", 180],
		["2030-03-10T05:00:00+00:00", "03:00:00", "-02", 120],
		["2030-11-03T03:59:59+00:00", "01:59:59", "-02", 120],
		["2030-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2031" : helpers.makeTestYear("America/Miquelon", [
		["2031-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2031-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2031-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2031-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2032" : helpers.makeTestYear("America/Miquelon", [
		["2032-03-14T04:59:59+00:00", "01:59:59", "-03", 180],
		["2032-03-14T05:00:00+00:00", "03:00:00", "-02", 120],
		["2032-11-07T03:59:59+00:00", "01:59:59", "-02", 120],
		["2032-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2033" : helpers.makeTestYear("America/Miquelon", [
		["2033-03-13T04:59:59+00:00", "01:59:59", "-03", 180],
		["2033-03-13T05:00:00+00:00", "03:00:00", "-02", 120],
		["2033-11-06T03:59:59+00:00", "01:59:59", "-02", 120],
		["2033-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2034" : helpers.makeTestYear("America/Miquelon", [
		["2034-03-12T04:59:59+00:00", "01:59:59", "-03", 180],
		["2034-03-12T05:00:00+00:00", "03:00:00", "-02", 120],
		["2034-11-05T03:59:59+00:00", "01:59:59", "-02", 120],
		["2034-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2035" : helpers.makeTestYear("America/Miquelon", [
		["2035-03-11T04:59:59+00:00", "01:59:59", "-03", 180],
		["2035-03-11T05:00:00+00:00", "03:00:00", "-02", 120],
		["2035-11-04T03:59:59+00:00", "01:59:59", "-02", 120],
		["2035-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2036" : helpers.makeTestYear("America/Miquelon", [
		["2036-03-09T04:59:59+00:00", "01:59:59", "-03", 180],
		["2036-03-09T05:00:00+00:00", "03:00:00", "-02", 120],
		["2036-11-02T03:59:59+00:00", "01:59:59", "-02", 120],
		["2036-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2037" : helpers.makeTestYear("America/Miquelon", [
		["2037-03-08T04:59:59+00:00", "01:59:59", "-03", 180],
		["2037-03-08T05:00:00+00:00", "03:00:00", "-02", 120],
		["2037-11-01T03:59:59+00:00", "01:59:59", "-02", 120],
		["2037-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	])
};