/*
  Copyright (C) 2008 André Gaul, Jan Friederich, Steffen Basting, Kai Hertel

        This file is part of mmpong.

        mmpong is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        mmpong is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __NETGAME_H__
#define __NETGAME_H__


#include <string>
#include "lib/message.h"
#include "game.h"

void timeval_combine(const int lfact, struct timeval *lval, const int rfact, const struct timeval *rval);

class NetGame : public Game {
	private:
		int sock;
		bool blocking;
		struct netmessage_buffer recvbuf, sendbuf;
	public:
		NetGame(const std::string &server, const std::string &port, bool _blocking);
		~NetGame();
		void update(const struct timeval *time_wait);
		void sendpos(float pos);
		void sendpos_flush();
};


#endif
