;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; MDH 071118 - Simple Binary Tape Example
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(load "~/minlog/init.scm")
(set! COMMENT-FLAG #f)
(libload "nat.scm")

(add-var-name "a" (py "boole"))
(aga "Lemma" (pf "all a. (a = False -> F) -> (a = True)" ))
; ; (set-goal (pf "all a. (a = True -> F) -> (a = False)" ))
; ; (ind)
; ; (prop)
; ; (prop)
; ; (save "Lemma")

(add-var-name "g" (py "nat=>(nat=>nat)=>nat"))
(add-var-name "f" (py "nat=>nat"))
(add-var-name "b" (py "nat"))
(add-var-name "p" (py "nat"))
(add-program-constant "Odd" (mk-arrow (py "nat")(py "boole")) 1)
(add-program-constant "Even" (mk-arrow (py "nat")(py "boole")) 1)
(add-computation-rule (pt "Odd (Succ n)")(pt "Even n"))
(add-computation-rule (pt "Even (Succ n)")(pt "Odd n"))
(add-computation-rule (pt "Odd 0")(pt "False"))
(add-computation-rule (pt "Even 0")(pt "True"))
(add-rewrite-rule (pt "n<=k+n")(pt "True"))

(set-goal (pf "all f. exca b. all n. exca p. n<=p ! Odd(f(p))=Odd(b)"))
(assume "f")
(assume "Ass01")
(inst-with "Ass01" (pt "1"))
(inst-with "Ass01" (pt "0"))
(use 2)
(assume "n1")
(assume "Ass02")
(use 3)
(assume "n2")
(assume "Ass03")
(inst-with "Ass02" (pt "n1+n2"))
(use 6)
(use "Truth-Axiom")
(use "Lemma")
(inst-with "Ass03" (pt "n1+n2"))
(use 7)
(use "Truth-Axiom")
(define CP (current-proof))
; ; (define CP  (expand-theorems (current-proof)))
; ; (define NCP (np CP))

(mload "../modules/diatup.scm")

(define vatmp (DIA-extract 'light CP))
(define tmp (vatmpair-to-tmpair vatmp))
(define tuple (tmpair-to-tuple tmp))
(define tmlst (tmtuple-to-tmlist tuple))
(length tmlst)
(define t1 (time (nt (car tmlst))))
(define t2 (time (nt (cadr tmlst))))
(set! COMMENT-FLAG #t)
(pp t1)
(pp t2)

(define f (pt "[n](n+1)"))
(define g (pt "[n]([f](f (n+1)))"))
(define t3 (nt (mk-term-in-app-form t1 f g)))
(define t4 (nt (mk-term-in-app-form  t2 f g)))
(pp t3)
(pp t4)

