/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvPlainTextEdit_H
#define MvPlainTextEdit_H

#ifdef METVIEW_QT5
 #include <QtWidgets/QPlainTextEdit>
#else
 #include <QtGui/QPlainTextEdit>
#endif
#include "TabsSettings.h"

class LineNumberArea;


// ----------------------------------------------------------------------------
// MvPlainTextEdit
// This class extends the QPlainTextEdit with the following abilities:
//  o allow user-configurable behaviour when the TAB key is pressed
//    (insert tab character or multiple spaces)
//  o auto-indent when RETURN is pressed
//  o line number widget down the left-hand side (code adapted from Qt example)
// ----------------------------------------------------------------------------

class MvPlainTextEdit : public QPlainTextEdit
{
    Q_OBJECT

public:
    MvPlainTextEdit(QWidget * parent = 0);
	~MvPlainTextEdit();

    void lineNumberAreaPaintEvent(QPaintEvent *event);
    int  lineNumberAreaWidth();


    bool useSpacesForTabs()                {return tabsSettings_.useSpacesForTabs;}
    void setUseSpacesForTabs(bool use)     {tabsSettings_.useSpacesForTabs = use;}

    int numSpacesInTab()                   {return tabsSettings_.numSpacesInTab;}
    void setNumSpacesInTab (int num)       {tabsSettings_.numSpacesInTab = num;}

    bool useSpacesForDrops()               {return tabsSettings_.useSpacesForDrops;}
    void setUseSpacesForDrops(bool use)    {tabsSettings_.useSpacesForDrops = use;}

    bool displayTabsAndSpaces()            {return tabsSettings_.displayTabsAndSpaces;}
    void setDisplayTabsAndSpaces(bool yes);

    bool autoIndent()                      {return tabsSettings_.autoIndent;}
    void setAutoIndent(bool yes)           {tabsSettings_.autoIndent = yes;}

    TabsSettings &tabsSettings()           {return tabsSettings_;}

    bool showLineNumbers()                 {return showLineNumbers_;}
    void setShowLineNumbers(bool yes)      {showLineNumbers_ = yes; lineNumberArea->setVisible(yes); updateLineNumberAreaWidth(0);}

    void insertTextIndent(QTextCursor &cursor, bool intelligentIndent);
    void cursorRowCol(int *row, int *col);
    QChar characterBehindCursor(QTextCursor *cursor=0);

    int numLinesSelected();


 private slots:
     void updateLineNumberAreaWidth(int newBlockCount);
     void updateLineNumberArea(const QRect &, int);

signals:
    void focusRegained ();
    void focusLost ();


protected:
    void keyPressEvent(QKeyEvent *e);
    void resizeEvent(QResizeEvent *event);
    void focusInEvent(QFocusEvent *event);
    void focusOutEvent(QFocusEvent *event);
     
    void dragEnterEvent(QDragEnterEvent *);
    void dragMoveEvent(QDragMoveEvent *);
    void dropEvent(QDropEvent *);
     
private:
    void autoIndentNewLine ();
    TabsSettings tabsSettings_;
    bool showLineNumbers_;
    QWidget *lineNumberArea;
};



class LineNumberArea : public QWidget
{
public:
    LineNumberArea(MvPlainTextEdit *editor) : QWidget(editor) {textEditor = editor;}
    QSize sizeHint() const {return QSize(textEditor->lineNumberAreaWidth(), 0);}

protected:
    void paintEvent(QPaintEvent *event) { textEditor->lineNumberAreaPaintEvent(event);}

private:
    MvPlainTextEdit *textEditor;
};



#endif
